/*
 * Decompiled with CFR 0.152.
 */
package com.keenfin.audioview;

import android.content.BroadcastReceiver;
import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.content.ServiceConnection;
import android.net.Uri;
import android.os.IBinder;
import android.support.annotation.Nullable;
import android.util.AttributeSet;
import android.util.Log;
import android.view.View;
import android.widget.SeekBar;
import com.keenfin.audioview.AudioService;
import com.keenfin.audioview.BaseAudioView;
import com.keenfin.audioview.R;
import java.io.FileDescriptor;
import java.io.IOException;
import java.util.List;

public class AudioView2
extends BaseAudioView
implements View.OnClickListener {
    private boolean mFrozen = false;
    private boolean mAutoStartService = true;
    private int mSeekTo = -1;
    private int mTag;
    private int mServiceNotificationId = 1;
    private int mServiceNotificationIcon = R.drawable.thumb;
    private boolean mServiceNotificationShowClose = true;
    private boolean mServiceNotificationMinified = false;
    protected Object mDataSource;
    private AudioService.AudioServiceBinder mServiceBinder = null;
    private View mClickedView;
    private boolean mFixPlayback;
    private ServiceConnection mServiceConnection = new ServiceConnection(){

        public void onServiceConnected(ComponentName componentName, IBinder iBinder) {
            AudioView2.this.mServiceBinder = (AudioService.AudioServiceBinder)iBinder;
            if (AudioView2.this.mFixPlayback) {
                AudioView2.this.onClick(AudioView2.this.findViewById(R.id.play));
                AudioView2.this.mFixPlayback = false;
            }
        }

        public void onServiceDisconnected(ComponentName componentName) {
            AudioView2.this.mServiceBinder = null;
            try {
                AudioView2.this.getContext().unregisterReceiver(AudioView2.this.mAudioReceiver);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    };
    private BroadcastReceiver mAudioReceiver = new BroadcastReceiver(){

        public void onReceive(Context context, Intent intent) {
            int status = intent.getIntExtra("status", -1);
            switch (status) {
                case 2: 
                case 3: {
                    AudioView2.this.setPlayIcon();
                    break;
                }
                case 7: {
                    if (!AudioView2.this.mAutoStartService || intent.getIntExtra("tag", Integer.MIN_VALUE) != AudioView2.this.mTag) break;
                    if (AudioView2.this.mServiceBinder != null) {
                        AudioView2.this.onClick(AudioView2.this.findViewById(R.id.play));
                        break;
                    }
                    AudioView2.this.mFixPlayback = true;
                    break;
                }
                case 8: {
                    AudioView2.this.unbindAudioService();
                    AudioView2.this.mServiceBinder = null;
                    AudioView2.this.mProgress.setProgress(0);
                    if (AudioView2.this.mTime == null) break;
                    AudioView2.this.mTime.setText((CharSequence)"");
                }
            }
            if (AudioView2.this.getService() == null || !AudioView2.this.attached()) {
                return;
            }
            switch (status) {
                case 0: {
                    if (AudioView2.this.mShowTitle) {
                        try {
                            AudioView2.this.mTitle.setText((CharSequence)AudioView2.this.getService().getTrackTitle());
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                    AudioView2.this.setDuration(AudioView2.this.getService().getTotalDuration());
                    if (AudioView2.this.mAudioViewListener != null) {
                        AudioView2.this.mAudioViewListener.onPrepared();
                    }
                    if (AudioView2.this.mClickedView == null) break;
                    AudioView2.this.onClick(AudioView2.this.mClickedView);
                    AudioView2.this.mClickedView = null;
                    break;
                }
                case 1: {
                    AudioView2.this.setPauseIcon();
                    break;
                }
                case 3: {
                    AudioView2.this.setDuration(AudioView2.this.getService().getTotalDuration());
                    break;
                }
                case 4: {
                    if (AudioView2.this.mFrozen) break;
                    int current = AudioView2.this.getService().getCurrentPosition();
                    if (AudioView2.this.getService().getTotalDuration() < 0) {
                        if (AudioView2.this.mIndeterminate.getVisibility() == 8) {
                            AudioView2.this.setDuration(-1);
                            AudioView2.this.setPauseIcon();
                        }
                        if (AudioView2.this.mTime == null) break;
                        AudioView2.this.mTime.setText((CharSequence)AudioView2.this.getService().formatTime(AudioView2.this.mTotalTime == null));
                        break;
                    }
                    AudioView2.this.mProgress.setProgress(current);
                    break;
                }
                case 5: {
                    AudioView2.this.setDuration(AudioView2.this.getService().getTotalDuration());
                    AudioView2.this.setPlayIcon();
                    if (AudioView2.this.mAudioViewListener == null) break;
                    AudioView2.this.mAudioViewListener.onCompletion();
                    break;
                }
                case 6: {
                    AudioView2.this.mProgress.setProgress(0);
                }
            }
        }
    };

    private AudioService getService() {
        return this.mServiceBinder != null ? this.mServiceBinder.getService() : null;
    }

    public AudioView2(Context context) {
        super(context);
    }

    public AudioView2(Context context, AttributeSet attrs) {
        super(context, attrs);
    }

    public AudioView2(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
    }

    @Override
    protected void init(@Nullable Context context, AttributeSet attrs) {
        super.init(context, attrs);
        if (this.isInEditMode()) {
            return;
        }
        this.mProgress.setOnSeekBarChangeListener(new SeekBar.OnSeekBarChangeListener(){

            public void onProgressChanged(SeekBar seekBar, int progress, boolean fromUser) {
                if (AudioView2.this.getService() == null || !AudioView2.this.attached()) {
                    return;
                }
                if (fromUser) {
                    AudioView2.this.mSeekTo = progress;
                }
                if (AudioView2.this.mTime != null) {
                    AudioView2.this.mTime.setText((CharSequence)AudioView2.this.getService().formatTime(AudioView2.this.mTotalTime == null));
                }
            }

            public void onStartTrackingTouch(SeekBar seekBar) {
                AudioView2.this.mFrozen = true;
            }

            public void onStopTrackingTouch(SeekBar seekBar) {
                if (AudioView2.this.getService() != null && AudioView2.this.getService().isPrepared() && AudioView2.this.attached()) {
                    AudioView2.this.getService().seekTo(AudioView2.this.mSeekTo);
                    if (AudioView2.this.mTime != null) {
                        AudioView2.this.mTime.setText((CharSequence)AudioView2.this.getService().formatTime(AudioView2.this.mTotalTime == null));
                    }
                }
                AudioView2.this.mSeekTo = -1;
                AudioView2.this.mFrozen = false;
            }
        });
    }

    private void bindAudioService() {
        Intent intent = new Intent(this.getContext(), AudioService.class);
        boolean b = this.getContext().getApplicationContext().bindService(intent, this.mServiceConnection, 0);
    }

    private void unbindAudioService() {
        try {
            this.getContext().getApplicationContext().unbindService(this.mServiceConnection);
        }
        catch (Exception ignored) {
            Log.d((String)"AudioView", (String)ignored.getLocalizedMessage());
        }
    }

    protected void onAttachedToWindow() {
        super.onAttachedToWindow();
        this.bindAudioService();
        IntentFilter filter = new IntentFilter("AudioService.STATUS");
        this.getContext().registerReceiver(this.mAudioReceiver, filter);
        if (!this.attached() || this.attached() && !this.getService().isPlaying()) {
            this.setPlayIcon();
        }
    }

    protected void onDetachedFromWindow() {
        super.onDetachedFromWindow();
        this.unbindAudioService();
    }

    @Override
    public void onClick(View view) {
        if (this.mAutoStartService && !AudioService.SERVICE_RUNNING) {
            Intent audioService = new Intent(this.getContext(), AudioService.class);
            audioService.putExtra("tag", this.mTag);
            audioService.putExtra("AUDIO_NOTIFICATION_SHOW_CLOSE", this.mServiceNotificationShowClose);
            audioService.putExtra("AUDIO_NOTIFICATION_MINIFIED", this.mServiceNotificationMinified);
            audioService.putExtra("AUDIO_NOTIFICATION_CHANNEL_ID", this.mServiceNotificationId);
            audioService.putExtra("AUDIO_NOTIFICATION_ICON_RES", this.mServiceNotificationIcon);
            this.getContext().getApplicationContext().startService(audioService);
        }
        if (this.getService() == null) {
            this.bindAudioService();
            return;
        }
        if (!this.attached()) {
            this.getService().attachTag(this.mTag);
            this.setLoop(this.mLoop);
            this.setDataSource(this.mDataSource);
            this.mClickedView = view;
            return;
        }
        int id2 = view.getId();
        if (id2 == R.id.play) {
            this.getService().controlAudio();
        } else if (id2 == R.id.rewind) {
            this.previousTrack();
        } else if (id2 == R.id.forward) {
            this.nextTrack();
        }
    }

    private void setDataSource(Object dataSource) {
        try {
            if (dataSource.getClass() == String.class) {
                this.setDataSource((String)dataSource);
            } else if (dataSource.getClass() == Uri.class) {
                this.setDataSource((Uri)dataSource);
            } else if (dataSource.getClass() == FileDescriptor.class) {
                this.setDataSource((FileDescriptor)dataSource);
            } else if (dataSource.getClass() == List.class) {
                this.setDataSource((List)dataSource);
            }
        }
        catch (IOException | NullPointerException exception) {
            // empty catch block
        }
    }

    @Override
    public void setLoop(boolean loop) {
        super.setLoop(loop);
        if (this.getService() == null || !this.attached()) {
            return;
        }
        this.getService().setLoop(loop);
    }

    @Override
    public void setDataSource(List tracks) throws RuntimeException {
        this.mDataSource = tracks;
        if (this.getService() == null || !this.attached()) {
            return;
        }
        this.getService().setDataSource(tracks);
    }

    @Override
    public void setDataSource(String path) throws IOException {
        this.mDataSource = path;
        if (this.getService() == null || !this.attached()) {
            return;
        }
        if (this.getService().isPlaying()) {
            return;
        }
        this.getService().setDataSource(path);
    }

    @Override
    public void setDataSource(Uri uri) throws IOException {
        this.mDataSource = uri;
        if (this.getService() == null || !this.attached()) {
            return;
        }
        this.getService().setDataSource(uri);
    }

    @Override
    public void setDataSource(FileDescriptor fd) throws IOException {
        this.mDataSource = fd;
        if (this.getService() == null || !this.attached()) {
            return;
        }
        this.getService().setDataSource(fd);
    }

    @Override
    public void start() {
        if (this.getService() != null && this.attached()) {
            this.getService().start();
        }
    }

    @Override
    public void pause() {
        if (this.getService() != null && this.attached()) {
            this.getService().pause();
        }
    }

    @Override
    public void stop() {
        if (this.getService() != null && this.attached()) {
            this.getService().stop();
        }
    }

    @Override
    public void nextTrack() {
        if (this.getService() != null && this.attached()) {
            this.getService().nextTrack();
        }
    }

    @Override
    public void previousTrack() {
        if (this.getService() != null && this.attached()) {
            this.getService().previousTrack();
        }
    }

    public void setTag(int tag) {
        this.mTag = tag;
    }

    public void setAutoStartService(boolean autostart) {
        this.mAutoStartService = autostart;
    }

    public void setServiceNotificationId(int id2) {
        this.mServiceNotificationId = id2;
    }

    public void setServiceNotificationIcon(int icon) {
        this.mServiceNotificationIcon = icon;
    }

    public void setServiceNotificationShowClose(boolean showClose) {
        this.mServiceNotificationShowClose = showClose;
    }

    public void setServiceNotificationMinified(boolean minified) {
        this.mServiceNotificationMinified = minified;
    }

    public boolean attached() {
        return this.getService() != null && this.getService().getAttachedTag() == this.mTag;
    }
}

