/*
 * Decompiled with CFR 0.152.
 */
package com.keenfin.audioview;

import android.content.Context;
import android.media.MediaPlayer;
import android.net.Uri;
import android.os.Handler;
import android.os.Message;
import android.support.annotation.Nullable;
import android.util.AttributeSet;
import android.view.View;
import android.widget.SeekBar;
import com.keenfin.audioview.BaseAudioView;
import com.keenfin.audioview.R;
import com.keenfin.audioview.Util;
import java.io.FileDescriptor;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public class AudioView
extends BaseAudioView
implements View.OnClickListener {
    protected MediaPlayer mMediaPlayer;
    protected ArrayList<Object> mTracks;
    protected Object mCurrentSource;
    protected int mCurrentTrack = 0;
    protected boolean mIsPrepared = false;
    protected boolean mIsAttached = false;
    protected boolean mWasPlaying;
    protected long mProgressDelay;
    protected Handler mHandler;

    public AudioView(Context context) {
        super(context);
    }

    public AudioView(Context context, AttributeSet attrs) {
        super(context, attrs);
    }

    public AudioView(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
    }

    @Override
    protected void init(@Nullable Context context, AttributeSet attrs) {
        super.init(context, attrs);
        if (this.isInEditMode()) {
            return;
        }
        this.mTracks = new ArrayList();
        this.initMediaPlayer();
        this.createUpdateHandler();
        this.mProgress.setOnSeekBarChangeListener(new SeekBar.OnSeekBarChangeListener(){

            public void onProgressChanged(SeekBar seekBar, int progress, boolean fromUser) {
                if (!AudioView.this.mIsPrepared) {
                    return;
                }
                if (fromUser) {
                    try {
                        AudioView.this.mMediaPlayer.seekTo(progress);
                    }
                    catch (IllegalStateException illegalStateException) {
                        // empty catch block
                    }
                }
            }

            public void onStartTrackingTouch(SeekBar seekBar) {
                try {
                    seekBar.setTag((Object)AudioView.this.isPlaying());
                    if (AudioView.this.isPlaying()) {
                        AudioView.this.mMediaPlayer.pause();
                    }
                }
                catch (IllegalStateException illegalStateException) {
                    // empty catch block
                }
            }

            public void onStopTrackingTouch(SeekBar seekBar) {
                try {
                    if (((Boolean)seekBar.getTag()).booleanValue()) {
                        AudioView.this.mMediaPlayer.start();
                    }
                }
                catch (IllegalStateException illegalStateException) {
                    // empty catch block
                }
            }
        });
    }

    private void createUpdateHandler() {
        final Runnable seekBarUpdateTask = new Runnable(){

            @Override
            public void run() {
                AudioView.this.mHandler.sendEmptyMessage(SEEKBAR_STATE.PROGRESS.ordinal());
                AudioView.this.mHandler.postDelayed((Runnable)this, AudioView.this.mProgressDelay);
            }
        };
        this.mHandler = new Handler(this.getContext().getMainLooper(), new Handler.Callback(){
            Thread mUiThread;

            public boolean handleMessage(Message msg) {
                if (msg.what == SEEKBAR_STATE.UNSTICK.ordinal()) {
                    if (this.mUiThread != null && !this.mUiThread.isInterrupted()) {
                        this.mUiThread.interrupt();
                    }
                    return true;
                }
                if (msg.what == SEEKBAR_STATE.STICK.ordinal()) {
                    this.mUiThread = new Thread(seekBarUpdateTask);
                    this.mUiThread.start();
                    AudioView.this.mProgress.setProgress(AudioView.this.getCurrentPosition());
                    return true;
                }
                if (msg.what == SEEKBAR_STATE.PROGRESS.ordinal()) {
                    if (AudioView.this.mIsPrepared) {
                        int current = AudioView.this.getCurrentPosition();
                        if (AudioView.this.mProgress.getProgress() < current) {
                            AudioView.this.mProgress.setProgress(current);
                            if (AudioView.this.mTotalTime != null && AudioView.this.mTime != null) {
                                AudioView.this.mTime.setText((CharSequence)Util.formatTime(AudioView.this.getCurrentPosition()));
                            } else if (AudioView.this.mTime != null) {
                                AudioView.this.mTime.setText((CharSequence)AudioView.this.getTrackTime());
                            }
                        }
                    }
                    return true;
                }
                return false;
            }
        });
    }

    private void initMediaPlayer() {
        boolean fix;
        this.mMediaPlayer = new MediaPlayer();
        this.mMediaPlayer.setOnCompletionListener(new MediaPlayer.OnCompletionListener(){

            public void onCompletion(MediaPlayer mp) {
                if (AudioView.this.isCorrectTrack(AudioView.this.mCurrentTrack + 1)) {
                    ++AudioView.this.mCurrentTrack;
                    AudioView.this.selectTrack(true);
                } else {
                    if (!AudioView.this.mLoop) {
                        AudioView.this.pause();
                        AudioView.this.mProgress.setProgress(AudioView.this.getTotalDuration());
                        if (AudioView.this.mAudioViewListener != null) {
                            AudioView.this.mAudioViewListener.onCompletion();
                        }
                        return;
                    }
                    if (AudioView.this.isCorrectTrack(0)) {
                        AudioView.this.mCurrentTrack = 0;
                        AudioView.this.selectTrack(true);
                    } else {
                        AudioView.this.pause();
                        AudioView.this.start();
                    }
                }
            }
        });
        this.mMediaPlayer.setOnPreparedListener(new MediaPlayer.OnPreparedListener(){

            public void onPrepared(MediaPlayer mp) {
                if (!AudioView.this.mIsAttached) {
                    return;
                }
                AudioView.this.mIsPrepared = true;
                if (AudioView.this.mShowTitle) {
                    try {
                        AudioView.this.mTitle.setText((CharSequence)Util.getTrackTitle(AudioView.this.getContext(), AudioView.this.mCurrentSource));
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                int duration = mp.getDuration();
                AudioView.this.setDuration(duration);
                if (duration > 0) {
                    AudioView.this.mProgressDelay = mp.getDuration() / 100;
                    if (AudioView.this.mProgressDelay < 1000L) {
                        if (AudioView.this.mProgressDelay < 100L) {
                            AudioView.this.mProgressDelay = 100L;
                        }
                    } else {
                        AudioView.this.mProgressDelay = 1000L;
                    }
                }
                if (AudioView.this.mAudioViewListener != null) {
                    AudioView.this.mAudioViewListener.onPrepared();
                }
                if (AudioView.this.mWasPlaying) {
                    try {
                        AudioView.this.mMediaPlayer.start();
                    }
                    catch (IllegalStateException illegalStateException) {
                        // empty catch block
                    }
                    AudioView.this.setPauseIcon();
                } else {
                    AudioView.this.setPlayIcon();
                }
            }
        });
        boolean bl = fix = this.mCurrentSource != null && this.mTracks.size() == 0;
        if (fix) {
            this.mTracks.add(this.mCurrentSource);
        }
        if (this.mTracks.size() > 0) {
            this.selectTrack(false);
        }
        if (fix) {
            this.mTracks.remove(0);
        }
    }

    protected void onAttachedToWindow() {
        super.onAttachedToWindow();
        this.mIsAttached = true;
        if (!this.mIsPrepared) {
            this.initMediaPlayer();
        }
    }

    protected void onDetachedFromWindow() {
        super.onDetachedFromWindow();
        this.mIsAttached = false;
        this.mMediaPlayer.release();
        this.mIsPrepared = false;
    }

    public boolean isPlaying() {
        try {
            return this.mMediaPlayer.isPlaying();
        }
        catch (IllegalStateException illegalStateException) {
            return false;
        }
    }

    @Override
    public void onClick(View v) {
        int i = v.getId();
        if (i == R.id.play) {
            this.controlAudio();
        } else if (i == R.id.rewind) {
            this.previousTrack();
        } else if (i == R.id.forward) {
            this.nextTrack();
        }
    }

    @Override
    public void previousTrack() {
        if (this.isCorrectTrack(this.mCurrentTrack - 1)) {
            --this.mCurrentTrack;
        } else {
            return;
        }
        this.selectTrack(false);
    }

    @Override
    public void nextTrack() {
        if (this.isCorrectTrack(this.mCurrentTrack + 1)) {
            ++this.mCurrentTrack;
        } else {
            return;
        }
        this.selectTrack(false);
    }

    protected boolean isCorrectTrack(int trackPosition) {
        return this.mTracks.size() > 0 && trackPosition >= 0 && trackPosition < this.mTracks.size();
    }

    protected void controlAudio() {
        if (this.mIsPrepared && this.isPlaying()) {
            this.pause();
        } else {
            this.start();
        }
    }

    protected void selectTrack(boolean play) {
        if (this.mTracks.size() < 1) {
            return;
        }
        Object track = this.mTracks.get(this.mCurrentTrack);
        this.mWasPlaying = this.isPlaying() || play;
        try {
            if (track.getClass() == String.class) {
                this.setDataSource((String)track);
            } else if (track.getClass() == Uri.class) {
                this.setDataSource((Uri)track);
            } else if (track.getClass() == FileDescriptor.class) {
                this.setDataSource((FileDescriptor)track);
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    @Override
    public void setDataSource(List tracks) throws RuntimeException {
        if (tracks.size() > 0) {
            boolean isCorrectClass;
            Object itemClass = tracks.get(0);
            boolean bl = isCorrectClass = itemClass instanceof String || itemClass instanceof Uri || itemClass instanceof FileDescriptor;
            if (!isCorrectClass) {
                throw new RuntimeException("AudioView supports only String, Uri, FileDescriptor data sources now.");
            }
            this.mTracks = new ArrayList(tracks);
            this.mCurrentTrack = 0;
            this.selectTrack(false);
        }
    }

    @Override
    public void setDataSource(String path) throws IOException {
        this.reset();
        try {
            this.mMediaPlayer.setDataSource(path);
            this.prepare(path);
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
    }

    @Override
    public void setDataSource(Uri uri) throws IOException {
        this.reset();
        try {
            this.mMediaPlayer.setDataSource(this.getContext(), uri);
            this.prepare(uri);
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
    }

    @Override
    public void setDataSource(FileDescriptor fd) throws IOException {
        this.reset();
        try {
            this.mMediaPlayer.setDataSource(fd);
            this.prepare(fd);
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
    }

    protected void reset() {
        this.mIsPrepared = false;
        this.mMediaPlayer.reset();
    }

    protected void prepare(Object source) {
        this.mMediaPlayer.prepareAsync();
        this.mCurrentSource = source;
    }

    @Override
    public void start() {
        if (this.mIsPrepared) {
            try {
                this.mMediaPlayer.start();
            }
            catch (IllegalStateException illegalStateException) {
                // empty catch block
            }
            this.setPauseIcon();
            this.mHandler.sendEmptyMessage(SEEKBAR_STATE.STICK.ordinal());
        }
    }

    @Override
    public void pause() {
        try {
            if (this.mIsPrepared && this.mMediaPlayer.isPlaying()) {
                this.mMediaPlayer.pause();
            }
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
        this.setPlayIcon();
        this.mHandler.sendEmptyMessage(SEEKBAR_STATE.UNSTICK.ordinal());
    }

    @Override
    public void stop() {
        try {
            if (this.mIsPrepared && this.mMediaPlayer.isPlaying()) {
                this.mMediaPlayer.stop();
            }
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
        this.setPlayIcon();
        this.mHandler.sendEmptyMessage(SEEKBAR_STATE.UNSTICK.ordinal());
    }

    public int getCurrentPosition() {
        try {
            return this.mMediaPlayer.getCurrentPosition();
        }
        catch (IllegalStateException illegalStateException) {
            return 0;
        }
    }

    public int getTotalDuration() {
        try {
            return this.mMediaPlayer.getDuration();
        }
        catch (IllegalStateException illegalStateException) {
            return 0;
        }
    }

    protected String getTrackTime() {
        return Util.formatTime(this.getCurrentPosition()) + " / " + Util.formatTime(this.getTotalDuration());
    }

    static enum SEEKBAR_STATE {
        STICK,
        UNSTICK,
        PROGRESS;

    }
}

