/*
 * Decompiled with CFR 0.152.
 */
package com.keenfin.audioview;

import android.annotation.TargetApi;
import android.app.NotificationChannel;
import android.app.NotificationManager;
import android.app.PendingIntent;
import android.app.Service;
import android.content.Context;
import android.content.Intent;
import android.media.MediaPlayer;
import android.net.Uri;
import android.os.Binder;
import android.os.Build;
import android.os.IBinder;
import android.support.annotation.Nullable;
import android.support.v4.app.NotificationCompat;
import android.widget.RemoteViews;
import com.keenfin.audioview.R;
import com.keenfin.audioview.Util;
import java.io.FileDescriptor;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public class AudioService
extends Service {
    public static final String ACTION_START_AUDIO = "AudioService.START";
    public static final String ACTION_STOP_AUDIO = "AudioService.STOP";
    public static final String ACTION_PAUSE_AUDIO = "AudioService.PAUSE";
    public static final String ACTION_STATUS_AUDIO = "AudioService.STATUS";
    public static final String ACTION_CONTROL_AUDIO = "AudioService.CONTROL";
    public static final String ACTION_NEXT_AUDIO = "AudioService.NEXT";
    public static final String ACTION_PREVIOUS_AUDIO = "AudioService.PREVIOUS";
    public static final String ACTION_DESTROY_SERVICE = "AudioService.DESTROY";
    public static final String AUDIO_NOTIFICATION_CHANNEL_ID = "AUDIO_NOTIFICATION_CHANNEL_ID";
    public static final String AUDIO_NOTIFICATION_ICON_RES = "AUDIO_NOTIFICATION_ICON_RES";
    public static final String AUDIO_NOTIFICATION_SHOW_CLOSE = "AUDIO_NOTIFICATION_SHOW_CLOSE";
    public static final String AUDIO_NOTIFICATION_MINIFIED = "AUDIO_NOTIFICATION_MINIFIED";
    public static final int AUDIO_SERVICE_NOTIFICATION = 4;
    public static final int AUDIO_PREPARED = 0;
    public static final int AUDIO_STARTED = 1;
    public static final int AUDIO_PAUSED = 2;
    public static final int AUDIO_STOPPED = 3;
    public static final int AUDIO_PROGRESS_UPDATED = 4;
    public static final int AUDIO_COMPLETED = 5;
    public static final int AUDIO_TRACK_CHANGED = 6;
    public static final int AUDIO_SERVICE_STARTED = 7;
    public static final int AUDIO_SERVICE_STOPPED = 8;
    public static boolean SERVICE_RUNNING = false;
    private Thread mUiThread;
    private long mProgressDelay = 1000L;
    private MediaPlayer mMediaPlayer;
    private boolean mIsPrepared = false;
    private int mAttachedTag = Integer.MIN_VALUE;
    private ArrayList<Object> mTracks;
    private Object mCurrentSource;
    private int mCurrentTrack = 0;
    private boolean mWasPlaying;
    private boolean mLoop = false;
    private AudioServiceBinder mBinder = new AudioServiceBinder();
    private NotificationManager mNotificationManager;
    private NotificationCompat.Builder mBuilder;
    private RemoteViews mContentView;
    private RemoteViews mContentViewMin;

    @Nullable
    public IBinder onBind(Intent intent) {
        return this.mBinder;
    }

    public void onCreate() {
        super.onCreate();
        this.initMediaPlayer();
        this.mNotificationManager = (NotificationManager)this.getSystemService("notification");
        SERVICE_RUNNING = true;
    }

    public void onLowMemory() {
        super.onLowMemory();
        this.broadcast(3);
        this.release();
    }

    public void onDestroy() {
        this.broadcast(3);
        this.broadcast(8);
        this.release();
        this.stopSelf();
        super.onDestroy();
    }

    public int onStartCommand(Intent intent, int flags, int startId) {
        String action = "";
        if (intent != null && intent.getAction() != null) {
            action = intent.getAction();
        }
        switch (action) {
            case "AudioService.NEXT": {
                this.nextTrack();
                break;
            }
            case "AudioService.PREVIOUS": {
                this.previousTrack();
                break;
            }
            case "AudioService.CONTROL": {
                this.controlAudio();
                break;
            }
            case "AudioService.START": {
                this.start();
                break;
            }
            case "AudioService.PAUSE": {
                this.pause();
                break;
            }
            case "AudioService.STOP": {
                this.stop();
                break;
            }
            case "AudioService.DESTROY": {
                this.stopForeground(true);
                this.stopSelf();
                return 2;
            }
            default: {
                int id2 = 1;
                int icon = R.drawable.thumb;
                boolean showClose = true;
                boolean minified = false;
                if (intent != null) {
                    id2 = intent.getIntExtra(AUDIO_NOTIFICATION_CHANNEL_ID, id2);
                    icon = intent.getIntExtra(AUDIO_NOTIFICATION_ICON_RES, icon);
                    showClose = intent.getBooleanExtra(AUDIO_NOTIFICATION_SHOW_CLOSE, true);
                    minified = intent.getBooleanExtra(AUDIO_NOTIFICATION_MINIFIED, false);
                    this.mAttachedTag = intent.getIntExtra("tag", Integer.MIN_VALUE);
                }
                this.addNotification(id2, icon, showClose, minified);
                this.broadcast(7);
                this.mAttachedTag = Integer.MIN_VALUE;
            }
        }
        return 1;
    }

    private PendingIntent getPendingIntent(int code, Intent intent) {
        PendingIntent pendingIntent = Build.VERSION.SDK_INT >= 26 ? PendingIntent.getForegroundService((Context)this, (int)code, (Intent)intent, (int)0x8000000) : PendingIntent.getService((Context)this, (int)code, (Intent)intent, (int)0x8000000);
        return pendingIntent;
    }

    private void addNotification(int channelId, int icon, boolean showClose, boolean minified) {
        this.mContentView = new RemoteViews(this.getPackageName(), R.layout.audio_notification);
        this.mContentViewMin = new RemoteViews(this.getPackageName(), R.layout.audio_notification_minified);
        this.mContentView.setTextViewText(R.id.title, (CharSequence)this.getString(R.string.no_title));
        this.mContentViewMin.setTextViewText(R.id.title, (CharSequence)this.getString(R.string.no_title));
        Intent intent = new Intent((Context)this, AudioService.class);
        intent.setAction(ACTION_CONTROL_AUDIO);
        PendingIntent pendingIntent = this.getPendingIntent(94, intent);
        this.mContentView.setOnClickPendingIntent(R.id.play, pendingIntent);
        if (!minified) {
            intent.setAction(ACTION_PREVIOUS_AUDIO);
            pendingIntent = this.getPendingIntent(73, intent);
            this.mContentView.setOnClickPendingIntent(R.id.rewind, pendingIntent);
            intent.setAction(ACTION_NEXT_AUDIO);
            pendingIntent = this.getPendingIntent(68, intent);
            this.mContentView.setOnClickPendingIntent(R.id.forward, pendingIntent);
        } else {
            this.mContentView.setViewVisibility(R.id.title, 8);
            this.mContentView.setViewVisibility(R.id.rewind, 8);
            this.mContentView.setViewVisibility(R.id.forward, 8);
        }
        if (showClose) {
            intent.setAction(ACTION_DESTROY_SERVICE);
            pendingIntent = this.getPendingIntent(34, intent);
            this.mContentView.setOnClickPendingIntent(R.id.close, pendingIntent);
        } else {
            this.mContentView.setViewVisibility(R.id.close, 8);
        }
        this.mBuilder = this.createBuilder((Context)this, channelId).setAutoCancel(false).setOngoing(true).setSmallIcon(icon).setContent(this.mContentView).setCustomContentView(this.mContentViewMin).setCustomBigContentView(this.mContentView).setStyle((NotificationCompat.Style)new NotificationCompat.DecoratedCustomViewStyle()).setWhen(System.currentTimeMillis());
        this.startForeground(4, this.mBuilder.build());
    }

    private NotificationCompat.Builder createBuilder(Context context, int id2) {
        if (Build.VERSION.SDK_INT >= 26) {
            return this.createBuilderO(context, id2);
        }
        return new NotificationCompat.Builder(context);
    }

    @TargetApi(value=26)
    private NotificationCompat.Builder createBuilderO(Context context, int id2) {
        String channelId = "com.keenfin.audioview_" + id2;
        String channelName = context.getString(R.string.audio_channel);
        NotificationChannel chanel = new NotificationChannel(channelId, (CharSequence)channelName, 2);
        chanel.setLockscreenVisibility(1);
        NotificationManager manager = (NotificationManager)context.getSystemService("notification");
        manager.createNotificationChannel(chanel);
        return new NotificationCompat.Builder(context, channelId);
    }

    private void initMediaPlayer() {
        this.mTracks = new ArrayList();
        this.mMediaPlayer = new MediaPlayer();
        this.mMediaPlayer.setOnCompletionListener(new MediaPlayer.OnCompletionListener(){

            public void onCompletion(MediaPlayer mp) {
                if (!AudioService.this.mIsPrepared) {
                    return;
                }
                if (AudioService.this.isCorrectTrack(AudioService.this.mCurrentTrack + 1)) {
                    AudioService.this.mCurrentTrack++;
                    AudioService.this.selectTrack(true);
                } else {
                    if (!AudioService.this.mLoop) {
                        AudioService.this.broadcast(5);
                        AudioService.this.setDataSource(AudioService.this.mCurrentSource);
                        return;
                    }
                    if (AudioService.this.isCorrectTrack(0)) {
                        AudioService.this.mCurrentTrack = 0;
                        AudioService.this.selectTrack(true);
                    } else {
                        AudioService.this.pause();
                        AudioService.this.broadcast(6);
                        AudioService.this.start();
                    }
                }
            }
        });
        this.mMediaPlayer.setOnPreparedListener(new MediaPlayer.OnPreparedListener(){

            public void onPrepared(MediaPlayer mp) {
                AudioService.this.mIsPrepared = true;
                int duration = mp.getDuration();
                if (duration > 0) {
                    AudioService.this.mProgressDelay = mp.getDuration() / 100;
                    if (AudioService.this.mProgressDelay < 1000L) {
                        if (AudioService.this.mProgressDelay < 100L) {
                            AudioService.this.mProgressDelay = 100L;
                        }
                    } else {
                        AudioService.this.mProgressDelay = 1000L;
                    }
                }
                if (AudioService.this.mWasPlaying) {
                    mp.start();
                    AudioService.this.mWasPlaying = false;
                }
                AudioService.this.mContentView.setTextViewText(R.id.title, (CharSequence)AudioService.this.getTrackTitle());
                AudioService.this.mContentViewMin.setTextViewText(R.id.title, (CharSequence)AudioService.this.getTrackTitle());
                AudioService.this.mNotificationManager.notify(4, AudioService.this.mBuilder.build());
                AudioService.this.broadcast(0);
            }
        });
    }

    private void startUpdateThread() {
        if (this.mUiThread == null || this.mUiThread.isInterrupted() || this.mUiThread.isAlive() || this.mUiThread.getState() != Thread.State.NEW) {
            this.mUiThread = new Thread(){

                @Override
                public void run() {
                    while (!this.isInterrupted()) {
                        try {
                            Thread.sleep(AudioService.this.mProgressDelay);
                            if (!AudioService.this.mIsPrepared || !AudioService.this.isPlaying()) continue;
                            AudioService.this.broadcast(4);
                        }
                        catch (IllegalStateException | InterruptedException exception) {}
                    }
                }
            };
        }
        try {
            this.mUiThread.start();
        }
        catch (IllegalThreadStateException illegalThreadStateException) {
            // empty catch block
        }
    }

    public int getAttachedTag() {
        return this.mAttachedTag;
    }

    public void attachTag(int tag) {
        this.stop();
        this.mAttachedTag = tag;
    }

    private void broadcast(int type) {
        Intent broadcast = new Intent(ACTION_STATUS_AUDIO);
        broadcast.putExtra("status", type);
        broadcast.putExtra("tag", this.mAttachedTag);
        this.sendBroadcast(broadcast);
    }

    public boolean isPrepared() {
        return this.mIsPrepared;
    }

    public boolean isPlaying() {
        try {
            return this.mMediaPlayer.isPlaying();
        }
        catch (IllegalStateException ignored) {
            return false;
        }
    }

    public int getCurrentPosition() {
        try {
            return this.mMediaPlayer.getCurrentPosition();
        }
        catch (IllegalStateException ignored) {
            return 0;
        }
    }

    public int getTotalDuration() {
        try {
            return this.mMediaPlayer.getDuration();
        }
        catch (IllegalStateException | NullPointerException ignored) {
            return 0;
        }
    }

    public void controlAudio() {
        if (this.mIsPrepared && this.isPlaying()) {
            this.pause();
        } else {
            this.start();
        }
    }

    public void previousTrack() {
        if (this.isCorrectTrack(this.mCurrentTrack - 1)) {
            --this.mCurrentTrack;
        } else {
            return;
        }
        this.selectTrack();
    }

    public void nextTrack() {
        if (this.isCorrectTrack(this.mCurrentTrack + 1)) {
            ++this.mCurrentTrack;
        } else {
            return;
        }
        this.selectTrack();
    }

    private boolean isCorrectTrack(int trackPosition) {
        return this.mTracks.size() > 0 && trackPosition >= 0 && trackPosition < this.mTracks.size();
    }

    private void selectTrack() {
        boolean wasPlaying = this.isPlaying();
        this.selectTrack(wasPlaying);
    }

    private void selectTrack(boolean wasPlaying) {
        if (this.mTracks.size() < 1) {
            return;
        }
        this.mWasPlaying = wasPlaying;
        Object track = this.mTracks.get(this.mCurrentTrack);
        try {
            if (track.getClass() == String.class) {
                this.setDataSource((String)track);
            } else if (track.getClass() == Uri.class) {
                this.setDataSource((Uri)track);
            } else if (track.getClass() == FileDescriptor.class) {
                this.setDataSource((FileDescriptor)track);
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.broadcast(6);
    }

    public void setDataSource(Object dataSource) {
        block6: {
            try {
                if (dataSource.getClass() == String.class) {
                    this.setDataSource((String)dataSource);
                    break block6;
                }
                if (dataSource.getClass() == Uri.class) {
                    this.setDataSource((Uri)dataSource);
                    break block6;
                }
                if (dataSource.getClass() == FileDescriptor.class) {
                    this.setDataSource((FileDescriptor)dataSource);
                    break block6;
                }
                if (dataSource.getClass() == List.class) {
                    this.setDataSource((List)dataSource);
                    break block6;
                }
                throw new IllegalArgumentException("AudioView supports only String, Uri, FileDescriptor data sources now.");
            }
            catch (IOException ignored) {
                throw new IllegalArgumentException("AudioView supports only String, Uri, FileDescriptor data sources now.");
            }
        }
    }

    public void addToPlaylist(Object item) throws RuntimeException {
        if (this.mTracks == null) {
            return;
        }
        if (item.getClass() == String.class) {
            this.mTracks.add(item);
        } else if (item.getClass() == Uri.class) {
            this.mTracks.add(item);
        } else if (item.getClass() == FileDescriptor.class) {
            this.mTracks.add(item);
        } else if (item.getClass() == List.class) {
            this.mTracks.add(item);
        } else {
            throw new IllegalArgumentException("AudioView supports only String, Uri, FileDescriptor data sources now.");
        }
    }

    public void setDataSource(List tracks) throws RuntimeException {
        if (tracks.size() > 0) {
            boolean isCorrectClass;
            Object itemClass = tracks.get(0);
            boolean bl = isCorrectClass = itemClass instanceof String || itemClass instanceof Uri || itemClass instanceof FileDescriptor;
            if (!isCorrectClass) {
                throw new RuntimeException("AudioView supports only String, Uri, FileDescriptor data sources now.");
            }
            this.mTracks = new ArrayList(tracks);
            this.mCurrentTrack = 0;
            this.selectTrack();
        }
    }

    public void setDataSource(String path) throws IOException {
        this.reset();
        try {
            this.mMediaPlayer.setDataSource(path);
            this.prepare(path);
        }
        catch (IllegalStateException e) {
            this.initMediaPlayer();
        }
    }

    public void setDataSource(Uri uri) throws IOException {
        this.reset();
        try {
            this.mMediaPlayer.setDataSource((Context)this, uri);
            this.prepare(uri);
        }
        catch (IllegalStateException e) {
            this.initMediaPlayer();
        }
    }

    public void setDataSource(FileDescriptor fd) throws IOException {
        this.reset();
        try {
            this.mMediaPlayer.setDataSource(fd);
            this.prepare(fd);
        }
        catch (IllegalStateException e) {
            this.initMediaPlayer();
        }
    }

    private void release() {
        this.mAttachedTag = Integer.MIN_VALUE;
        try {
            if (this.mIsPrepared) {
                this.mMediaPlayer.stop();
            }
            this.mMediaPlayer.release();
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.mIsPrepared = false;
        SERVICE_RUNNING = false;
    }

    public void reset() {
        this.mIsPrepared = false;
        try {
            this.mMediaPlayer.reset();
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (this.mUiThread != null) {
            this.mUiThread.interrupt();
        }
    }

    private void prepare(Object source) {
        try {
            this.mMediaPlayer.prepareAsync();
            this.mCurrentSource = source;
        }
        catch (IllegalStateException e) {
            e.printStackTrace();
        }
    }

    public void start() {
        this.mContentView.setImageViewResource(R.id.play, R.drawable.ic_pause_white_24dp);
        this.mNotificationManager.notify(4, this.mBuilder.build());
        if (this.mIsPrepared) {
            try {
                this.mMediaPlayer.start();
                this.broadcast(1);
                this.startUpdateThread();
            }
            catch (IllegalStateException illegalStateException) {
                // empty catch block
            }
        }
    }

    public void pause() {
        this.mContentView.setImageViewResource(R.id.play, R.drawable.ic_play_arrow_white_24dp);
        this.mNotificationManager.notify(4, this.mBuilder.build());
        try {
            if (this.mIsPrepared && this.mMediaPlayer.isPlaying()) {
                this.mMediaPlayer.pause();
            }
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
        if (this.mUiThread != null) {
            this.mUiThread.interrupt();
        }
        this.broadcast(2);
    }

    public void stop() {
        this.mContentView.setImageViewResource(R.id.play, R.drawable.ic_play_arrow_white_24dp);
        this.mNotificationManager.notify(4, this.mBuilder.build());
        try {
            if (this.mIsPrepared) {
                this.mMediaPlayer.stop();
            }
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
        if (this.mUiThread != null) {
            this.mUiThread.interrupt();
        }
        this.broadcast(3);
    }

    public void seekTo(Integer progress) {
        try {
            this.mMediaPlayer.seekTo(progress.intValue());
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
    }

    public void setLoop(boolean loop) {
        this.mLoop = loop;
    }

    public String getTrackTitle() {
        return Util.getTrackTitle((Context)this, this.mCurrentSource);
    }

    public String formatTime(boolean full) {
        int current = this.getCurrentPosition();
        if (full) {
            return Util.formatTime(current) + " / " + Util.formatTime(this.getTotalDuration());
        }
        return Util.formatTime(current);
    }

    public class AudioServiceBinder
    extends Binder {
        public AudioService getService() {
            return AudioService.this;
        }
    }
}

