/*
 * Decompiled with CFR 0.152.
 */
package com.andrefilgs.fileman;

import android.content.Context;
import android.os.StatFs;
import com.andrefilgs.fileman.FilemanDrivers;
import com.andrefilgs.fileman.auxiliar.FilemanLogger;
import com.andrefilgs.fileman.utils.ExtensionsKt;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.Charset;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\u0018\u0000 \u00032\u00020\u0001:\u0001\u0003B\u0005\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0004"}, d2={"Lcom/andrefilgs/fileman/Fileman;", "", "()V", "Companion", "fileman_release"})
public final class Fileman {
    public static final Companion Companion = new Companion(null);

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\t\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u0002\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001e\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nJ\u000e\u0010\u000b\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006J>\u0010\f\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\r\u001a\u00020\b2\u0006\u0010\u000e\u001a\u00020\n2\u0006\u0010\u000f\u001a\u00020\n2\u0006\u0010\u0010\u001a\u00020\b2\u0006\u0010\u0011\u001a\u00020\n2\u0006\u0010\u0012\u001a\u00020\nJ\u0016\u0010\u0013\u001a\u00020\u00042\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0015J \u0010\u0017\u001a\u0004\u0018\u00010\u00152\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0018\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nJ0\u0010\u0019\u001a\u0004\u0018\u00010\u001a2\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\u001b\u001a\u00020\n2\u0006\u0010\u001c\u001a\u00020\n2\u0006\u0010\u001d\u001a\u00020\u0004J&\u0010\u001e\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\u001b\u001a\u00020\n2\u0006\u0010\u001f\u001a\u00020\nJ&\u0010 \u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u001c\u001a\u00020\nJ\u000e\u0010!\u001a\u00020\"2\u0006\u0010#\u001a\u00020\u0015J\u000e\u0010$\u001a\u00020\"2\u0006\u0010%\u001a\u00020\nJ(\u0010&\u001a\u0004\u0018\u00010\u00152\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u001c\u001a\u00020\nJ(\u0010'\u001a\u0004\u0018\u00010\n2\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010(\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u001c\u001a\u00020\nJ \u0010)\u001a\u0004\u0018\u00010\u00152\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nJ \u0010*\u001a\u0004\u0018\u00010\n2\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010(\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nJ(\u0010+\u001a\u0004\u0018\u00010,2\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\u001b\u001a\u00020\n2\u0006\u0010\u001f\u001a\u00020\nJ\r\u0010-\u001a\u00020\"H\u0000\u00a2\u0006\u0002\b.J\u000e\u0010/\u001a\u00020\"2\u0006\u0010%\u001a\u00020\nJ(\u00100\u001a\u0004\u0018\u00010\n2\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\u001b\u001a\u00020\n2\u0006\u0010\u001f\u001a\u00020\nJ\u0016\u00101\u001a\u00020\u00042\u0006\u00102\u001a\u00020\u00152\u0006\u00103\u001a\u00020\nJ\u0016\u00104\u001a\u0002052\u0006\u00102\u001a\u00020\u00152\u0006\u00106\u001a\u00020\nJ6\u00107\u001a\u00020\u00042\u0006\u00108\u001a\u00020\n2\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\u001b\u001a\u00020\n2\u0006\u0010\u001f\u001a\u00020\n2\u0006\u0010\u001d\u001a\u00020\u0004\u00a8\u00069"}, d2={"Lcom/andrefilgs/fileman/Fileman$Companion;", "", "()V", "checkFolder", "", "context", "Landroid/content/Context;", "drive", "", "folderStr", "", "checkSDCardExists", "copyFileTo", "driveSrc", "folderSrc", "filenameSrc", "driveDest", "folderDest", "filenameDest", "copyToDirectory", "sourceLocation", "Ljava/io/File;", "targetLocation", "createFolder", "driveStr", "createOutputFile", "Ljava/io/OutputStream;", "folder", "fileName", "append", "delete", "filename", "deleteFile", "dirSize", "", "dir", "getAvailableMemorySize", "mPath", "getFile", "getFilenameFullPath", "driveInt", "getFolder", "getFullPath", "getInputStreamFile", "Ljava/io/InputStream;", "getNow", "getNow$fileman_release", "getTotalMemorySize", "read", "removeTempExtension", "currentFile", "tempExtension", "renameFile", "", "newFilename", "write", "fileContent", "fileman_release"})
    public static final class Companion {
        public final boolean write(@NotNull String fileContent, @NotNull Context context, int drive, @NotNull String folder, @NotNull String filename, boolean append) {
            boolean bl;
            Intrinsics.checkParameterIsNotNull((Object)fileContent, (String)"fileContent");
            Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
            Intrinsics.checkParameterIsNotNull((Object)folder, (String)"folder");
            Intrinsics.checkParameterIsNotNull((Object)filename, (String)"filename");
            OutputStream outputStream = this.createOutputFile(context, drive, folder, filename, append);
            if (outputStream == null) {
                return false;
            }
            OutputStream out = outputStream;
            try {
                String string = fileContent;
                OutputStream outputStream2 = out;
                Charset charset = Charsets.UTF_8;
                boolean bl2 = false;
                byte[] byArray = string.getBytes(charset);
                Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"(this as java.lang.String).getBytes(charset)");
                byte[] byArray2 = byArray;
                outputStream2.write(byArray2);
                out.close();
                FilemanLogger.d$fileman_release$default(FilemanLogger.INSTANCE, "File " + filename + " write with success.\nContent is " + fileContent, null, 2, null);
                bl = true;
            }
            catch (IOException e) {
                e.printStackTrace();
                bl = false;
            }
            return bl;
        }

        @Nullable
        public final String read(@NotNull Context context, int drive, @NotNull String folder, @NotNull String filename) {
            Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
            Intrinsics.checkParameterIsNotNull((Object)folder, (String)"folder");
            Intrinsics.checkParameterIsNotNull((Object)filename, (String)"filename");
            InputStream inputStream = this.getInputStreamFile(context, drive, folder, filename);
            String content = null;
            try {
                InputStream inputStream2 = inputStream;
                if (inputStream2 != null) {
                    String string;
                    InputStream inputStream3 = inputStream2;
                    boolean bl = false;
                    boolean bl2 = false;
                    InputStream it = inputStream3;
                    boolean bl3 = false;
                    int size = inputStream.available();
                    byte[] buffer = new byte[size];
                    inputStream.read(buffer);
                    inputStream.close();
                    Charset charset = Charsets.UTF_8;
                    boolean bl4 = false;
                    content = string = new String(buffer, charset);
                    FilemanLogger.d$fileman_release$default(FilemanLogger.INSTANCE, "File " + filename + " read with success.\nFile content is: " + content, null, 2, null);
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
                return null;
            }
            return content;
        }

        public final boolean delete(@NotNull Context context, int drive, @NotNull String folder, @NotNull String filename) {
            boolean bl;
            Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
            Intrinsics.checkParameterIsNotNull((Object)folder, (String)"folder");
            Intrinsics.checkParameterIsNotNull((Object)filename, (String)"filename");
            try {
                File file = new File(this.getFolder(context, drive, folder), filename);
                file.delete();
                bl = true;
            }
            catch (Exception e) {
                e.printStackTrace();
                bl = false;
            }
            return bl;
        }

        public final long getNow$fileman_release() {
            return System.currentTimeMillis();
        }

        @Nullable
        public final String getFilenameFullPath(@NotNull Context context, int driveInt, @NotNull String folderStr, @NotNull String fileName) {
            Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
            Intrinsics.checkParameterIsNotNull((Object)folderStr, (String)"folderStr");
            Intrinsics.checkParameterIsNotNull((Object)fileName, (String)"fileName");
            String string = this.getFullPath(context, driveInt, folderStr);
            if (string == null) {
                return null;
            }
            String fullPath = string;
            return fullPath + '/' + fileName;
        }

        /*
         * Enabled aggressive block sorting
         */
        @Nullable
        public final String getFullPath(@NotNull Context context, int driveInt, @NotNull String folderStr) {
            Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
            Intrinsics.checkParameterIsNotNull((Object)folderStr, (String)"folderStr");
            String driveStringName = "";
            String pathStr = null;
            if (driveInt == FilemanDrivers.SandBox.getType()) {
                File file = context.getFilesDir();
                Intrinsics.checkExpressionValueIsNotNull((Object)file, (String)"context.filesDir");
                String string = file.getAbsolutePath();
                Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"context.filesDir.absolutePath");
                driveStringName = string;
                return driveStringName + folderStr;
            } else if (driveInt == FilemanDrivers.Internal.getType()) {
                File[] path = context.getExternalFilesDirs(null);
                if (path[0] == null) {
                    FilemanLogger.d$fileman_release$default(FilemanLogger.INSTANCE, "No emulator", null, 2, null);
                    return null;
                }
                File file = path[0];
                Intrinsics.checkExpressionValueIsNotNull((Object)file, (String)"path[0]");
                String string = file.getPath();
                Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"path[0].path");
                driveStringName = string;
                return driveStringName + folderStr;
            } else {
                if (driveInt != FilemanDrivers.External.getType()) return driveStringName + folderStr;
                File[] path = context.getExternalFilesDirs(null);
                if (path.length >= 2 && path[1] != null) {
                    File file = path[1];
                    Intrinsics.checkExpressionValueIsNotNull((Object)file, (String)"path[1]");
                    String string = file.getPath();
                    Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"path[1].path");
                    driveStringName = string;
                    return driveStringName + folderStr;
                } else {
                    FilemanLogger.d$fileman_release$default(FilemanLogger.INSTANCE, "No SD card available", null, 2, null);
                    return null;
                }
            }
        }

        @Nullable
        public final File createFolder(@NotNull Context context, int driveStr, @NotNull String folderStr) {
            Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
            Intrinsics.checkParameterIsNotNull((Object)folderStr, (String)"folderStr");
            String pathStr = this.getFullPath(context, driveStr, folderStr);
            if (pathStr != null) {
                File fullPath = new File(pathStr);
                if (!fullPath.exists()) {
                    fullPath.mkdirs();
                }
                return fullPath;
            }
            return null;
        }

        @Nullable
        public final OutputStream createOutputFile(@NotNull Context context, int drive, @NotNull String folder, @NotNull String fileName, boolean append) {
            Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
            Intrinsics.checkParameterIsNotNull((Object)folder, (String)"folder");
            Intrinsics.checkParameterIsNotNull((Object)fileName, (String)"fileName");
            File fullPath = this.createFolder(context, drive, folder);
            if (fullPath != null) {
                FileOutputStream fileOutputStream;
                File file = new File(fullPath, fileName);
                try {
                    if (!file.exists()) {
                        file.createNewFile();
                        FilemanLogger.d$fileman_release$default(FilemanLogger.INSTANCE, "File created", null, 2, null);
                    } else {
                        FilemanLogger.d$fileman_release$default(FilemanLogger.INSTANCE, "File already exist", null, 2, null);
                    }
                    fileOutputStream = new FileOutputStream(file, append);
                }
                catch (IOException e) {
                    e.printStackTrace();
                    fileOutputStream = null;
                }
                return fileOutputStream;
            }
            return null;
        }

        public final boolean checkFolder(@NotNull Context context, int drive, @NotNull String folderStr) {
            Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
            Intrinsics.checkParameterIsNotNull((Object)folderStr, (String)"folderStr");
            String string = this.getFullPath(context, drive, folderStr);
            if (string == null) {
                return false;
            }
            String pathStr = string;
            File dirPath = new File(pathStr);
            dirPath.mkdir();
            return dirPath.exists();
        }

        @Nullable
        public final File getFolder(@NotNull Context context, int drive, @NotNull String folderStr) {
            String pathStr;
            Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
            Intrinsics.checkParameterIsNotNull((Object)folderStr, (String)"folderStr");
            if (!this.checkFolder(context, drive, folderStr)) {
                return null;
            }
            String string = pathStr = this.getFullPath(context, drive, folderStr);
            if (string == null) {
                Intrinsics.throwNpe();
            }
            return new File(string);
        }

        @Nullable
        public final InputStream getInputStreamFile(@NotNull Context context, int drive, @NotNull String folder, @NotNull String filename) {
            FileInputStream fileInputStream;
            Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
            Intrinsics.checkParameterIsNotNull((Object)folder, (String)"folder");
            Intrinsics.checkParameterIsNotNull((Object)filename, (String)"filename");
            try {
                File file = new File(this.getFolder(context, drive, folder), filename);
                fileInputStream = new FileInputStream(file);
            }
            catch (IOException ex) {
                ex.printStackTrace();
                fileInputStream = null;
            }
            return fileInputStream;
        }

        /*
         * WARNING - void declaration
         */
        public final boolean copyToDirectory(@NotNull File sourceLocation, @NotNull File targetLocation) throws IOException {
            Intrinsics.checkParameterIsNotNull((Object)sourceLocation, (String)"sourceLocation");
            Intrinsics.checkParameterIsNotNull((Object)targetLocation, (String)"targetLocation");
            try {
                if (sourceLocation.isDirectory()) {
                    String[] children;
                    if (!targetLocation.exists() && !targetLocation.mkdirs()) {
                        throw (Throwable)new IOException("Cannot create dir " + targetLocation.getAbsolutePath());
                    }
                    if (children != null) {
                        String[] stringArray = children = sourceLocation.list();
                        boolean bl = false;
                        boolean bl2 = false;
                        String[] it = stringArray;
                        boolean bl3 = false;
                        int n = 0;
                        int n2 = children.length;
                        while (n < n2) {
                            void i;
                            Companion.copyToDirectory(new File(sourceLocation, children[i]), new File(targetLocation, children[i]));
                            ++i;
                        }
                    }
                } else {
                    File directory = targetLocation.getParentFile();
                    if (directory != null && !directory.exists() && !directory.mkdirs()) {
                        throw (Throwable)new IOException("Cannot create dir " + directory.getAbsolutePath());
                    }
                    InputStream input = new FileInputStream(sourceLocation);
                    OutputStream output = new FileOutputStream(targetLocation);
                    byte[] buf = new byte[1024];
                    Ref.IntRef len = new Ref.IntRef();
                    while (true) {
                        int n = input.read(buf);
                        boolean bl = false;
                        boolean bl4 = false;
                        int it = n;
                        boolean bl5 = false;
                        len.element = it;
                        if (n <= 0) break;
                        output.write(buf, 0, len.element);
                    }
                    input.close();
                    output.close();
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                return false;
            }
            return true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public final boolean copyFileTo(@NotNull Context context, int driveSrc, @NotNull String folderSrc, @NotNull String filenameSrc, int driveDest, @NotNull String folderDest, @NotNull String filenameDest) throws IOException {
            Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
            Intrinsics.checkParameterIsNotNull((Object)folderSrc, (String)"folderSrc");
            Intrinsics.checkParameterIsNotNull((Object)filenameSrc, (String)"filenameSrc");
            Intrinsics.checkParameterIsNotNull((Object)folderDest, (String)"folderDest");
            Intrinsics.checkParameterIsNotNull((Object)filenameDest, (String)"filenameDest");
            InputStream input = this.getInputStreamFile(context, driveSrc, folderSrc, filenameSrc);
            OutputStream out = this.createOutputFile(context, driveDest, folderDest, filenameDest, false);
            if (input == null) {
                throw (Throwable)new IOException("Source path error");
            }
            if (out == null) {
                throw (Throwable)new IOException("Destination path error");
            }
            byte[] buff = new byte[0x100000];
            int read = 0;
            try {
                while (true) {
                    int n = input.read(buff);
                    boolean bl = false;
                    boolean bl2 = false;
                    int it = n;
                    boolean bl3 = false;
                    read = it;
                    if (n > 0) {
                        out.write(buff, 0, read);
                        continue;
                    }
                    break;
                }
            }
            catch (IOException e) {
                e.printStackTrace();
                boolean bl = false;
                return bl;
            }
            finally {
                try {
                    input.close();
                    out.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                    return false;
                }
            }
            return true;
        }

        @Nullable
        public final File getFile(@NotNull Context context, int drive, @NotNull String folderStr, @NotNull String fileName) {
            Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
            Intrinsics.checkParameterIsNotNull((Object)folderStr, (String)"folderStr");
            Intrinsics.checkParameterIsNotNull((Object)fileName, (String)"fileName");
            File folder = this.getFolder(context, drive, folderStr);
            return folder != null ? new File(folder, fileName) : null;
        }

        public final boolean deleteFile(@NotNull Context context, int drive, @NotNull String folderStr, @NotNull String fileName) {
            Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
            Intrinsics.checkParameterIsNotNull((Object)folderStr, (String)"folderStr");
            Intrinsics.checkParameterIsNotNull((Object)fileName, (String)"fileName");
            File file = this.getFile(context, drive, folderStr, fileName);
            if (file == null) {
                return false;
            }
            File file2 = file;
            return file2.delete();
        }

        public final void renameFile(@NotNull File currentFile, @NotNull String newFilename) {
            Intrinsics.checkParameterIsNotNull((Object)currentFile, (String)"currentFile");
            Intrinsics.checkParameterIsNotNull((Object)newFilename, (String)"newFilename");
            String string = currentFile.getAbsolutePath();
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"currentFile.absolutePath");
            String currentLocation = StringsKt.substringBeforeLast$default((String)string, (char)StringsKt.single((CharSequence)"/"), null, (int)2, null);
            File newFile = new File(currentLocation + '/' + newFilename);
            currentFile.renameTo(newFile);
        }

        public final boolean removeTempExtension(@NotNull File currentFile, @NotNull String tempExtension) {
            boolean bl;
            Intrinsics.checkParameterIsNotNull((Object)currentFile, (String)"currentFile");
            Intrinsics.checkParameterIsNotNull((Object)tempExtension, (String)"tempExtension");
            try {
                String string = currentFile.getName();
                Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"currentFile.name");
                String newFilename = ExtensionsKt.subLua(string, 1, currentFile.getName().length() - tempExtension.length());
                this.renameFile(currentFile, newFilename);
                bl = true;
            }
            catch (Exception e) {
                bl = false;
            }
            return bl;
        }

        public final long dirSize(@NotNull File dir) {
            Intrinsics.checkParameterIsNotNull((Object)dir, (String)"dir");
            if (dir.exists()) {
                File[] fileList;
                long result = 0L;
                if (fileList != null) {
                    File[] fileArray = fileList = dir.listFiles();
                    boolean bl = false;
                    boolean bl2 = false;
                    File[] it = fileArray;
                    boolean bl3 = false;
                    File[] $this$forEach$iv = fileList;
                    boolean $i$f$forEach = false;
                    File[] fileArray2 = $this$forEach$iv;
                    int n = fileArray2.length;
                    for (int i = 0; i < n; ++i) {
                        File element$iv;
                        File file = element$iv = fileArray2[i];
                        boolean bl4 = false;
                        File file2 = file;
                        Intrinsics.checkExpressionValueIsNotNull((Object)file2, (String)"file");
                        result += file2.isDirectory() ? Companion.dirSize(file) : file.length();
                    }
                }
                return result;
            }
            return 0L;
        }

        public final long getAvailableMemorySize(@NotNull String mPath) {
            long l;
            Intrinsics.checkParameterIsNotNull((Object)mPath, (String)"mPath");
            try {
                File path = new File(mPath);
                StatFs stat = new StatFs(path.getPath());
                long blockSize = stat.getBlockSizeLong();
                long availableBlocks = stat.getAvailableBlocksLong();
                l = availableBlocks * blockSize;
            }
            catch (Exception e) {
                e.printStackTrace();
                l = 0L;
            }
            return l;
        }

        public final long getTotalMemorySize(@NotNull String mPath) {
            long l;
            Intrinsics.checkParameterIsNotNull((Object)mPath, (String)"mPath");
            try {
                File path = new File(mPath);
                StatFs stat = new StatFs(path.getPath());
                long blockSize = stat.getBlockSizeLong();
                long totalBlocks = stat.getBlockCountLong();
                l = totalBlocks * blockSize;
            }
            catch (Exception e) {
                e.printStackTrace();
                l = 0L;
            }
            return l;
        }

        public final boolean checkSDCardExists(@NotNull Context context) {
            Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
            File[] path = context.getExternalFilesDirs(null);
            return path.length >= 2 && path[1] != null;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

