/*
 * Decompiled with CFR 0.152.
 */
package com.andrefilgs.fileman;

import android.content.Context;
import com.andrefilgs.fileman.FilemanDrivers;
import com.andrefilgs.fileman.auxiliar.FilemanLogger;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.Charset;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\u0018\u0000 \u00032\u00020\u0001:\u0001\u0003B\u0005\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0004"}, d2={"Lcom/andrefilgs/fileman/Fileman;", "", "()V", "Companion", "fileman_release"})
public final class Fileman {
    public static final Companion Companion = new Companion(null);

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0005\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001e\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nJ \u0010\u000b\u001a\u0004\u0018\u00010\f2\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\r\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nJ0\u0010\u000e\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\u0010\u001a\u00020\n2\u0006\u0010\u0011\u001a\u00020\n2\u0006\u0010\u0012\u001a\u00020\u0004J&\u0010\u0013\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\u0010\u001a\u00020\n2\u0006\u0010\u0014\u001a\u00020\nJ(\u0010\u0015\u001a\u0004\u0018\u00010\n2\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0016\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u0011\u001a\u00020\nJ \u0010\u0017\u001a\u0004\u0018\u00010\f2\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nJ \u0010\u0018\u001a\u0004\u0018\u00010\n2\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0016\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nJ(\u0010\u0019\u001a\u0004\u0018\u00010\u001a2\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\u0010\u001a\u00020\n2\u0006\u0010\u0014\u001a\u00020\nJ\r\u0010\u001b\u001a\u00020\u001cH\u0000\u00a2\u0006\u0002\b\u001dJ(\u0010\u001e\u001a\u0004\u0018\u00010\n2\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\u0010\u001a\u00020\n2\u0006\u0010\u0014\u001a\u00020\nJ6\u0010\u001f\u001a\u00020\u00042\u0006\u0010 \u001a\u00020\n2\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\u0010\u001a\u00020\n2\u0006\u0010\u0014\u001a\u00020\n2\u0006\u0010\u0012\u001a\u00020\u0004\u00a8\u0006!"}, d2={"Lcom/andrefilgs/fileman/Fileman$Companion;", "", "()V", "checkFolder", "", "context", "Landroid/content/Context;", "drive", "", "folderStr", "", "createFolder", "Ljava/io/File;", "driveStr", "createOutputFile", "Ljava/io/OutputStream;", "folder", "fileName", "append", "delete", "filename", "getFilenameFullPath", "driveInt", "getFolder", "getFullPath", "getInputStreamFile", "Ljava/io/InputStream;", "getNow", "", "getNow$fileman_release", "read", "write", "fileContent", "fileman_release"})
    public static final class Companion {
        public final boolean write(@NotNull String fileContent, @NotNull Context context, int drive, @NotNull String folder, @NotNull String filename, boolean append) {
            boolean bl;
            Intrinsics.checkParameterIsNotNull((Object)fileContent, (String)"fileContent");
            Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
            Intrinsics.checkParameterIsNotNull((Object)folder, (String)"folder");
            Intrinsics.checkParameterIsNotNull((Object)filename, (String)"filename");
            OutputStream outputStream = this.createOutputFile(context, drive, folder, filename, append);
            if (outputStream == null) {
                return false;
            }
            OutputStream out = outputStream;
            try {
                String string = fileContent;
                OutputStream outputStream2 = out;
                Charset charset = Charsets.UTF_8;
                boolean bl2 = false;
                byte[] byArray = string.getBytes(charset);
                Intrinsics.checkExpressionValueIsNotNull((Object)byArray, (String)"(this as java.lang.String).getBytes(charset)");
                byte[] byArray2 = byArray;
                outputStream2.write(byArray2);
                out.close();
                FilemanLogger.d$fileman_release$default(FilemanLogger.INSTANCE, "File " + filename + " write with success.\nContent is " + fileContent, null, 2, null);
                bl = true;
            }
            catch (IOException e) {
                e.printStackTrace();
                bl = false;
            }
            return bl;
        }

        @Nullable
        public final String read(@NotNull Context context, int drive, @NotNull String folder, @NotNull String filename) {
            Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
            Intrinsics.checkParameterIsNotNull((Object)folder, (String)"folder");
            Intrinsics.checkParameterIsNotNull((Object)filename, (String)"filename");
            InputStream inputStream = this.getInputStreamFile(context, drive, folder, filename);
            String content = null;
            try {
                InputStream inputStream2 = inputStream;
                if (inputStream2 != null) {
                    String string;
                    InputStream inputStream3 = inputStream2;
                    boolean bl = false;
                    boolean bl2 = false;
                    InputStream it = inputStream3;
                    boolean bl3 = false;
                    int size = inputStream.available();
                    byte[] buffer = new byte[size];
                    inputStream.read(buffer);
                    inputStream.close();
                    Charset charset = Charsets.UTF_8;
                    boolean bl4 = false;
                    content = string = new String(buffer, charset);
                    FilemanLogger.d$fileman_release$default(FilemanLogger.INSTANCE, "File " + filename + " read with success.\nFile content is: " + content, null, 2, null);
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
                return null;
            }
            return content;
        }

        public final boolean delete(@NotNull Context context, int drive, @NotNull String folder, @NotNull String filename) {
            boolean bl;
            Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
            Intrinsics.checkParameterIsNotNull((Object)folder, (String)"folder");
            Intrinsics.checkParameterIsNotNull((Object)filename, (String)"filename");
            try {
                File file = new File(this.getFolder(context, drive, folder), filename);
                file.delete();
                bl = true;
            }
            catch (Exception e) {
                e.printStackTrace();
                bl = false;
            }
            return bl;
        }

        public final long getNow$fileman_release() {
            return System.currentTimeMillis();
        }

        @Nullable
        public final String getFilenameFullPath(@NotNull Context context, int driveInt, @NotNull String folderStr, @NotNull String fileName) {
            Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
            Intrinsics.checkParameterIsNotNull((Object)folderStr, (String)"folderStr");
            Intrinsics.checkParameterIsNotNull((Object)fileName, (String)"fileName");
            String string = this.getFullPath(context, driveInt, folderStr);
            if (string == null) {
                return null;
            }
            String fullPath = string;
            return fullPath + '/' + fileName;
        }

        /*
         * Enabled aggressive block sorting
         */
        @Nullable
        public final String getFullPath(@NotNull Context context, int driveInt, @NotNull String folderStr) {
            Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
            Intrinsics.checkParameterIsNotNull((Object)folderStr, (String)"folderStr");
            String driveStringName = "";
            String pathStr = null;
            if (driveInt == FilemanDrivers.SandBox.getType()) {
                File file = context.getFilesDir();
                Intrinsics.checkExpressionValueIsNotNull((Object)file, (String)"context.filesDir");
                String string = file.getAbsolutePath();
                Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"context.filesDir.absolutePath");
                driveStringName = string;
                return driveStringName + folderStr;
            } else if (driveInt == FilemanDrivers.Internal.getType()) {
                File[] path = context.getExternalFilesDirs(null);
                if (path[0] == null) {
                    FilemanLogger.d$fileman_release$default(FilemanLogger.INSTANCE, "No emulator", null, 2, null);
                    return null;
                }
                File file = path[0];
                Intrinsics.checkExpressionValueIsNotNull((Object)file, (String)"path[0]");
                String string = file.getPath();
                Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"path[0].path");
                driveStringName = string;
                return driveStringName + folderStr;
            } else {
                if (driveInt != FilemanDrivers.External.getType()) return driveStringName + folderStr;
                File[] path = context.getExternalFilesDirs(null);
                if (path.length >= 2 && path[1] != null) {
                    File file = path[1];
                    Intrinsics.checkExpressionValueIsNotNull((Object)file, (String)"path[1]");
                    String string = file.getPath();
                    Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"path[1].path");
                    driveStringName = string;
                    return driveStringName + folderStr;
                } else {
                    FilemanLogger.d$fileman_release$default(FilemanLogger.INSTANCE, "No SD card available", null, 2, null);
                    return null;
                }
            }
        }

        @Nullable
        public final File createFolder(@NotNull Context context, int driveStr, @NotNull String folderStr) {
            Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
            Intrinsics.checkParameterIsNotNull((Object)folderStr, (String)"folderStr");
            String pathStr = this.getFullPath(context, driveStr, folderStr);
            if (pathStr != null) {
                File fullPath = new File(pathStr);
                if (!fullPath.exists()) {
                    fullPath.mkdirs();
                }
                return fullPath;
            }
            return null;
        }

        @Nullable
        public final OutputStream createOutputFile(@NotNull Context context, int drive, @NotNull String folder, @NotNull String fileName, boolean append) {
            Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
            Intrinsics.checkParameterIsNotNull((Object)folder, (String)"folder");
            Intrinsics.checkParameterIsNotNull((Object)fileName, (String)"fileName");
            File fullPath = this.createFolder(context, drive, folder);
            if (fullPath != null) {
                FileOutputStream fileOutputStream;
                File file = new File(fullPath, fileName);
                try {
                    if (!file.exists()) {
                        file.createNewFile();
                        FilemanLogger.d$fileman_release$default(FilemanLogger.INSTANCE, "File created", null, 2, null);
                    } else {
                        FilemanLogger.d$fileman_release$default(FilemanLogger.INSTANCE, "File already exist", null, 2, null);
                    }
                    fileOutputStream = new FileOutputStream(file, append);
                }
                catch (IOException e) {
                    e.printStackTrace();
                    fileOutputStream = null;
                }
                return fileOutputStream;
            }
            return null;
        }

        public final boolean checkFolder(@NotNull Context context, int drive, @NotNull String folderStr) {
            Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
            Intrinsics.checkParameterIsNotNull((Object)folderStr, (String)"folderStr");
            String string = this.getFullPath(context, drive, folderStr);
            if (string == null) {
                return false;
            }
            String pathStr = string;
            File dirPath = new File(pathStr);
            dirPath.mkdir();
            return dirPath.exists();
        }

        @Nullable
        public final File getFolder(@NotNull Context context, int drive, @NotNull String folderStr) {
            String pathStr;
            Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
            Intrinsics.checkParameterIsNotNull((Object)folderStr, (String)"folderStr");
            if (!this.checkFolder(context, drive, folderStr)) {
                return null;
            }
            String string = pathStr = this.getFullPath(context, drive, folderStr);
            if (string == null) {
                Intrinsics.throwNpe();
            }
            return new File(string);
        }

        @Nullable
        public final InputStream getInputStreamFile(@NotNull Context context, int drive, @NotNull String folder, @NotNull String filename) {
            FileInputStream fileInputStream;
            Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
            Intrinsics.checkParameterIsNotNull((Object)folder, (String)"folder");
            Intrinsics.checkParameterIsNotNull((Object)filename, (String)"filename");
            try {
                File file = new File(this.getFolder(context, drive, folder), filename);
                fileInputStream = new FileInputStream(file);
            }
            catch (IOException ex) {
                ex.printStackTrace();
                fileInputStream = null;
            }
            return fileInputStream;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

