/*
 * Decompiled with CFR 0.152.
 */
package com.treebo.internetavailabilitychecker;

import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.net.ConnectivityManager;
import android.net.NetworkInfo;
import android.os.Bundle;
import java.lang.ref.WeakReference;

class NetworkChangeReceiver
extends BroadcastReceiver {
    private static final String INET_CONDITION = "inetCondition";
    private WeakReference<NetworkChangeListener> mNetworkChangeListenerWeakReference;

    NetworkChangeReceiver() {
    }

    public void onReceive(Context context, Intent intent) {
        NetworkChangeListener networkChangeListener;
        Bundle bundle = intent.getExtras();
        int condition = 0;
        if (bundle != null) {
            condition = bundle.getInt(INET_CONDITION, 0);
        }
        if ((networkChangeListener = (NetworkChangeListener)this.mNetworkChangeListenerWeakReference.get()) != null) {
            boolean isConnected = this.isNetworkConnected(context);
            if (isConnected) {
                if (condition > 0) {
                    networkChangeListener.onNetworkChange(true);
                }
            } else {
                networkChangeListener.onNetworkChange(false);
            }
        }
    }

    void setNetworkChangeListener(NetworkChangeListener networkChangeListener) {
        this.mNetworkChangeListenerWeakReference = new WeakReference<NetworkChangeListener>(networkChangeListener);
    }

    void removeNetworkChangeListener() {
        if (this.mNetworkChangeListenerWeakReference != null) {
            this.mNetworkChangeListenerWeakReference.clear();
        }
    }

    boolean isNetworkConnected(Context context) {
        ConnectivityManager connectivityManager = (ConnectivityManager)context.getSystemService("connectivity");
        NetworkInfo netInfo = connectivityManager.getActiveNetworkInfo();
        return netInfo != null && netInfo.isAvailable() && netInfo.isConnected();
    }

    static interface NetworkChangeListener {
        public void onNetworkChange(boolean var1);
    }
}

