/*
 * Decompiled with CFR 0.152.
 */
package com.titanium.locgetter.infra;

import android.app.Activity;
import android.app.Dialog;
import android.content.Intent;
import android.content.IntentSender;
import android.support.annotation.NonNull;
import android.support.v4.app.ActivityCompat;
import android.support.v7.app.AppCompatActivity;
import com.google.android.gms.common.GoogleApiAvailability;
import com.google.android.gms.common.api.Status;
import com.titanium.locgetter.exception.LocationSettingsException;
import com.titanium.locgetter.exception.NoGoogleApiException;
import com.titanium.locgetter.exception.PermissionException;
import com.titanium.locgetter.infra.LocationView;

public abstract class BaseLocationActivity
extends AppCompatActivity
implements LocationView {
    private static final int REQUEST_ERROR = 0;

    @Override
    public void showLocationsSettingsDialog(Status status) {
        try {
            status.startResolutionForResult((Activity)this, 10001);
        }
        catch (IntentSender.SendIntentException e) {
            e.printStackTrace();
        }
    }

    @Override
    public void showNoGoogleApiAvailable(int status) {
        Dialog errorDialog = GoogleApiAvailability.getInstance().getErrorDialog((Activity)this, status, 0, dialog -> this.finish());
        errorDialog.show();
    }

    @Override
    public void showPermissionsDialog(String permission, int requestCode) {
        ActivityCompat.requestPermissions((Activity)this, (String[])new String[]{permission}, (int)requestCode);
    }

    public void onLocationError(Throwable throwable) {
        if (throwable instanceof NoGoogleApiException) {
            this.showNoGoogleApiAvailable(((NoGoogleApiException)throwable).getErrorCode());
        } else if (throwable instanceof LocationSettingsException) {
            this.showLocationsSettingsDialog(((LocationSettingsException)throwable).getStatus());
        } else if (throwable instanceof PermissionException) {
            this.showPermissionsDialog(((PermissionException)throwable).getPermission(), ((PermissionException)throwable).getRequestCode());
        }
        throwable.printStackTrace();
    }

    public void onActivityResult(int requestCode, int resultCode, Intent data) {
        switch (requestCode) {
            case 10001: {
                this.onLocationSettingsResult(resultCode == -1);
            }
        }
    }

    public void onRequestPermissionsResult(int requestCode, @NonNull String[] permissions, @NonNull int[] grantResults) {
        super.onRequestPermissionsResult(requestCode, permissions, grantResults);
        switch (requestCode) {
            case 1001: {
                this.onLocationPermissionResult(grantResults[0] == 0);
                break;
            }
            default: {
                throw new IllegalStateException("Should implement all permissions callbacks here");
            }
        }
    }

    protected abstract void onLocationPermissionResult(boolean var1);

    protected abstract void onLocationSettingsResult(boolean var1);
}

