/*
 * Decompiled with CFR 0.152.
 */
package com.titanium.locgetter.main;

import android.content.Context;
import android.location.Location;
import android.support.annotation.Nullable;
import android.support.v4.content.ContextCompat;
import com.google.android.gms.common.ConnectionResult;
import com.google.android.gms.common.GoogleApiAvailability;
import com.google.android.gms.common.api.GoogleApiClient;
import com.google.android.gms.common.api.PendingResult;
import com.google.android.gms.common.api.Status;
import com.google.android.gms.location.LocationListener;
import com.google.android.gms.location.LocationRequest;
import com.google.android.gms.location.LocationServices;
import com.google.android.gms.location.LocationSettingsRequest;
import com.google.android.gms.location.LocationSettingsResult;
import com.titanium.locgetter.exception.LocationSettingsException;
import com.titanium.locgetter.exception.NoGoogleApiException;
import com.titanium.locgetter.exception.PermissionException;
import com.titanium.locgetter.main.LocationGetter;
import com.titanium.locgetter.main.LocationGetterImpl$$Lambda$1;
import com.titanium.locgetter.main.LocationGetterImpl$$Lambda$2;
import com.titanium.locgetter.main.LocationGetterImpl$$Lambda$3;
import com.titanium.locgetter.main.LocationGetterImpl$$Lambda$4;
import com.titanium.locgetter.main.LocationGetterImpl$$Lambda$5;
import com.titanium.locgetter.main.LocationGetterImpl$LocationSniffer$$Lambda$1;
import com.titanium.locgetter.main.LocationGetterImpl$LocationSniffer$$Lambda$4;
import com.titanium.locgetter.main.LocationGetterImpl$LocationSniffer$$Lambda$5;
import com.titanium.locgetter.main.Logger;
import io.reactivex.Observable;
import io.reactivex.ObservableEmitter;
import io.reactivex.ObservableOnSubscribe;
import io.reactivex.ObservableSource;
import io.reactivex.Single;
import io.reactivex.android.schedulers.AndroidSchedulers;
import io.reactivex.schedulers.Schedulers;

class LocationGetterImpl
implements LocationGetter {
    private static final String TAG = "LocationGetter";
    private Logger logger;
    private GoogleApiClient googleApiClient;
    private LocationRequest locationRequest;
    private Context appContext;
    private Location latestLoc;

    LocationGetterImpl(Logger logger, Context ctx, LocationRequest request, GoogleApiClient googleApiClient) {
        this.logger = logger;
        this.googleApiClient = googleApiClient;
        this.appContext = ctx;
        this.locationRequest = request;
    }

    @Override
    public Observable<Location> getLatestLocations() {
        if (ContextCompat.checkSelfPermission((Context)this.appContext, (String)"android.permission.ACCESS_FINE_LOCATION") == 0 && ContextCompat.checkSelfPermission((Context)this.appContext, (String)"android.permission.ACCESS_COARSE_LOCATION") == 0) {
            return Observable.just((Object)this.googleApiClient).subscribeOn(Schedulers.newThread()).doOnNext(LocationGetterImpl$$Lambda$1.lambdaFactory$(this)).doOnNext(LocationGetterImpl$$Lambda$2.lambdaFactory$(this)).map(LocationGetterImpl$$Lambda$3.lambdaFactory$(this)).doOnNext(LocationGetterImpl$$Lambda$4.lambdaFactory$(this)).flatMap(LocationGetterImpl$$Lambda$5.lambdaFactory$(this));
        }
        return Observable.error((Throwable)new PermissionException("android.permission.ACCESS_FINE_LOCATION", 1001));
    }

    private void checkGoogleApiAvailability() {
        GoogleApiAvailability googleApiAvailability = GoogleApiAvailability.getInstance();
        int errorCode = googleApiAvailability.isGooglePlayServicesAvailable(this.appContext);
        if (errorCode != 0) {
            throw new NoGoogleApiException(errorCode);
        }
    }

    private void initGoogleApiClient(GoogleApiClient googleApiClient) {
        if (!googleApiClient.isConnected()) {
            this.logger.log(TAG, "Google api client is not connected");
            this.logger.log(TAG, "Google api client connecting");
            ConnectionResult res = googleApiClient.blockingConnect();
            if (!res.isSuccess()) {
                throw new RuntimeException("can_not_connect");
            }
            this.logger.log(TAG, "Google api client connected");
        }
    }

    private Status getLocationSettingsStatus(GoogleApiClient googleApiClient) {
        LocationSettingsRequest.Builder builder = new LocationSettingsRequest.Builder();
        builder.setAlwaysShow(true);
        builder.addLocationRequest(this.locationRequest);
        PendingResult result = LocationServices.SettingsApi.checkLocationSettings(googleApiClient, builder.build());
        return ((LocationSettingsResult)result.await()).getStatus();
    }

    private void checkSettingsStatus(Status status) {
        this.logger.log(TAG, "checkSettingsStatus -> settings status = " + status);
        switch (status.getStatusCode()) {
            case 0: {
                this.logger.log(TAG, "checkSettingsStatus:Location is enabled");
                break;
            }
            case 6: {
                this.logger.log(TAG, "checkSettingsStatus:Location settings are not satisfied. Show the user a dialog to upgrade location settings ");
            }
            case 8502: {
                throw new LocationSettingsException(status);
            }
        }
    }

    @Override
    public Single<Location> getLatestLocation() {
        return this.getLatestLocations().firstOrError();
    }

    @Override
    @Nullable
    public Location getLatestSavedLocation() {
        return this.latestLoc;
    }

    static /* synthetic */ ObservableSource lambda$getLatestLocations$1(LocationGetterImpl this_, Status integer) throws Exception {
        return this_.new LocationSniffer().startEmittingLocations();
    }

    static /* synthetic */ void lambda$getLatestLocations$0(LocationGetterImpl this_, GoogleApiClient client) throws Exception {
        this_.checkGoogleApiAvailability();
    }

    static /* synthetic */ void access$lambda$0(LocationGetterImpl locationGetterImpl, GoogleApiClient googleApiClient) {
        locationGetterImpl.initGoogleApiClient(googleApiClient);
    }

    static /* synthetic */ Status access$lambda$1(LocationGetterImpl locationGetterImpl, GoogleApiClient googleApiClient) {
        return locationGetterImpl.getLocationSettingsStatus(googleApiClient);
    }

    static /* synthetic */ void access$lambda$2(LocationGetterImpl locationGetterImpl, Status status) {
        locationGetterImpl.checkSettingsStatus(status);
    }

    private class LocationSniffer {
        private LocationListener listener;

        private LocationSniffer() {
        }

        private Observable<Location> startEmittingLocations() {
            return Observable.create((ObservableOnSubscribe)LocationGetterImpl$LocationSniffer$$Lambda$1.lambdaFactory$(this));
        }

        private void subscribeToUpdates() {
            AndroidSchedulers.mainThread().scheduleDirect(LocationGetterImpl$LocationSniffer$$Lambda$4.lambdaFactory$(this));
        }

        private void unSubscribeFromUpdates() {
            LocationServices.FusedLocationApi.removeLocationUpdates(LocationGetterImpl.this.googleApiClient, this.listener);
        }

        static /* synthetic */ void lambda$subscribeToUpdates$2(LocationSniffer this_) {
            LocationServices.FusedLocationApi.requestLocationUpdates(this_.LocationGetterImpl.this.googleApiClient, this_.LocationGetterImpl.this.locationRequest, this_.listener);
        }

        static /* synthetic */ void lambda$startEmittingLocations$1(LocationSniffer this_, ObservableEmitter e) throws Exception {
            this_.listener = LocationGetterImpl$LocationSniffer$$Lambda$5.lambdaFactory$(this_, e);
            this_.subscribeToUpdates();
        }

        static /* synthetic */ void lambda$null$0(LocationSniffer this_, ObservableEmitter e, Location location) {
            if (e.isDisposed()) {
                this_.unSubscribeFromUpdates();
            } else {
                this_.LocationGetterImpl.this.logger.log(LocationGetterImpl.TAG, "Got new location :" + location);
                this_.LocationGetterImpl.this.latestLoc = location;
                e.onNext((Object)location);
            }
        }
    }
}

