/*
 * Decompiled with CFR 0.152.
 */
package com.titanium.locgetter.main;

import android.content.Context;
import android.support.annotation.NonNull;
import com.google.android.gms.common.api.GoogleApiClient;
import com.google.android.gms.location.LocationRequest;
import com.google.android.gms.location.LocationServices;
import com.titanium.locgetter.main.LocationGetter;
import com.titanium.locgetter.main.LocationGetterBuilder$$Lambda$1;
import com.titanium.locgetter.main.LocationGetterImpl;
import com.titanium.locgetter.main.Logger;

public class LocationGetterBuilder {
    private LocationRequest locationRequest;
    private GoogleApiClient googleApiClient;
    private Context context;
    private Logger logger;

    public LocationGetterBuilder(@NonNull Context context) {
        this.context = context;
    }

    public LocationGetterBuilder setLocationRequest(LocationRequest locationRequest) {
        this.locationRequest = locationRequest;
        return this;
    }

    public LocationGetterBuilder setLogger(Logger logger) {
        this.logger = logger;
        return this;
    }

    public LocationGetterBuilder setGoogleApiClient(GoogleApiClient googleApiClient) {
        this.googleApiClient = googleApiClient;
        return this;
    }

    public LocationGetter build() {
        if (this.googleApiClient == null) {
            this.googleApiClient = this.getMinimalGoogleApiClient(this.context);
        }
        if (this.locationRequest == null) {
            this.locationRequest = this.getDefaultLocationRequest();
        }
        if (this.logger == null) {
            this.logger = this.getDefaultLogger();
        }
        return new LocationGetterImpl(this.logger, this.context, this.locationRequest, this.googleApiClient);
    }

    private GoogleApiClient getMinimalGoogleApiClient(Context ctx) {
        return new GoogleApiClient.Builder(ctx).addApi(LocationServices.API).build();
    }

    private LocationRequest getDefaultLocationRequest() {
        return this.getLocationRequestByParams(2000L, 2000L, 100);
    }

    private Logger getDefaultLogger() {
        return LocationGetterBuilder$$Lambda$1.lambdaFactory$();
    }

    private LocationRequest getLocationRequestByParams(long fastestInterval, long interval, int priority) {
        LocationRequest locationrequest = new LocationRequest();
        locationrequest.setFastestInterval(fastestInterval);
        locationrequest.setInterval(interval);
        locationrequest.setPriority(priority);
        return locationrequest;
    }
}

