/*
 * Decompiled with CFR 0.152.
 */
package com.titanium.locgetter.main;

import android.content.Context;
import android.support.annotation.NonNull;
import com.google.android.gms.common.api.GoogleApiClient;
import com.google.android.gms.location.LocationRequest;
import com.google.android.gms.location.LocationServices;
import com.titanium.locgetter.main.LocationGetter;
import com.titanium.locgetter.main.LocationGetterImpl;

public class LocationGetterFactory {
    public static LocationGetter getDefault(@NonNull Context applicationContext) {
        return new LocationGetterImpl(applicationContext, LocationGetterFactory.getDefaultLocationRequest(), LocationGetterFactory.getMinimalGoogleApiClient(applicationContext));
    }

    public static LocationGetter getWithCustomLocationRequest(@NonNull Context applicationContext, long fastestInterval, long interval, int priority) {
        return new LocationGetterImpl(applicationContext, LocationGetterFactory.getLocationRequestByParams(fastestInterval, interval, priority), LocationGetterFactory.getMinimalGoogleApiClient(applicationContext));
    }

    public static LocationGetter getCustomLocationGetter(@NonNull Context ctx, @NonNull LocationRequest request, @NonNull GoogleApiClient googleApiClient) {
        return new LocationGetterImpl(ctx, request, googleApiClient);
    }

    private static GoogleApiClient getMinimalGoogleApiClient(Context ctx) {
        return new GoogleApiClient.Builder(ctx).addApi(LocationServices.API).build();
    }

    private static LocationRequest getDefaultLocationRequest() {
        return LocationGetterFactory.getLocationRequestByParams(2000L, 2000L, 100);
    }

    private static LocationRequest getLocationRequestByParams(long fastestInterval, long interval, int priority) {
        LocationRequest locationrequest = new LocationRequest();
        locationrequest.setFastestInterval(fastestInterval);
        locationrequest.setInterval(interval);
        locationrequest.setPriority(priority);
        return locationrequest;
    }
}

