/*
 * Decompiled with CFR 0.152.
 */
package codes.rafael.modulemaker;

import codes.rafael.modulemaker.AbstractModuleMojo;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.jar.JarEntry;
import java.util.jar.JarInputStream;
import java.util.jar.JarOutputStream;
import java.util.jar.Manifest;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;
import org.apache.maven.project.MavenProjectHelper;

@Mojo(name="inject-module", defaultPhase=LifecyclePhase.PACKAGE)
public class ModuleInjectMojo
extends AbstractModuleMojo {
    @Parameter(defaultValue="${project}", readonly=true, required=true)
    private MavenProject project;
    @Component
    private MavenProjectHelper projectHelper;
    @Parameter(defaultValue="${project.build.directory}", required=true, readonly=true)
    private String directory;
    @Parameter(defaultValue="${project.build.finalName}", required=true, readonly=true)
    private String finalName;
    @Parameter
    private String source;
    @Parameter(defaultValue="modularized")
    private String classifier;
    @Parameter(defaultValue="true")
    private boolean replace;
    @Parameter(defaultValue="true")
    private boolean createMultiReleaseFolderEntry;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void doExecute() throws MojoExecutionException, MojoFailureException {
        String filename = this.filename();
        File sourceJar = this.source == null ? new File(this.directory, this.finalName + ".jar") : new File(this.source);
        if (!sourceJar.isFile()) {
            throw new MojoExecutionException("Could not locate source jar: " + sourceJar);
        }
        String classifier = this.classifier == null || this.classifier.isEmpty() ? "modularized" : this.classifier;
        try {
            File targetJar = new File(this.directory, this.finalName + "-" + classifier + ".jar");
            if (!targetJar.isFile() && !targetJar.createNewFile()) {
                throw new MojoExecutionException("Target jar could not be created and did not exist from before: " + targetJar);
            }
            JarInputStream inputStream = new JarInputStream(new FileInputStream(sourceJar));
            try {
                if (!targetJar.isFile() && !targetJar.createNewFile()) {
                    throw new MojoFailureException("Could not create target jar: " + targetJar);
                }
                Manifest manifest = inputStream.getManifest();
                JarOutputStream outputStream = manifest == null ? new JarOutputStream(new FileOutputStream(targetJar)) : new JarOutputStream((OutputStream)new FileOutputStream(targetJar), manifest);
                try {
                    JarEntry jarEntry;
                    HashSet<String> multiReleaseDirectories;
                    HashSet<String> hashSet = multiReleaseDirectories = this.multirelease && this.createMultiReleaseFolderEntry ? new HashSet<String>(Arrays.asList("META-INF/", "META-INF/versions/", "META-INF/versions/" + this.javaVersion + "/")) : Collections.emptySet();
                    while ((jarEntry = inputStream.getNextJarEntry()) != null) {
                        int index;
                        if (jarEntry.getName().equals(filename)) {
                            inputStream.closeEntry();
                            this.getLog().warn((CharSequence)("Ignoring preexisting module-info.class in " + sourceJar));
                            continue;
                        }
                        if (multiReleaseDirectories.remove(jarEntry.getName())) {
                            this.getLog().debug((CharSequence)("Discovered multi-version jar file location: " + jarEntry.getName()));
                        }
                        outputStream.putNextEntry(jarEntry);
                        byte[] buffer = new byte[1024];
                        while ((index = inputStream.read(buffer)) != -1) {
                            outputStream.write(buffer, 0, index);
                        }
                        inputStream.closeEntry();
                        outputStream.closeEntry();
                    }
                    outputStream.putNextEntry(new JarEntry(filename));
                    outputStream.write(this.makeModuleInfo());
                    outputStream.closeEntry();
                    for (String directory : multiReleaseDirectories) {
                        outputStream.putNextEntry(new JarEntry(directory));
                        outputStream.closeEntry();
                    }
                }
                finally {
                    outputStream.close();
                }
            }
            finally {
                inputStream.close();
            }
            if (this.replace) {
                if (!sourceJar.delete() || !targetJar.renameTo(sourceJar)) {
                    throw new MojoFailureException("Could not replace source jar: " + sourceJar);
                }
                this.getLog().info((CharSequence)("Injected module-info.class into " + sourceJar));
            } else {
                this.projectHelper.attachArtifact(this.project, this.project.getArtifact().getType(), classifier, targetJar);
                this.getLog().info((CharSequence)("Attached artifact with module-info.class as " + targetJar));
            }
        }
        catch (IOException exception) {
            throw new MojoFailureException("Could not write or read artifact", (Throwable)exception);
        }
    }
}

