/*
 * Decompiled with CFR 0.152.
 */
package codes.rafael.asmjdkbridge;

import codes.rafael.asmjdkbridge.JdkClassReader;
import codes.rafael.asmjdkbridge.JdkClassWriter;
import codes.rafael.asmjdkbridge.ProbingClassReader;
import java.util.function.Function;
import org.objectweb.asm.Attribute;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.Opcodes;

abstract class ProbingResolver {
    private static final String OBJECT = "java/lang/Object";
    private static final int SUPPORTED;

    ProbingResolver() {
    }

    static ClassVisitor ofVersion(int flags, int version, final Function<String, String> getSuperClass) {
        if (version > SUPPORTED) {
            return new JdkClassWriter(flags, getSuperClass);
        }
        return new ClassWriter(flags){

            protected String getCommonSuperClass(String type1, String type2) {
                if (getSuperClass == null) {
                    return super.getCommonSuperClass(type1, type2);
                }
                if (type1.equals(type2)) {
                    return type1;
                }
                String class1 = (String)getSuperClass.apply(type1);
                String class2 = (String)getSuperClass.apply(type2);
                if (class1 == null || class2 == null) {
                    return ProbingResolver.OBJECT;
                }
                while (!class1.equals(ProbingResolver.OBJECT)) {
                    if (class1.equals(type2)) {
                        return type2;
                    }
                    class1 = (String)getSuperClass.apply(class1);
                }
                while (!class2.equals(ProbingResolver.OBJECT)) {
                    if (class2.equals(type1)) {
                        return type1;
                    }
                    class2 = (String)getSuperClass.apply(class2);
                }
                return ProbingResolver.OBJECT;
            }
        };
    }

    static ProbingResolver ofClassFile(byte[] classFile, Attribute[] attributePrototypes) {
        int majorVersion = classFile[6] << 8 | classFile[7];
        if (majorVersion > SUPPORTED) {
            return new OfJdk(classFile, attributePrototypes);
        }
        return new OfAsm(classFile, attributePrototypes);
    }

    abstract void accept(ClassVisitor var1, int var2);

    abstract ProbingClassReader.ClassWriterContainer<?> toClassWriter(int var1);

    static {
        int version = 68;
        try {
            int candidate = 25;
            while (!Thread.interrupted()) {
                version = (Integer)Opcodes.class.getField("V" + candidate++).get(null);
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        SUPPORTED = version & 0xFFFF;
    }

    static class OfJdk
    extends ProbingResolver {
        private final JdkClassReader classReader;

        OfJdk(byte[] classFile, Attribute[] attributePrototypes) {
            this.classReader = new JdkClassReader(classFile, attributePrototypes);
        }

        @Override
        void accept(ClassVisitor classVisitor, int flags) {
            this.classReader.accept(classVisitor, flags);
        }

        @Override
        ProbingClassReader.ClassWriterContainer<?> toClassWriter(int flags) {
            return new ProbingClassReader.ClassWriterContainer.OfJdk(this.classReader, flags);
        }
    }

    static class OfAsm
    extends ProbingResolver {
        private final ClassReader classReader;
        private final Attribute[] attributePrototypes;

        OfAsm(byte[] classFile, Attribute[] attributePrototypes) {
            this.classReader = new ClassReader(classFile);
            this.attributePrototypes = attributePrototypes;
        }

        @Override
        void accept(ClassVisitor classVisitor, int flags) {
            this.classReader.accept(classVisitor, this.attributePrototypes, flags);
        }

        @Override
        ProbingClassReader.ClassWriterContainer<?> toClassWriter(int flags) {
            return new ProbingClassReader.ClassWriterContainer.OfAsm(this.classReader, flags);
        }
    }
}

