/*
 * Decompiled with CFR 0.152.
 */
package codes.rafael.asmjdkbridge;

import codes.rafael.asmjdkbridge.JdkClassReader;
import codes.rafael.asmjdkbridge.JdkClassWriter;
import codes.rafael.asmjdkbridge.ProbingResolver;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Objects;
import java.util.function.Function;
import org.objectweb.asm.Attribute;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.ClassWriter;

public class ProbingClassReader {
    private final ProbingResolver resolver;

    public ProbingClassReader(byte[] classFile, Attribute ... attributePrototypes) {
        this.resolver = ProbingResolver.ofClassFile(null, classFile, attributePrototypes);
    }

    public ProbingClassReader(InputStream inputStream, Attribute ... attributePrototypes) throws IOException {
        this(ProbingClassReader.readAllBytes(inputStream), (Function<String, String>)null, attributePrototypes);
    }

    public ProbingClassReader(String className, Attribute ... attributePrototypes) throws IOException {
        byte[] classFile;
        try (InputStream inputStream = ClassLoader.getSystemResourceAsStream(className.replace('.', '/') + ".class");){
            classFile = ProbingClassReader.readAllBytes(inputStream);
        }
        this.resolver = ProbingResolver.ofClassFile(null, classFile, attributePrototypes);
    }

    public ProbingClassReader(byte[] classFile, Function<String, String> getSuperClass, Attribute ... attributePrototypes) {
        this.resolver = ProbingResolver.ofClassFile(getSuperClass, classFile, attributePrototypes);
    }

    public ProbingClassReader(InputStream inputStream, Function<String, String> getSuperClass, Attribute ... attributePrototypes) throws IOException {
        this(ProbingClassReader.readAllBytes(inputStream), getSuperClass, attributePrototypes);
    }

    public ProbingClassReader(String className, Function<String, String> getSuperClass, Attribute ... attributePrototypes) throws IOException {
        byte[] classFile;
        try (InputStream inputStream = ClassLoader.getSystemResourceAsStream(className.replace('.', '/') + ".class");){
            classFile = ProbingClassReader.readAllBytes(inputStream);
        }
        this.resolver = ProbingResolver.ofClassFile(getSuperClass, classFile, attributePrototypes);
    }

    private static byte[] readAllBytes(InputStream inputStream) throws IOException {
        int length;
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        byte[] buffer = new byte[8192];
        while ((length = inputStream.read(buffer)) != -1) {
            outputStream.write(buffer, 0, length);
        }
        return outputStream.toByteArray();
    }

    public int getAccess() {
        return this.resolver.getAccess();
    }

    public String getClassName() {
        return this.resolver.getClassName();
    }

    public String getSuperName() {
        return this.resolver.getSuperName();
    }

    public String[] getInterfaces() {
        return this.resolver.getInterfaces();
    }

    public void accept(ClassVisitor classVisitor, int flags) {
        this.resolver.accept(classVisitor, flags);
    }

    public ClassWriterContainer<?> toClassWriter(int flags) {
        return this.resolver.toClassWriter(flags);
    }

    public static abstract class ClassWriterContainer<T extends ClassVisitor> {
        final T delegate;

        ClassWriterContainer(T delegate) {
            this.delegate = delegate;
        }

        public ClassVisitor getClassVisitor() {
            return this.delegate;
        }

        public abstract byte[] toByteArray();

        static class OfJdk
        extends ClassWriterContainer<JdkClassWriter> {
            OfJdk(JdkClassReader classReader, int flags, Function<String, String> getSuperClass) {
                super(new JdkClassWriter(classReader, flags, getSuperClass));
            }

            @Override
            public byte[] toByteArray() {
                return ((JdkClassWriter)this.delegate).toByteArray();
            }
        }

        static class OfAsm
        extends ClassWriterContainer<ClassWriter> {
            OfAsm(ClassReader classReader, int flags, final Function<String, String> getSuperClass) {
                super(new ClassWriter(classReader, flags){

                    protected String getCommonSuperClass(String left, String right) {
                        if (getSuperClass == null) {
                            return super.getCommonSuperClass(left, right);
                        }
                        String resolved = OfAsm.doGetCommonSuperClass(left, right, getSuperClass);
                        if (resolved == null) {
                            resolved = OfAsm.doGetCommonSuperClass(right, left, getSuperClass);
                        }
                        if (resolved == null) {
                            return "java/lang/Object";
                        }
                        return resolved;
                    }
                });
            }

            private static String doGetCommonSuperClass(String constant, String dynamic, Function<String, String> getSuperClass) {
                while (!Objects.equals(constant, dynamic) && dynamic != null) {
                    dynamic = getSuperClass.apply(dynamic);
                }
                return dynamic;
            }

            @Override
            public byte[] toByteArray() {
                return ((ClassWriter)this.delegate).toByteArray();
            }
        }
    }
}

