/*
 * Decompiled with CFR 0.152.
 */
package codes.rafael.asmjdkbridge;

import codes.rafael.asmjdkbridge.JdkClassReader;
import codes.rafael.asmjdkbridge.JdkClassWriter;
import codes.rafael.asmjdkbridge.ProbingClassReader;
import org.objectweb.asm.Attribute;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.Opcodes;

abstract class ProbingResolver {
    private static final int SUPPORTED;

    ProbingResolver() {
    }

    static ClassVisitor ofVersion(int flags, int version) {
        if (version > SUPPORTED) {
            return new JdkClassWriter(flags);
        }
        return new ClassWriter(flags);
    }

    static ProbingResolver ofClassFile(byte[] classFile, Attribute[] attributePrototypes) {
        int majorVersion = classFile[6] << 8 | classFile[7];
        if (majorVersion > SUPPORTED) {
            return new OfJdk(classFile, attributePrototypes);
        }
        return new OfAsm(classFile, attributePrototypes);
    }

    abstract void accept(ClassVisitor var1, int var2);

    abstract ProbingClassReader.ClassWriterContainer<?> toClassWriter(int var1);

    static {
        int version = 68;
        try {
            int candidate = 25;
            while (!Thread.interrupted()) {
                version = (Integer)Opcodes.class.getField("V" + candidate++).get(null);
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        SUPPORTED = version & 0xFFFF;
    }

    static class OfJdk
    extends ProbingResolver {
        private final JdkClassReader classReader;

        OfJdk(byte[] classFile, Attribute[] attributePrototypes) {
            this.classReader = new JdkClassReader(classFile, attributePrototypes);
        }

        @Override
        void accept(ClassVisitor classVisitor, int flags) {
            this.classReader.accept(classVisitor, flags);
        }

        @Override
        ProbingClassReader.ClassWriterContainer<?> toClassWriter(int flags) {
            return new ProbingClassReader.ClassWriterContainer.OfJdk(this.classReader, flags);
        }
    }

    static class OfAsm
    extends ProbingResolver {
        private final ClassReader classReader;
        private final Attribute[] attributePrototypes;

        OfAsm(byte[] classFile, Attribute[] attributePrototypes) {
            this.classReader = new ClassReader(classFile);
            this.attributePrototypes = attributePrototypes;
        }

        @Override
        void accept(ClassVisitor classVisitor, int flags) {
            this.classReader.accept(classVisitor, this.attributePrototypes, flags);
        }

        @Override
        ProbingClassReader.ClassWriterContainer<?> toClassWriter(int flags) {
            return new ProbingClassReader.ClassWriterContainer.OfAsm(this.classReader, flags);
        }
    }
}

