/*
 * Decompiled with CFR 0.152.
 */
package codes.rafael.asmjdkbridge;

import codes.rafael.asmjdkbridge.AsmWrappedAttribute;
import codes.rafael.asmjdkbridge.JdkClassReader;
import java.lang.classfile.Annotation;
import java.lang.classfile.AnnotationElement;
import java.lang.classfile.AnnotationValue;
import java.lang.classfile.ClassBuilder;
import java.lang.classfile.ClassElement;
import java.lang.classfile.ClassFile;
import java.lang.classfile.ClassFileElement;
import java.lang.classfile.ClassHierarchyResolver;
import java.lang.classfile.ClassModel;
import java.lang.classfile.CodeBuilder;
import java.lang.classfile.CodeElement;
import java.lang.classfile.FieldElement;
import java.lang.classfile.FieldModel;
import java.lang.classfile.Label;
import java.lang.classfile.MethodElement;
import java.lang.classfile.MethodModel;
import java.lang.classfile.Opcode;
import java.lang.classfile.Signature;
import java.lang.classfile.TypeAnnotation;
import java.lang.classfile.TypeKind;
import java.lang.classfile.attribute.AnnotationDefaultAttribute;
import java.lang.classfile.attribute.ConstantValueAttribute;
import java.lang.classfile.attribute.DeprecatedAttribute;
import java.lang.classfile.attribute.EnclosingMethodAttribute;
import java.lang.classfile.attribute.ExceptionsAttribute;
import java.lang.classfile.attribute.InnerClassInfo;
import java.lang.classfile.attribute.InnerClassesAttribute;
import java.lang.classfile.attribute.MethodParameterInfo;
import java.lang.classfile.attribute.MethodParametersAttribute;
import java.lang.classfile.attribute.ModuleAttribute;
import java.lang.classfile.attribute.ModuleMainClassAttribute;
import java.lang.classfile.attribute.ModulePackagesAttribute;
import java.lang.classfile.attribute.NestHostAttribute;
import java.lang.classfile.attribute.NestMembersAttribute;
import java.lang.classfile.attribute.PermittedSubclassesAttribute;
import java.lang.classfile.attribute.RecordAttribute;
import java.lang.classfile.attribute.RecordComponentInfo;
import java.lang.classfile.attribute.RuntimeInvisibleAnnotationsAttribute;
import java.lang.classfile.attribute.RuntimeInvisibleParameterAnnotationsAttribute;
import java.lang.classfile.attribute.RuntimeInvisibleTypeAnnotationsAttribute;
import java.lang.classfile.attribute.RuntimeVisibleAnnotationsAttribute;
import java.lang.classfile.attribute.RuntimeVisibleParameterAnnotationsAttribute;
import java.lang.classfile.attribute.RuntimeVisibleTypeAnnotationsAttribute;
import java.lang.classfile.attribute.SignatureAttribute;
import java.lang.classfile.attribute.SourceDebugExtensionAttribute;
import java.lang.classfile.attribute.SourceFileAttribute;
import java.lang.classfile.attribute.StackMapFrameInfo;
import java.lang.classfile.attribute.StackMapTableAttribute;
import java.lang.classfile.constantpool.ConstantPoolBuilder;
import java.lang.classfile.constantpool.Utf8Entry;
import java.lang.classfile.instruction.DiscontinuedInstruction;
import java.lang.classfile.instruction.SwitchCase;
import java.lang.constant.ClassDesc;
import java.lang.constant.ConstantDesc;
import java.lang.constant.ConstantDescs;
import java.lang.constant.DirectMethodHandleDesc;
import java.lang.constant.DynamicCallSiteDesc;
import java.lang.constant.DynamicConstantDesc;
import java.lang.constant.MethodHandleDesc;
import java.lang.constant.MethodTypeDesc;
import java.lang.constant.ModuleDesc;
import java.lang.constant.PackageDesc;
import java.lang.runtime.SwitchBootstraps;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import org.objectweb.asm.AnnotationVisitor;
import org.objectweb.asm.Attribute;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.ConstantDynamic;
import org.objectweb.asm.FieldVisitor;
import org.objectweb.asm.Handle;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.ModuleVisitor;
import org.objectweb.asm.Opcodes;
import org.objectweb.asm.RecordComponentVisitor;
import org.objectweb.asm.Type;
import org.objectweb.asm.TypePath;
import org.objectweb.asm.TypeReference;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
public class JdkClassWriter
extends ClassVisitor {
    private final int flags;
    private final ClassModel classModel;
    private final List<ClassDesc> nestMembers = new ArrayList<ClassDesc>();
    private final List<InnerClassInfo> innerClasses = new ArrayList<InnerClassInfo>();
    private final List<ClassDesc> permittedSubclasses = new ArrayList<ClassDesc>();
    private final List<RecordComponentInfo> recordComponents = new ArrayList<RecordComponentInfo>();
    private final List<ClassElement> attributes = new ArrayList<ClassElement>();
    private final List<Annotation> visibleAnnotations = new ArrayList<Annotation>();
    private final List<Annotation> invisibleAnnotations = new ArrayList<Annotation>();
    private final List<TypeAnnotation> visibleTypeAnnotations = new ArrayList<TypeAnnotation>();
    private final List<TypeAnnotation> invisibleTypeAnnotations = new ArrayList<TypeAnnotation>();
    private ClassDesc thisClass;
    private boolean isRecord;
    private final List<Consumer<ClassBuilder>> classConsumers = new ArrayList<Consumer<ClassBuilder>>(List.of(classBuilder -> {
        for (ClassElement attribute : this.attributes) {
            classBuilder.with((ClassFileElement)attribute);
        }
        if (!this.visibleAnnotations.isEmpty()) {
            classBuilder.with((ClassFileElement)RuntimeVisibleAnnotationsAttribute.of(this.visibleAnnotations));
        }
        if (!this.invisibleAnnotations.isEmpty()) {
            classBuilder.with((ClassFileElement)RuntimeInvisibleAnnotationsAttribute.of(this.invisibleAnnotations));
        }
        if (!this.visibleTypeAnnotations.isEmpty()) {
            classBuilder.with((ClassFileElement)RuntimeVisibleTypeAnnotationsAttribute.of(this.visibleTypeAnnotations));
        }
        if (!this.invisibleTypeAnnotations.isEmpty()) {
            classBuilder.with((ClassFileElement)RuntimeInvisibleTypeAnnotationsAttribute.of(this.invisibleTypeAnnotations));
        }
        if (!this.nestMembers.isEmpty()) {
            classBuilder.with((ClassFileElement)NestMembersAttribute.ofSymbols(this.nestMembers));
        }
        if (!this.innerClasses.isEmpty()) {
            classBuilder.with((ClassFileElement)InnerClassesAttribute.of(this.innerClasses));
        }
        if (!this.permittedSubclasses.isEmpty()) {
            classBuilder.with((ClassFileElement)PermittedSubclassesAttribute.ofSymbols(this.permittedSubclasses));
        }
        if (this.isRecord || !this.recordComponents.isEmpty()) {
            classBuilder.with((ClassFileElement)RecordAttribute.of(this.recordComponents));
        }
    }));
    private byte[] bytes;

    public JdkClassWriter(int flags) {
        this(null, flags);
    }

    public JdkClassWriter(JdkClassReader classReader, int flags) {
        super(589824);
        this.flags = flags;
        this.classModel = classReader == null ? null : classReader.getClassModel();
    }

    public void visit(int version, int access, String name, String signature, String superName, String[] interfaces) {
        this.thisClass = ClassDesc.ofInternalName(name);
        this.isRecord = (access & 0x10000) != 0;
        this.classConsumers.add(classBuilder -> {
            classBuilder.withVersion(version & 0xFFFF, version >>> 16);
            classBuilder.withFlags(access & 0xFFFCFFFF);
            if ((access & 0x20000) != 0) {
                classBuilder.with((ClassFileElement)DeprecatedAttribute.of());
            }
            if (signature != null) {
                classBuilder.with((ClassFileElement)SignatureAttribute.of((Utf8Entry)classBuilder.constantPool().utf8Entry(signature)));
            }
            if (superName != null) {
                classBuilder.withSuperclass(ClassDesc.ofInternalName(superName));
            }
            if (interfaces != null) {
                ClassDesc[] entries = new ClassDesc[interfaces.length];
                for (int index = 0; index < interfaces.length; ++index) {
                    entries[index] = ClassDesc.ofInternalName(interfaces[index]);
                }
                classBuilder.withInterfaceSymbols(entries);
            }
        });
    }

    public void visitSource(String source, String debug) {
        this.classConsumers.add(classBuilder -> {
            if (source != null) {
                classBuilder.with((ClassFileElement)SourceFileAttribute.of((String)source));
            }
            if (debug != null) {
                classBuilder.with((ClassFileElement)SourceDebugExtensionAttribute.of((byte[])debug.getBytes(StandardCharsets.UTF_8)));
            }
        });
    }

    public ModuleVisitor visitModule(String name, int access, String version) {
        return new WritingModuleVisitor(name, access, version);
    }

    public void visitNestHost(String nestHost) {
        this.classConsumers.add(classBuilder -> classBuilder.with((ClassFileElement)NestHostAttribute.of((ClassDesc)ClassDesc.ofInternalName(nestHost))));
    }

    public void visitOuterClass(String owner, String name, String descriptor) {
        this.classConsumers.add(classBuilder -> classBuilder.with((ClassFileElement)EnclosingMethodAttribute.of((ClassDesc)ClassDesc.ofInternalName(owner), Optional.ofNullable(name), Optional.ofNullable(descriptor).map(MethodTypeDesc::ofDescriptor))));
    }

    public AnnotationVisitor visitAnnotation(String descriptor, boolean visible) {
        return WritingAnnotationVisitor.of(this, descriptor, (visible ? this.visibleAnnotations : this.invisibleAnnotations)::add);
    }

    public void visitAttribute(Attribute attribute) {
        this.attributes.add(AsmWrappedAttribute.unwrap(attribute, ClassElement.class));
    }

    public AnnotationVisitor visitTypeAnnotation(int typeRef, TypePath typePath, String descriptor, boolean visible) {
        return WritingAnnotationVisitor.ofTypeAnnotation(this, descriptor, typeRef, typePath, (visible ? this.visibleTypeAnnotations : this.invisibleTypeAnnotations)::add);
    }

    public void visitNestMember(String nestMember) {
        this.nestMembers.add(ClassDesc.ofInternalName(nestMember));
    }

    public void visitPermittedSubclass(String permittedSubclass) {
        this.permittedSubclasses.add(ClassDesc.ofInternalName(permittedSubclass));
    }

    public void visitInnerClass(String name, String outerName, String innerName, int access) {
        this.innerClasses.add(InnerClassInfo.of((ClassDesc)ClassDesc.ofInternalName(name), Optional.ofNullable(outerName).map(ClassDesc::ofInternalName), Optional.ofNullable(innerName), (int)access));
    }

    public RecordComponentVisitor visitRecordComponent(final String name, final String descriptor, String signature) {
        return new RecordComponentVisitor(this, 589824){
            private final List<java.lang.classfile.Attribute<?>> attributes;
            private final List<Annotation> visibleAnnotations;
            private final List<Annotation> invisibleAnnotations;
            private final List<TypeAnnotation> visibleTypeAnnotations;
            private final List<TypeAnnotation> invisibleTypeAnnotations;
            final /* synthetic */ JdkClassWriter this$0;
            {
                this.this$0 = this$0;
                super(arg0);
                this.attributes = new ArrayList();
                this.visibleAnnotations = new ArrayList<Annotation>();
                this.invisibleAnnotations = new ArrayList<Annotation>();
                this.visibleTypeAnnotations = new ArrayList<TypeAnnotation>();
                this.invisibleTypeAnnotations = new ArrayList<TypeAnnotation>();
            }

            public void visitAttribute(Attribute attribute) {
                this.attributes.add(AsmWrappedAttribute.unwrap(attribute, java.lang.classfile.Attribute.class));
            }

            public AnnotationVisitor visitAnnotation(String descriptor2, boolean visible) {
                return WritingAnnotationVisitor.of(this.this$0, descriptor2, (visible ? this.visibleAnnotations : this.invisibleAnnotations)::add);
            }

            public AnnotationVisitor visitTypeAnnotation(int typeRef, TypePath typePath, String descriptor2, boolean visible) {
                return WritingAnnotationVisitor.ofTypeAnnotation(this.this$0, descriptor2, typeRef, typePath, (visible ? this.visibleTypeAnnotations : this.invisibleTypeAnnotations)::add);
            }

            public void visitEnd() {
                ArrayList attributes = new ArrayList(this.attributes);
                if (!this.visibleAnnotations.isEmpty()) {
                    attributes.add((java.lang.classfile.Attribute<?>)RuntimeVisibleAnnotationsAttribute.of(this.visibleAnnotations));
                }
                if (!this.invisibleAnnotations.isEmpty()) {
                    attributes.add((java.lang.classfile.Attribute<?>)RuntimeInvisibleAnnotationsAttribute.of(this.invisibleAnnotations));
                }
                if (!this.visibleTypeAnnotations.isEmpty()) {
                    attributes.add((java.lang.classfile.Attribute<?>)RuntimeVisibleTypeAnnotationsAttribute.of(this.visibleTypeAnnotations));
                }
                if (!this.invisibleTypeAnnotations.isEmpty()) {
                    attributes.add((java.lang.classfile.Attribute<?>)RuntimeInvisibleTypeAnnotationsAttribute.of(this.invisibleTypeAnnotations));
                }
                this.this$0.recordComponents.add(RecordComponentInfo.of((String)name, (ClassDesc)ClassDesc.ofDescriptor(descriptor), attributes));
            }
        };
    }

    public FieldVisitor visitField(int access, String name, String descriptor, String signature, Object value) {
        return new WritingFieldVisitor(access, name, descriptor, signature, value);
    }

    public MethodVisitor visitMethod(int access, String name, String descriptor, String signature, String[] exceptions) {
        return new WritingMethodVisitor(access, name, descriptor, signature, exceptions);
    }

    public void visitEnd() {
        ClassFile classFile = (this.flags & 2) == 0 ? ClassFile.of((ClassFile.Option[])new ClassFile.Option[]{ClassFile.DeadCodeOption.KEEP_DEAD_CODE, ClassFile.StackMapsOption.DROP_STACK_MAPS}) : ClassFile.of((ClassFile.Option[])new ClassFile.Option[]{ClassFile.DeadCodeOption.PATCH_DEAD_CODE, ClassFile.StackMapsOption.STACK_MAPS_WHEN_REQUIRED, ClassFile.ClassHierarchyResolverOption.of(classDesc -> {
            if (!classDesc.isClassOrInterface()) {
                return null;
            }
            if (classDesc.equals(ConstantDescs.CD_Object)) {
                return ClassHierarchyResolver.ClassHierarchyInfo.ofClass(null);
            }
            String superClass = this.getSuperClass(classDesc.displayName().replace('.', '/'));
            return superClass == null ? ClassHierarchyResolver.ClassHierarchyInfo.ofInterface() : ClassHierarchyResolver.ClassHierarchyInfo.ofClass((ClassDesc)ClassDesc.ofInternalName(superClass));
        })});
        if (this.classModel == null) {
            this.bytes = classFile.build(this.thisClass, classBuilder -> this.classConsumers.forEach(classConsumer -> classConsumer.accept(classBuilder)));
        } else {
            ConstantPoolBuilder constantPoolBuilder = ConstantPoolBuilder.of((ClassModel)this.classModel);
            this.bytes = classFile.build(constantPoolBuilder.classEntry(this.thisClass), constantPoolBuilder, classBuilder -> this.classConsumers.forEach(classConsumer -> classConsumer.accept(classBuilder)));
        }
    }

    static ConstantDesc toConstantDesc(Object asm) {
        Object object = asm;
        int n = 0;
        return switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{Integer.class, Long.class, Float.class, Double.class, String.class, Type.class, Handle.class, ConstantDynamic.class}, (Object)object, n)) {
            case 0 -> {
                Integer value = (Integer)object;
                yield value;
            }
            case 1 -> {
                Long value = (Long)object;
                yield value;
            }
            case 2 -> {
                Float value = (Float)object;
                yield value;
            }
            case 3 -> {
                Double value = (Double)object;
                yield value;
            }
            case 4 -> {
                String value = (String)object;
                yield value;
            }
            case 5 -> {
                Type value = (Type)object;
                switch (value.getSort()) {
                    case 9: 
                    case 10: {
                        yield ClassDesc.ofDescriptor(value.getDescriptor());
                    }
                    case 11: {
                        yield MethodTypeDesc.ofDescriptor(value.getDescriptor());
                    }
                }
                throw new IllegalArgumentException("Unexpected type sort: " + value.getSort());
            }
            case 6 -> {
                Handle value = (Handle)object;
                yield MethodHandleDesc.of(DirectMethodHandleDesc.Kind.valueOf(value.getTag(), value.isInterface()), ClassDesc.ofInternalName(value.getOwner()), value.getName(), value.getDesc());
            }
            case 7 -> {
                ConstantDynamic value = (ConstantDynamic)object;
                ConstantDesc[] constants = new ConstantDesc[value.getBootstrapMethodArgumentCount()];
                for (int index = 0; index < value.getBootstrapMethodArgumentCount(); ++index) {
                    constants[index] = JdkClassWriter.toConstantDesc(value.getBootstrapMethodArgument(index));
                }
                yield DynamicConstantDesc.ofNamed(MethodHandleDesc.of(DirectMethodHandleDesc.Kind.valueOf(value.getBootstrapMethod().getTag(), value.getBootstrapMethod().isInterface()), ClassDesc.ofInternalName(value.getBootstrapMethod().getOwner()), value.getBootstrapMethod().getName(), value.getBootstrapMethod().getDesc()), value.getName(), ClassDesc.ofDescriptor(value.getDescriptor()), constants);
            }
            default -> throw new IllegalArgumentException("Unexpected constant: " + String.valueOf(asm));
        };
    }

    public byte[] toByteArray() {
        if (this.bytes == null) {
            throw new IllegalStateException("Did not visitEnd, and no byte array was created");
        }
        return this.bytes;
    }

    protected String getSuperClass(String name) {
        Class<?> type;
        ClassLoader classLoader = this.getClassLoader();
        try {
            type = Class.forName(name.replace('/', '.'), false, classLoader);
        }
        catch (ClassNotFoundException e) {
            throw new TypeNotPresentException(name.replace('/', '.'), e);
        }
        if (type.isInterface()) {
            return null;
        }
        return Type.getInternalName(type.getSuperclass());
    }

    protected ClassLoader getClassLoader() {
        return ((Object)((Object)this)).getClass().getClassLoader();
    }

    class WritingModuleVisitor
    extends ModuleVisitor {
        private final String name;
        private final int access;
        private final String version;
        private String mainClass;
        private final List<PackageDesc> packages;
        private final List<Consumer<ModuleAttribute.ModuleAttributeBuilder>> moduleAttributeConsumers;

        private WritingModuleVisitor(String name, int access, String version) {
            super(589824);
            this.packages = new ArrayList<PackageDesc>();
            this.moduleAttributeConsumers = new ArrayList<Consumer<ModuleAttribute.ModuleAttributeBuilder>>();
            this.name = name;
            this.access = access;
            this.version = version;
        }

        boolean has(ClassModel classModel) {
            return Objects.equals(JdkClassWriter.this.classModel, classModel);
        }

        void add(ClassElement element) {
            JdkClassWriter.this.classConsumers.add(classBuilder -> classBuilder.with((ClassFileElement)element));
        }

        public void visitMainClass(String mainClass) {
            this.mainClass = mainClass;
        }

        public void visitPackage(String packaze) {
            this.packages.add(PackageDesc.ofInternalName(packaze));
        }

        public void visitRequire(String module, int access, String version) {
            this.moduleAttributeConsumers.add(moduleAttributeBuilder -> moduleAttributeBuilder.requires(ModuleDesc.of(module), access, version));
        }

        public void visitExport(String packaze, int access, String ... modules) {
            this.moduleAttributeConsumers.add(moduleAttributeBuilder -> {
                ModuleDesc[] descriptions = new ModuleDesc[modules.length];
                for (int index = 0; index < modules.length; ++index) {
                    descriptions[index] = ModuleDesc.of(modules[index]);
                }
                moduleAttributeBuilder.exports(PackageDesc.ofInternalName(packaze), access, descriptions);
            });
        }

        public void visitOpen(String packaze, int access, String ... modules) {
            this.moduleAttributeConsumers.add(moduleAttributeBuilder -> {
                ModuleDesc[] descriptions = new ModuleDesc[modules.length];
                for (int index = 0; index < modules.length; ++index) {
                    descriptions[index] = ModuleDesc.of(modules[index]);
                }
                moduleAttributeBuilder.opens(PackageDesc.ofInternalName(packaze), access, descriptions);
            });
        }

        public void visitUse(String service) {
            this.moduleAttributeConsumers.add(moduleAttributeBuilder -> moduleAttributeBuilder.uses(ClassDesc.ofInternalName(service)));
        }

        public void visitProvide(String service, String ... providers) {
            this.moduleAttributeConsumers.add(moduleAttributeBuilder -> {
                ClassDesc[] descriptions = new ClassDesc[providers.length];
                for (int index = 0; index < providers.length; ++index) {
                    descriptions[index] = ClassDesc.of(providers[index]);
                }
                moduleAttributeBuilder.provides(ClassDesc.ofInternalName(service), descriptions);
            });
        }

        public void visitEnd() {
            JdkClassWriter.this.classConsumers.add(classBuilder -> {
                classBuilder.with((ClassFileElement)ModuleAttribute.of((ModuleDesc)ModuleDesc.of(this.name), moduleAttributeBuilder -> {
                    moduleAttributeBuilder.moduleFlags(this.access & 0xFFFDFFFF);
                    if (this.version != null) {
                        moduleAttributeBuilder.moduleVersion(this.version);
                    }
                    this.moduleAttributeConsumers.forEach(moduleAttributeConsumer -> moduleAttributeConsumer.accept(moduleAttributeBuilder));
                }));
                if (this.mainClass != null) {
                    classBuilder.with((ClassFileElement)ModuleMainClassAttribute.of((ClassDesc)ClassDesc.ofInternalName(this.mainClass)));
                }
                if (!this.packages.isEmpty()) {
                    classBuilder.with((ClassFileElement)ModulePackagesAttribute.ofNames(this.packages));
                }
            });
        }
    }

    class WritingAnnotationVisitor
    extends AnnotationVisitor {
        private final BiConsumer<String, AnnotationValue> consumer;
        private final Runnable onEnd;

        private static AnnotationVisitor of(JdkClassWriter classWriter, String descriptor, Consumer<Annotation> consumer) {
            ArrayList elements = new ArrayList();
            JdkClassWriter jdkClassWriter = classWriter;
            Objects.requireNonNull(jdkClassWriter);
            return jdkClassWriter.new WritingAnnotationVisitor((name, value) -> elements.add(AnnotationElement.of((String)name, (AnnotationValue)value)), () -> consumer.accept(Annotation.of((ClassDesc)ClassDesc.ofDescriptor(descriptor), (List)elements)));
        }

        private static AnnotationVisitor ofValue(JdkClassWriter classWriter, Consumer<AnnotationValue> consumer) {
            JdkClassWriter jdkClassWriter = classWriter;
            Objects.requireNonNull(jdkClassWriter);
            return jdkClassWriter.new WritingAnnotationVisitor((string, value) -> consumer.accept((AnnotationValue)value), () -> {});
        }

        private static AnnotationVisitor ofTypeAnnotation(JdkClassWriter classWriter, String descriptor, int typeRef, TypePath typePath, Consumer<TypeAnnotation> consumer) {
            return WritingAnnotationVisitor.ofUnresolvedTypeAnnotation(classWriter, descriptor, typeRef, typePath, function -> consumer.accept((TypeAnnotation)function.apply(reference -> switch (reference.getSort()) {
                case 0 -> TypeAnnotation.TargetInfo.ofClassTypeParameter((int)reference.getTypeParameterIndex());
                case 1 -> TypeAnnotation.TargetInfo.ofMethodTypeParameter((int)reference.getTypeParameterIndex());
                case 16 -> TypeAnnotation.TargetInfo.ofClassExtends((int)reference.getSuperTypeIndex());
                case 17 -> TypeAnnotation.TargetInfo.ofClassTypeParameterBound((int)reference.getTypeParameterIndex(), (int)reference.getTypeParameterBoundIndex());
                case 18 -> TypeAnnotation.TargetInfo.ofMethodTypeParameterBound((int)reference.getTypeParameterIndex(), (int)reference.getTypeParameterBoundIndex());
                case 19 -> TypeAnnotation.TargetInfo.ofField();
                case 20 -> TypeAnnotation.TargetInfo.ofMethodReturn();
                case 21 -> TypeAnnotation.TargetInfo.ofMethodReceiver();
                case 22 -> TypeAnnotation.TargetInfo.ofMethodFormalParameter((int)reference.getFormalParameterIndex());
                case 23 -> TypeAnnotation.TargetInfo.ofThrows((int)reference.getExceptionIndex());
                default -> throw new IllegalArgumentException("Unexpected reference sort: " + reference.getSort());
            })));
        }

        private static AnnotationVisitor ofExceptionTypeAnnotation(JdkClassWriter classWriter, String descriptor, int typeRef, TypePath typePath, Consumer<Function<Integer, TypeAnnotation>> consumer) {
            return WritingAnnotationVisitor.ofUnresolvedTypeAnnotation(classWriter, descriptor, typeRef, typePath, function -> consumer.accept(index -> (TypeAnnotation)function.apply(reference -> {
                switch (reference.getSort()) {
                    case 66: {
                        break;
                    }
                    default: {
                        throw new IllegalArgumentException("Unexpected reference sort: " + reference.getSort());
                    }
                }
                return TypeAnnotation.TargetInfo.ofExceptionParameter((int)index);
            })));
        }

        private static AnnotationVisitor ofLabeledTypeAnnotation(JdkClassWriter classWriter, String descriptor, int typeRef, TypePath typePath, Consumer<Function<Label, TypeAnnotation>> consumer) {
            return WritingAnnotationVisitor.ofUnresolvedTypeAnnotation(classWriter, descriptor, typeRef, typePath, function -> consumer.accept(label -> (TypeAnnotation)function.apply(reference -> switch (reference.getSort()) {
                case 67 -> TypeAnnotation.TargetInfo.ofInstanceofExpr((Label)label);
                case 68 -> TypeAnnotation.TargetInfo.ofNewExpr((Label)label);
                case 69 -> TypeAnnotation.TargetInfo.ofConstructorReference((Label)label);
                case 70 -> TypeAnnotation.TargetInfo.ofMethodReference((Label)label);
                case 71 -> TypeAnnotation.TargetInfo.ofCastExpr((Label)label, (int)reference.getTypeArgumentIndex());
                case 72 -> TypeAnnotation.TargetInfo.ofConstructorInvocationTypeArgument((Label)label, (int)reference.getTypeArgumentIndex());
                case 73 -> TypeAnnotation.TargetInfo.ofMethodInvocationTypeArgument((Label)label, (int)reference.getTypeArgumentIndex());
                case 74 -> TypeAnnotation.TargetInfo.ofConstructorReferenceTypeArgument((Label)label, (int)reference.getTypeArgumentIndex());
                case 75 -> TypeAnnotation.TargetInfo.ofMethodReferenceTypeArgument((Label)label, (int)reference.getTypeArgumentIndex());
                default -> throw new IllegalArgumentException("Unexpected reference sort: " + reference.getSort());
            })));
        }

        private static AnnotationVisitor ofTargetedTypeAnnotation(JdkClassWriter classWriter, String descriptor, int typeRef, TypePath typePath, Consumer<Function<List<TypeAnnotation.LocalVarTargetInfo>, TypeAnnotation>> consumer) {
            return WritingAnnotationVisitor.ofUnresolvedTypeAnnotation(classWriter, descriptor, typeRef, typePath, function -> consumer.accept(targets -> (TypeAnnotation)function.apply(reference -> switch (reference.getSort()) {
                case 64 -> TypeAnnotation.TargetInfo.ofLocalVariable((List)targets);
                case 65 -> TypeAnnotation.TargetInfo.ofResourceVariable((List)targets);
                default -> throw new IllegalArgumentException("Unexpected reference sort: " + reference.getSort());
            })));
        }

        private static AnnotationVisitor ofUnresolvedTypeAnnotation(JdkClassWriter classWriter, String descriptor, int typeRef, TypePath typePath, Consumer<Function<Function<TypeReference, TypeAnnotation.TargetInfo>, TypeAnnotation>> consumer) {
            List<TypeAnnotation.TypePathComponent> components;
            ArrayList elements = new ArrayList();
            if (typePath == null) {
                components = List.of();
            } else {
                components = new ArrayList(typePath.getLength());
                for (int index = 0; index < typePath.getLength(); ++index) {
                    components.add(switch (typePath.getStep(index)) {
                        case 0 -> TypeAnnotation.TypePathComponent.ARRAY;
                        case 1 -> TypeAnnotation.TypePathComponent.INNER_TYPE;
                        case 2 -> TypeAnnotation.TypePathComponent.WILDCARD;
                        case 3 -> TypeAnnotation.TypePathComponent.of((TypeAnnotation.TypePathComponent.Kind)TypeAnnotation.TypePathComponent.Kind.TYPE_ARGUMENT, (int)typePath.getStepArgument(index));
                        default -> throw new IllegalArgumentException("Unkniwn type path type: " + typePath.getStep(index));
                    });
                }
            }
            TypeReference reference = new TypeReference(typeRef);
            JdkClassWriter jdkClassWriter = classWriter;
            Objects.requireNonNull(jdkClassWriter);
            return jdkClassWriter.new WritingAnnotationVisitor((name, value) -> elements.add(AnnotationElement.of((String)name, (AnnotationValue)value)), () -> consumer.accept(targeting -> TypeAnnotation.of((TypeAnnotation.TargetInfo)((TypeAnnotation.TargetInfo)targeting.apply(reference)), (List)components, (Annotation)Annotation.of((ClassDesc)ClassDesc.ofDescriptor(descriptor), (List)elements))));
        }

        private WritingAnnotationVisitor(BiConsumer<String, AnnotationValue> consumer, Runnable onEnd) {
            super(589824);
            this.consumer = consumer;
            this.onEnd = onEnd;
        }

        boolean has(ClassModel classModel) {
            return Objects.equals(JdkClassWriter.this.classModel, classModel);
        }

        void add(String name, AnnotationValue annotationValue) {
            this.consumer.accept(name, annotationValue);
        }

        public void visit(String name, Object asm) {
            Object object = asm;
            int n = 0;
            this.consumer.accept(name, (AnnotationValue)(switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{Boolean.class, Byte.class, Short.class, Character.class, Integer.class, Long.class, Float.class, Double.class, String.class, boolean[].class, byte[].class, short[].class, char[].class, int[].class, long[].class, float[].class, double[].class, String[].class, Type.class}, (Object)object, n)) {
                case 0 -> {
                    Boolean value = (Boolean)object;
                    yield AnnotationValue.ofBoolean((boolean)value);
                }
                case 1 -> {
                    Byte value = (Byte)object;
                    yield AnnotationValue.ofByte((byte)value);
                }
                case 2 -> {
                    Short value = (Short)object;
                    yield AnnotationValue.ofShort((short)value);
                }
                case 3 -> {
                    Character value = (Character)object;
                    yield AnnotationValue.ofChar((char)value.charValue());
                }
                case 4 -> {
                    Integer value = (Integer)object;
                    yield AnnotationValue.ofInt((int)value);
                }
                case 5 -> {
                    Long value = (Long)object;
                    yield AnnotationValue.ofLong((long)value);
                }
                case 6 -> {
                    Float value = (Float)object;
                    yield AnnotationValue.ofFloat((float)value.floatValue());
                }
                case 7 -> {
                    Double value = (Double)object;
                    yield AnnotationValue.ofDouble((double)value);
                }
                case 8 -> {
                    String value = (String)object;
                    yield AnnotationValue.ofString((String)value);
                }
                case 9 -> {
                    boolean[] array = (boolean[])object;
                    AnnotationValue[] values = new AnnotationValue[array.length];
                    for (int index = 0; index < array.length; ++index) {
                        values[index] = AnnotationValue.ofBoolean((boolean)array[index]);
                    }
                    yield AnnotationValue.ofArray((AnnotationValue[])values);
                }
                case 10 -> {
                    byte[] array = (byte[])object;
                    AnnotationValue[] values = new AnnotationValue[array.length];
                    for (int index = 0; index < array.length; ++index) {
                        values[index] = AnnotationValue.ofByte((byte)array[index]);
                    }
                    yield AnnotationValue.ofArray((AnnotationValue[])values);
                }
                case 11 -> {
                    short[] array = (short[])object;
                    AnnotationValue[] values = new AnnotationValue[array.length];
                    for (int index = 0; index < array.length; ++index) {
                        values[index] = AnnotationValue.ofShort((short)array[index]);
                    }
                    yield AnnotationValue.ofArray((AnnotationValue[])values);
                }
                case 12 -> {
                    char[] array = (char[])object;
                    AnnotationValue[] values = new AnnotationValue[array.length];
                    for (int index = 0; index < array.length; ++index) {
                        values[index] = AnnotationValue.ofChar((char)array[index]);
                    }
                    yield AnnotationValue.ofArray((AnnotationValue[])values);
                }
                case 13 -> {
                    int[] array = (int[])object;
                    AnnotationValue[] values = new AnnotationValue[array.length];
                    for (int index = 0; index < array.length; ++index) {
                        values[index] = AnnotationValue.ofInt((int)array[index]);
                    }
                    yield AnnotationValue.ofArray((AnnotationValue[])values);
                }
                case 14 -> {
                    long[] array = (long[])object;
                    AnnotationValue[] values = new AnnotationValue[array.length];
                    for (int index = 0; index < array.length; ++index) {
                        values[index] = AnnotationValue.ofLong((long)array[index]);
                    }
                    yield AnnotationValue.ofArray((AnnotationValue[])values);
                }
                case 15 -> {
                    float[] array = (float[])object;
                    AnnotationValue[] values = new AnnotationValue[array.length];
                    for (int index = 0; index < array.length; ++index) {
                        values[index] = AnnotationValue.ofFloat((float)array[index]);
                    }
                    yield AnnotationValue.ofArray((AnnotationValue[])values);
                }
                case 16 -> {
                    double[] array = (double[])object;
                    AnnotationValue[] values = new AnnotationValue[array.length];
                    for (int index = 0; index < array.length; ++index) {
                        values[index] = AnnotationValue.ofDouble((double)array[index]);
                    }
                    yield AnnotationValue.ofArray((AnnotationValue[])values);
                }
                case 17 -> {
                    String[] array = (String[])object;
                    AnnotationValue[] values = new AnnotationValue[array.length];
                    for (int index = 0; index < array.length; ++index) {
                        values[index] = AnnotationValue.ofString((String)array[index]);
                    }
                    yield AnnotationValue.ofArray((AnnotationValue[])values);
                }
                case 18 -> {
                    Type type = (Type)object;
                    yield AnnotationValue.ofClass((ClassDesc)ClassDesc.ofDescriptor(type.getDescriptor()));
                }
                default -> throw new IllegalArgumentException("Unknown annotation value: " + String.valueOf(asm));
            }));
        }

        public void visitEnum(String name, String descriptor, String value) {
            this.consumer.accept(name, (AnnotationValue)AnnotationValue.ofEnum((ClassDesc)ClassDesc.ofDescriptor(descriptor), (String)value));
        }

        public AnnotationVisitor visitAnnotation(String name, String descriptor) {
            return WritingAnnotationVisitor.of(JdkClassWriter.this, descriptor, annotation -> this.consumer.accept(name, (AnnotationValue)AnnotationValue.ofAnnotation((Annotation)annotation)));
        }

        public AnnotationVisitor visitArray(String name) {
            ArrayList values = new ArrayList();
            return new WritingAnnotationVisitor((string, value) -> values.add(value), () -> this.consumer.accept(name, (AnnotationValue)AnnotationValue.ofArray((List)values)));
        }

        public void visitEnd() {
            this.onEnd.run();
        }
    }

    class WritingFieldVisitor
    extends FieldVisitor {
        private final int access;
        private final String name;
        private final String descriptor;
        private final String signature;
        private final Object value;
        private final List<FieldElement> attributes;
        private final List<Annotation> visibleAnnotations;
        private final List<Annotation> invisibleAnnotations;
        private final List<TypeAnnotation> visibleTypeAnnotations;
        private final List<TypeAnnotation> invisibleTypeAnnotations;

        private WritingFieldVisitor(int access, String name, String descriptor, String signature, Object value) {
            super(589824);
            this.attributes = new ArrayList<FieldElement>();
            this.visibleAnnotations = new ArrayList<Annotation>();
            this.invisibleAnnotations = new ArrayList<Annotation>();
            this.visibleTypeAnnotations = new ArrayList<TypeAnnotation>();
            this.invisibleTypeAnnotations = new ArrayList<TypeAnnotation>();
            this.access = access;
            this.name = name;
            this.descriptor = descriptor;
            this.signature = signature;
            this.value = value;
        }

        boolean has(ClassModel classModel) {
            return Objects.equals(JdkClassWriter.this.classModel, classModel);
        }

        void add(FieldModel field) {
            JdkClassWriter.this.classConsumers.add(classBuilder -> classBuilder.with((ClassFileElement)field));
        }

        public void visitAttribute(Attribute attribute) {
            this.attributes.add(AsmWrappedAttribute.unwrap(attribute, FieldElement.class));
        }

        public AnnotationVisitor visitAnnotation(String descriptor, boolean visible) {
            return WritingAnnotationVisitor.of(JdkClassWriter.this, descriptor, (visible ? this.visibleAnnotations : this.invisibleAnnotations)::add);
        }

        public AnnotationVisitor visitTypeAnnotation(int typeRef, TypePath typePath, String descriptor, boolean visible) {
            return WritingAnnotationVisitor.ofTypeAnnotation(JdkClassWriter.this, descriptor, typeRef, typePath, (visible ? this.visibleTypeAnnotations : this.invisibleTypeAnnotations)::add);
        }

        public void visitEnd() {
            JdkClassWriter.this.classConsumers.add(classBuilder -> classBuilder.withField(this.name, ClassDesc.ofDescriptor(this.descriptor), fieldBuilder -> {
                fieldBuilder.withFlags(this.access & 0xFFFDFFFF);
                if ((this.access & 0x20000) != 0) {
                    fieldBuilder.with((ClassFileElement)DeprecatedAttribute.of());
                }
                if (this.signature != null) {
                    fieldBuilder.with((ClassFileElement)SignatureAttribute.of((Utf8Entry)classBuilder.constantPool().utf8Entry(this.signature)));
                }
                for (FieldElement attribute : this.attributes) {
                    fieldBuilder.with((ClassFileElement)attribute);
                }
                if (!this.visibleAnnotations.isEmpty()) {
                    fieldBuilder.with((ClassFileElement)RuntimeVisibleAnnotationsAttribute.of(this.visibleAnnotations));
                }
                if (!this.invisibleAnnotations.isEmpty()) {
                    fieldBuilder.with((ClassFileElement)RuntimeInvisibleAnnotationsAttribute.of(this.invisibleAnnotations));
                }
                if (!this.visibleTypeAnnotations.isEmpty()) {
                    fieldBuilder.with((ClassFileElement)RuntimeVisibleTypeAnnotationsAttribute.of(this.visibleTypeAnnotations));
                }
                if (!this.invisibleTypeAnnotations.isEmpty()) {
                    fieldBuilder.with((ClassFileElement)RuntimeInvisibleTypeAnnotationsAttribute.of(this.invisibleTypeAnnotations));
                }
                if (this.value != null) {
                    fieldBuilder.with((ClassFileElement)ConstantValueAttribute.of((ConstantDesc)JdkClassWriter.toConstantDesc(this.value)));
                }
            }));
        }
    }

    class WritingMethodVisitor
    extends MethodVisitor {
        private final int access;
        private final String name;
        private final String descriptor;
        private final String signature;
        private final String[] exceptions;
        private List<Consumer<CodeBuilder>> codeConsumers;
        private final List<MethodElement> attributes;
        private final List<CodeElement> codeAttributes;
        private AnnotationValue defaultValue;
        private int catchCount;
        private final List<StackMapFrameInfo.VerificationTypeInfo> locals;
        private final List<MethodParameterInfo> methodParameters;
        private final List<Annotation> visibleAnnotations;
        private final List<Annotation> invisibleAnnotations;
        private final List<TypeAnnotation> visibleTypeAnnotations;
        private final List<TypeAnnotation> invisibleTypeAnnotations;
        private final Map<Integer, List<Annotation>> visibleParameterAnnotations;
        private final Map<Integer, List<Annotation>> invisibleParameterAnnotations;
        private int visibleParameterAnnotationsCount;
        private int invisibleParameterAnnotationsCount;
        private Map<org.objectweb.asm.Label, Integer> lineNumbers;
        private List<StackMapFrameInfo> stackMapFrames;
        private Map<org.objectweb.asm.Label, Label> labels;
        private Consumer<CodeBuilder> dalayedInstruction;

        private void addInstruction(Consumer<CodeBuilder> consumer) {
            this.undelayInstruction();
            this.dalayedInstruction = consumer;
        }

        private void undelayInstruction() {
            if (this.dalayedInstruction != null) {
                this.codeConsumers.add(this.dalayedInstruction);
                this.dalayedInstruction = null;
            }
        }

        private WritingMethodVisitor(int access, String name, String descriptor, String signature, String[] exceptions) {
            super(589824);
            this.attributes = new ArrayList<MethodElement>();
            this.codeAttributes = new ArrayList<CodeElement>();
            this.catchCount = -1;
            this.locals = new ArrayList<StackMapFrameInfo.VerificationTypeInfo>();
            this.methodParameters = new ArrayList<MethodParameterInfo>();
            this.visibleAnnotations = new ArrayList<Annotation>();
            this.invisibleAnnotations = new ArrayList<Annotation>();
            this.visibleTypeAnnotations = new ArrayList<TypeAnnotation>();
            this.invisibleTypeAnnotations = new ArrayList<TypeAnnotation>();
            this.visibleParameterAnnotations = new HashMap<Integer, List<Annotation>>();
            this.invisibleParameterAnnotations = new HashMap<Integer, List<Annotation>>();
            this.access = access;
            this.name = name;
            this.descriptor = descriptor;
            this.signature = signature;
            this.exceptions = exceptions;
        }

        boolean has(ClassModel classModel) {
            return Objects.equals(JdkClassWriter.this.classModel, classModel);
        }

        void add(MethodModel model) {
            JdkClassWriter.this.classConsumers.add(classBuilder -> classBuilder.with((ClassFileElement)model));
        }

        public void visitCode() {
            this.codeConsumers = new ArrayList<Consumer<CodeBuilder>>();
            this.lineNumbers = new IdentityHashMap<org.objectweb.asm.Label, Integer>();
            this.codeConsumers.add(codeBuilder -> {
                this.stackMapFrames = new ArrayList<StackMapFrameInfo>();
                this.labels = new IdentityHashMap<org.objectweb.asm.Label, Label>();
                this.dalayedInstruction = null;
            });
            if ((JdkClassWriter.this.flags & 2) == 0) {
                if ((this.access & 8) == 0) {
                    this.locals.add((StackMapFrameInfo.VerificationTypeInfo)(this.name.equals("<init>") ? StackMapFrameInfo.SimpleVerificationTypeInfo.UNINITIALIZED_THIS : StackMapFrameInfo.ObjectVerificationTypeInfo.of((ClassDesc)JdkClassWriter.this.thisClass)));
                }
                Type type = Type.getMethodType((String)this.descriptor);
                for (Type argumentType : type.getArgumentTypes()) {
                    this.locals.add((StackMapFrameInfo.VerificationTypeInfo)(switch (argumentType.getSort()) {
                        case 1, 2, 3, 4, 5 -> StackMapFrameInfo.SimpleVerificationTypeInfo.INTEGER;
                        case 7 -> StackMapFrameInfo.SimpleVerificationTypeInfo.LONG;
                        case 6 -> StackMapFrameInfo.SimpleVerificationTypeInfo.FLOAT;
                        case 8 -> StackMapFrameInfo.SimpleVerificationTypeInfo.DOUBLE;
                        default -> StackMapFrameInfo.ObjectVerificationTypeInfo.of((ClassDesc)ClassDesc.ofDescriptor(argumentType.getDescriptor()));
                    }));
                }
            }
        }

        public void visitAttribute(Attribute attribute) {
            if (attribute.isCodeAttribute()) {
                this.codeAttributes.add(AsmWrappedAttribute.unwrap(attribute, CodeElement.class));
            } else {
                this.attributes.add(AsmWrappedAttribute.unwrap(attribute, MethodElement.class));
            }
        }

        public AnnotationVisitor visitAnnotation(String descriptor, boolean visible) {
            return WritingAnnotationVisitor.of(JdkClassWriter.this, descriptor, (visible ? this.visibleAnnotations : this.invisibleAnnotations)::add);
        }

        public AnnotationVisitor visitTypeAnnotation(int typeRef, TypePath typePath, String descriptor, boolean visible) {
            return WritingAnnotationVisitor.ofTypeAnnotation(JdkClassWriter.this, descriptor, typeRef, typePath, (visible ? this.visibleTypeAnnotations : this.invisibleTypeAnnotations)::add);
        }

        public void visitParameter(String name, int access) {
            this.methodParameters.add(MethodParameterInfo.ofParameter(Optional.ofNullable(name), (int)access));
        }

        public void visitAnnotableParameterCount(int parameterCount, boolean visible) {
            if (visible) {
                this.visibleParameterAnnotationsCount = parameterCount;
            } else {
                this.invisibleParameterAnnotationsCount = parameterCount;
            }
        }

        public AnnotationVisitor visitParameterAnnotation(int parameter, String descriptor, boolean visible) {
            return WritingAnnotationVisitor.of(JdkClassWriter.this, descriptor, (visible ? this.visibleParameterAnnotations : this.invisibleParameterAnnotations).computeIfAbsent(parameter, n -> new ArrayList())::add);
        }

        public AnnotationVisitor visitTryCatchAnnotation(int typeRef, TypePath typePath, String descriptor, boolean visible) {
            int catchCount = this.catchCount;
            return WritingAnnotationVisitor.ofExceptionTypeAnnotation(JdkClassWriter.this, descriptor, typeRef, typePath, function -> this.codeConsumers.add(codeBuilder -> {
                TypeAnnotation annotation = (TypeAnnotation)function.apply(catchCount);
                codeBuilder.with((ClassFileElement)(visible ? RuntimeVisibleTypeAnnotationsAttribute.of((TypeAnnotation[])new TypeAnnotation[]{annotation}) : RuntimeInvisibleTypeAnnotationsAttribute.of((TypeAnnotation[])new TypeAnnotation[]{annotation})));
            }));
        }

        public AnnotationVisitor visitInsnAnnotation(int typeRef, TypePath typePath, String descriptor, boolean visible) {
            return WritingAnnotationVisitor.ofLabeledTypeAnnotation(JdkClassWriter.this, descriptor, typeRef, typePath, function -> this.codeConsumers.add(codeBuilder -> {
                TypeAnnotation annotation = (TypeAnnotation)function.apply(codeBuilder.newBoundLabel());
                codeBuilder.with((ClassFileElement)(visible ? RuntimeVisibleTypeAnnotationsAttribute.of((TypeAnnotation[])new TypeAnnotation[]{annotation}) : RuntimeInvisibleTypeAnnotationsAttribute.of((TypeAnnotation[])new TypeAnnotation[]{annotation})));
            }));
        }

        public AnnotationVisitor visitAnnotationDefault() {
            return WritingAnnotationVisitor.ofValue(JdkClassWriter.this, value -> {
                this.defaultValue = value;
            });
        }

        public AnnotationVisitor visitLocalVariableAnnotation(int typeRef, TypePath typePath, org.objectweb.asm.Label[] start, org.objectweb.asm.Label[] end, int[] indices, String descriptor, boolean visible) {
            this.undelayInstruction();
            return WritingAnnotationVisitor.ofTargetedTypeAnnotation(JdkClassWriter.this, descriptor, typeRef, typePath, function -> this.codeConsumers.add(codeBuilder -> {
                ArrayList<TypeAnnotation.LocalVarTargetInfo> targets = new ArrayList<TypeAnnotation.LocalVarTargetInfo>();
                for (int index = 0; index < start.length; ++index) {
                    targets.add(TypeAnnotation.LocalVarTargetInfo.of((Label)this.labels.computeIfAbsent(start[index], label -> codeBuilder.newLabel()), (Label)this.labels.computeIfAbsent(end[index], label -> codeBuilder.newLabel()), (int)indices[index]));
                }
                TypeAnnotation annotation = (TypeAnnotation)function.apply(targets);
                codeBuilder.with((ClassFileElement)(visible ? RuntimeVisibleTypeAnnotationsAttribute.of((TypeAnnotation[])new TypeAnnotation[]{annotation}) : RuntimeInvisibleTypeAnnotationsAttribute.of((TypeAnnotation[])new TypeAnnotation[]{annotation})));
            }));
        }

        public void visitFrame(int type, int numLocal, Object[] local, int numStack, Object[] stack) {
            this.undelayInstruction();
            if ((JdkClassWriter.this.flags & 2) != 0) {
                return;
            }
            this.codeConsumers.add(codeBuilder -> {
                int index;
                ArrayList<StackMapFrameInfo.VerificationTypeInfo> stacks = new ArrayList<StackMapFrameInfo.VerificationTypeInfo>(numStack);
                for (index = 0; index < numStack; ++index) {
                    stacks.add(WritingMethodVisitor.toVerificationTypeInfo(stack[index], label2 -> this.labels.computeIfAbsent((org.objectweb.asm.Label)label2, label -> codeBuilder.newLabel())));
                }
                switch (type) {
                    case 3: {
                        break;
                    }
                    case 4: {
                        break;
                    }
                    case 1: {
                        for (index = 0; index < numLocal; ++index) {
                            this.locals.add(WritingMethodVisitor.toVerificationTypeInfo(local[index], label2 -> this.labels.computeIfAbsent((org.objectweb.asm.Label)label2, label -> codeBuilder.newLabel())));
                        }
                        break;
                    }
                    case 2: {
                        this.locals.subList(this.locals.size() - numLocal, this.locals.size()).clear();
                        break;
                    }
                    case -1: 
                    case 0: {
                        this.locals.clear();
                        for (index = 0; index < numLocal; ++index) {
                            this.locals.add(WritingMethodVisitor.toVerificationTypeInfo(local[index], label2 -> this.labels.computeIfAbsent((org.objectweb.asm.Label)label2, label -> codeBuilder.newLabel())));
                        }
                        break;
                    }
                    default: {
                        throw new IllegalArgumentException("Unsupported type: " + type);
                    }
                }
                this.stackMapFrames.add(StackMapFrameInfo.of((Label)codeBuilder.newBoundLabel(), new ArrayList<StackMapFrameInfo.VerificationTypeInfo>(this.locals), stacks));
            });
        }

        private static StackMapFrameInfo.VerificationTypeInfo toVerificationTypeInfo(Object value, Function<org.objectweb.asm.Label, Label> labels) {
            if (value == Opcodes.TOP) {
                return StackMapFrameInfo.SimpleVerificationTypeInfo.TOP;
            }
            if (value == Opcodes.INTEGER) {
                return StackMapFrameInfo.SimpleVerificationTypeInfo.INTEGER;
            }
            if (value == Opcodes.LONG) {
                return StackMapFrameInfo.SimpleVerificationTypeInfo.LONG;
            }
            if (value == Opcodes.FLOAT) {
                return StackMapFrameInfo.SimpleVerificationTypeInfo.FLOAT;
            }
            if (value == Opcodes.DOUBLE) {
                return StackMapFrameInfo.SimpleVerificationTypeInfo.DOUBLE;
            }
            if (value == Opcodes.NULL) {
                return StackMapFrameInfo.SimpleVerificationTypeInfo.NULL;
            }
            if (value == Opcodes.UNINITIALIZED_THIS) {
                return StackMapFrameInfo.SimpleVerificationTypeInfo.UNINITIALIZED_THIS;
            }
            if (value instanceof org.objectweb.asm.Label) {
                org.objectweb.asm.Label label = (org.objectweb.asm.Label)value;
                return StackMapFrameInfo.UninitializedVerificationTypeInfo.of((Label)labels.apply(label));
            }
            if (value instanceof String) {
                String name = (String)value;
                return StackMapFrameInfo.ObjectVerificationTypeInfo.of((ClassDesc)(name.startsWith("[") ? ClassDesc.ofDescriptor(name) : ClassDesc.ofInternalName(name)));
            }
            throw new IllegalArgumentException("Unsupported type: " + String.valueOf(value));
        }

        public void visitInsn(int opcode) {
            Consumer<CodeBuilder> codeConsumer = switch (opcode) {
                case 0 -> CodeBuilder::nop;
                case 1 -> CodeBuilder::aconst_null;
                case 2 -> CodeBuilder::iconst_m1;
                case 3 -> CodeBuilder::iconst_0;
                case 4 -> CodeBuilder::iconst_1;
                case 5 -> CodeBuilder::iconst_2;
                case 6 -> CodeBuilder::iconst_3;
                case 7 -> CodeBuilder::iconst_4;
                case 8 -> CodeBuilder::iconst_5;
                case 9 -> CodeBuilder::lconst_0;
                case 10 -> CodeBuilder::lconst_1;
                case 11 -> CodeBuilder::fconst_0;
                case 12 -> CodeBuilder::fconst_1;
                case 14 -> CodeBuilder::dconst_0;
                case 15 -> CodeBuilder::dconst_1;
                case 46 -> CodeBuilder::iaload;
                case 47 -> CodeBuilder::laload;
                case 48 -> CodeBuilder::faload;
                case 49 -> CodeBuilder::daload;
                case 50 -> CodeBuilder::aaload;
                case 51 -> CodeBuilder::baload;
                case 52 -> CodeBuilder::caload;
                case 53 -> CodeBuilder::saload;
                case 79 -> CodeBuilder::iastore;
                case 80 -> CodeBuilder::lastore;
                case 81 -> CodeBuilder::fastore;
                case 82 -> CodeBuilder::dastore;
                case 83 -> CodeBuilder::aastore;
                case 84 -> CodeBuilder::bastore;
                case 85 -> CodeBuilder::castore;
                case 86 -> CodeBuilder::sastore;
                case 87 -> CodeBuilder::pop;
                case 88 -> CodeBuilder::pop2;
                case 89 -> CodeBuilder::dup;
                case 90 -> CodeBuilder::dup_x1;
                case 91 -> CodeBuilder::dup_x2;
                case 92 -> CodeBuilder::dup2;
                case 93 -> CodeBuilder::dup2_x1;
                case 94 -> CodeBuilder::dup2_x2;
                case 95 -> CodeBuilder::swap;
                case 96 -> CodeBuilder::iadd;
                case 97 -> CodeBuilder::ladd;
                case 98 -> CodeBuilder::fadd;
                case 99 -> CodeBuilder::dadd;
                case 100 -> CodeBuilder::isub;
                case 101 -> CodeBuilder::lsub;
                case 102 -> CodeBuilder::fsub;
                case 103 -> CodeBuilder::dsub;
                case 104 -> CodeBuilder::imul;
                case 105 -> CodeBuilder::lmul;
                case 106 -> CodeBuilder::fmul;
                case 107 -> CodeBuilder::dmul;
                case 108 -> CodeBuilder::idiv;
                case 109 -> CodeBuilder::ldiv;
                case 110 -> CodeBuilder::fdiv;
                case 111 -> CodeBuilder::ddiv;
                case 112 -> CodeBuilder::irem;
                case 113 -> CodeBuilder::lrem;
                case 114 -> CodeBuilder::frem;
                case 115 -> CodeBuilder::drem;
                case 116 -> CodeBuilder::ineg;
                case 117 -> CodeBuilder::lneg;
                case 118 -> CodeBuilder::fneg;
                case 119 -> CodeBuilder::dneg;
                case 120 -> CodeBuilder::ishl;
                case 121 -> CodeBuilder::lshl;
                case 122 -> CodeBuilder::ishr;
                case 123 -> CodeBuilder::lshr;
                case 124 -> CodeBuilder::iushr;
                case 125 -> CodeBuilder::lushr;
                case 126 -> CodeBuilder::iand;
                case 127 -> CodeBuilder::land;
                case 128 -> CodeBuilder::ior;
                case 129 -> CodeBuilder::lor;
                case 130 -> CodeBuilder::ixor;
                case 131 -> CodeBuilder::lxor;
                case 133 -> CodeBuilder::i2l;
                case 134 -> CodeBuilder::i2f;
                case 135 -> CodeBuilder::i2d;
                case 136 -> CodeBuilder::l2i;
                case 137 -> CodeBuilder::l2f;
                case 138 -> CodeBuilder::l2d;
                case 139 -> CodeBuilder::f2i;
                case 140 -> CodeBuilder::f2l;
                case 141 -> CodeBuilder::f2d;
                case 142 -> CodeBuilder::d2i;
                case 143 -> CodeBuilder::d2l;
                case 144 -> CodeBuilder::d2f;
                case 145 -> CodeBuilder::i2b;
                case 146 -> CodeBuilder::i2c;
                case 147 -> CodeBuilder::i2s;
                case 148 -> CodeBuilder::lcmp;
                case 149 -> CodeBuilder::fcmpl;
                case 150 -> CodeBuilder::fcmpg;
                case 151 -> CodeBuilder::dcmpl;
                case 152 -> CodeBuilder::dcmpg;
                case 172 -> CodeBuilder::ireturn;
                case 173 -> CodeBuilder::lreturn;
                case 174 -> CodeBuilder::freturn;
                case 175 -> CodeBuilder::dreturn;
                case 176 -> CodeBuilder::areturn;
                case 177 -> CodeBuilder::return_;
                case 190 -> CodeBuilder::arraylength;
                case 191 -> CodeBuilder::athrow;
                case 194 -> CodeBuilder::monitorenter;
                case 195 -> CodeBuilder::monitorexit;
                default -> throw new IllegalArgumentException("Unexpected opcode: " + opcode);
            };
            this.addInstruction(codeConsumer);
        }

        public void visitIntInsn(int opcode, int operand) {
            Consumer<CodeBuilder> codeConsumer = switch (opcode) {
                case 16 -> codeBuilder -> codeBuilder.bipush(operand);
                case 17 -> codeBuilder -> codeBuilder.sipush(operand);
                case 188 -> codeBuilder -> codeBuilder.newarray(TypeKind.fromNewarrayCode((int)operand));
                default -> throw new IllegalArgumentException("Unexpected opcode: " + opcode);
            };
            this.addInstruction(codeConsumer);
        }

        public void visitVarInsn(int opcode, int varIndex) {
            Consumer<CodeBuilder> codeConsumer = switch (opcode) {
                case 21 -> codeBuilder -> codeBuilder.iload(varIndex);
                case 22 -> codeBuilder -> codeBuilder.lload(varIndex);
                case 23 -> codeBuilder -> codeBuilder.fload(varIndex);
                case 24 -> codeBuilder -> codeBuilder.dload(varIndex);
                case 25 -> codeBuilder -> codeBuilder.aload(varIndex);
                case 54 -> codeBuilder -> codeBuilder.istore(varIndex);
                case 55 -> codeBuilder -> codeBuilder.lstore(varIndex);
                case 56 -> codeBuilder -> codeBuilder.fstore(varIndex);
                case 57 -> codeBuilder -> codeBuilder.dstore(varIndex);
                case 58 -> codeBuilder -> codeBuilder.astore(varIndex);
                case 169 -> codeBuilder -> codeBuilder.with((ClassFileElement)DiscontinuedInstruction.RetInstruction.of((int)varIndex));
                default -> throw new IllegalArgumentException("Unexpected opcode: " + opcode);
            };
            this.addInstruction(codeConsumer);
        }

        public void visitFieldInsn(int opcode, String owner, String name, String descriptor) {
            Consumer<CodeBuilder> codeConsumer = codeBuilder -> codeBuilder.fieldAccess(switch (opcode) {
                case 180 -> Opcode.GETFIELD;
                case 181 -> Opcode.PUTFIELD;
                case 178 -> Opcode.GETSTATIC;
                case 179 -> Opcode.PUTSTATIC;
                default -> throw new IllegalArgumentException("Unexpected opcode: " + opcode);
            }, ClassDesc.ofInternalName(owner), name, ClassDesc.ofDescriptor(descriptor));
            this.addInstruction(codeConsumer);
        }

        public void visitMethodInsn(int opcode, String owner, String name, String descriptor, boolean isInterface) {
            Consumer<CodeBuilder> codeConsumer = codeBuilder -> codeBuilder.invoke(switch (opcode) {
                case 182 -> Opcode.INVOKEVIRTUAL;
                case 185 -> Opcode.INVOKEINTERFACE;
                case 183 -> Opcode.INVOKESPECIAL;
                case 184 -> Opcode.INVOKESTATIC;
                default -> throw new IllegalArgumentException("Unexpected opcode: " + opcode);
            }, owner.startsWith("[") ? ClassDesc.ofDescriptor(owner) : ClassDesc.ofInternalName(owner), name, MethodTypeDesc.ofDescriptor(descriptor), isInterface);
            this.addInstruction(codeConsumer);
        }

        public void visitInvokeDynamicInsn(String name, String descriptor, Handle bootstrapMethodHandle, Object ... bootstrapMethodArguments) {
            ConstantDesc[] constants = new ConstantDesc[bootstrapMethodArguments.length];
            for (int index = 0; index < bootstrapMethodArguments.length; ++index) {
                constants[index] = JdkClassWriter.toConstantDesc(bootstrapMethodArguments[index]);
            }
            Consumer<CodeBuilder> codeConsumer = codeBuilder -> codeBuilder.invokedynamic(DynamicCallSiteDesc.of(MethodHandleDesc.of(DirectMethodHandleDesc.Kind.valueOf(bootstrapMethodHandle.getTag(), bootstrapMethodHandle.isInterface()), ClassDesc.ofInternalName(bootstrapMethodHandle.getOwner()), bootstrapMethodHandle.getName(), bootstrapMethodHandle.getDesc()), name, MethodTypeDesc.ofDescriptor(descriptor), constants));
            this.addInstruction(codeConsumer);
        }

        public void visitJumpInsn(int opcode, org.objectweb.asm.Label label) {
            Consumer<CodeBuilder> codeConsumer = switch (opcode) {
                case 153 -> codeBuilder -> codeBuilder.ifeq(this.labels.computeIfAbsent(label, label -> codeBuilder.newLabel()));
                case 154 -> codeBuilder -> codeBuilder.ifne(this.labels.computeIfAbsent(label, label -> codeBuilder.newLabel()));
                case 155 -> codeBuilder -> codeBuilder.iflt(this.labels.computeIfAbsent(label, label -> codeBuilder.newLabel()));
                case 156 -> codeBuilder -> codeBuilder.ifge(this.labels.computeIfAbsent(label, label -> codeBuilder.newLabel()));
                case 157 -> codeBuilder -> codeBuilder.ifgt(this.labels.computeIfAbsent(label, label -> codeBuilder.newLabel()));
                case 158 -> codeBuilder -> codeBuilder.ifle(this.labels.computeIfAbsent(label, label -> codeBuilder.newLabel()));
                case 159 -> codeBuilder -> codeBuilder.if_icmpeq(this.labels.computeIfAbsent(label, label -> codeBuilder.newLabel()));
                case 160 -> codeBuilder -> codeBuilder.if_icmpne(this.labels.computeIfAbsent(label, label -> codeBuilder.newLabel()));
                case 161 -> codeBuilder -> codeBuilder.if_icmplt(this.labels.computeIfAbsent(label, label -> codeBuilder.newLabel()));
                case 162 -> codeBuilder -> codeBuilder.if_icmpge(this.labels.computeIfAbsent(label, label -> codeBuilder.newLabel()));
                case 163 -> codeBuilder -> codeBuilder.if_icmpgt(this.labels.computeIfAbsent(label, label -> codeBuilder.newLabel()));
                case 164 -> codeBuilder -> codeBuilder.if_icmple(this.labels.computeIfAbsent(label, label -> codeBuilder.newLabel()));
                case 165 -> codeBuilder -> codeBuilder.if_acmpeq(this.labels.computeIfAbsent(label, label -> codeBuilder.newLabel()));
                case 166 -> codeBuilder -> codeBuilder.if_acmpne(this.labels.computeIfAbsent(label, label -> codeBuilder.newLabel()));
                case 167 -> codeBuilder -> codeBuilder.goto_(this.labels.computeIfAbsent(label, label -> codeBuilder.newLabel()));
                case 198 -> codeBuilder -> codeBuilder.ifnull(this.labels.computeIfAbsent(label, label -> codeBuilder.newLabel()));
                case 199 -> codeBuilder -> codeBuilder.ifnonnull(this.labels.computeIfAbsent(label, label -> codeBuilder.newLabel()));
                case 168 -> codeBuilder -> codeBuilder.with((ClassFileElement)DiscontinuedInstruction.JsrInstruction.of((Label)this.labels.computeIfAbsent(label, label -> codeBuilder.newLabel())));
                default -> throw new IllegalArgumentException("Unexpected opcode: " + opcode);
            };
            this.addInstruction(codeConsumer);
        }

        public void visitLdcInsn(Object value) {
            ConstantDesc constant = JdkClassWriter.toConstantDesc(value);
            Consumer<CodeBuilder> codeConsumer = codeBuilder -> codeBuilder.ldc(constant);
            this.addInstruction(codeConsumer);
        }

        public void visitIincInsn(int varIndex, int increment) {
            Consumer<CodeBuilder> codeConsumer = codeBuilder -> codeBuilder.iinc(varIndex, increment);
            this.addInstruction(codeConsumer);
        }

        public void visitLabel(org.objectweb.asm.Label label) {
            Consumer<CodeBuilder> codeConsumer = codeBuilder -> {
                codeBuilder.labelBinding(this.labels.computeIfAbsent(label, label -> codeBuilder.newLabel()));
                Integer lineNumber = this.lineNumbers.remove(label);
                if (lineNumber != null) {
                    codeBuilder.lineNumber(lineNumber.intValue());
                }
            };
            this.addInstruction(codeConsumer);
        }

        public void visitTableSwitchInsn(int min, int max, org.objectweb.asm.Label dflt, org.objectweb.asm.Label ... labels) {
            Consumer<CodeBuilder> codeConsumer = codeBuilder -> {
                SwitchCase[] switchCases = new SwitchCase[labels.length];
                for (int index = 0; index < labels.length; ++index) {
                    switchCases[index] = SwitchCase.of((int)(min + index), (Label)this.labels.computeIfAbsent(labels[index], label -> codeBuilder.newLabel()));
                }
                codeBuilder.tableswitch(min, max, this.labels.computeIfAbsent(dflt, label -> codeBuilder.newLabel()), List.of(switchCases));
            };
            this.addInstruction(codeConsumer);
        }

        public void visitLookupSwitchInsn(org.objectweb.asm.Label dflt, int[] keys, org.objectweb.asm.Label[] labels) {
            Consumer<CodeBuilder> codeConsumer = codeBuilder -> {
                SwitchCase[] switchCases = new SwitchCase[labels.length];
                for (int index = 0; index < labels.length; ++index) {
                    switchCases[index] = SwitchCase.of((int)keys[index], (Label)this.labels.computeIfAbsent(labels[index], label -> codeBuilder.newLabel()));
                }
                codeBuilder.lookupswitch(this.labels.computeIfAbsent(dflt, label -> codeBuilder.newLabel()), List.of(switchCases));
            };
            this.addInstruction(codeConsumer);
        }

        public void visitTypeInsn(int opcode, String type) {
            ClassDesc description = type.startsWith("[") ? ClassDesc.ofDescriptor(type) : ClassDesc.ofInternalName(type);
            Consumer<CodeBuilder> codeConsumer = switch (opcode) {
                case 187 -> codeBuilder -> codeBuilder.new_(description);
                case 189 -> codeBuilder -> codeBuilder.anewarray(description);
                case 192 -> codeBuilder -> codeBuilder.checkcast(description);
                case 193 -> codeBuilder -> codeBuilder.instanceOf(description);
                default -> throw new IllegalArgumentException("Unexpected opcode: " + opcode);
            };
            this.addInstruction(codeConsumer);
        }

        public void visitMultiANewArrayInsn(String descriptor, int numDimensions) {
            Consumer<CodeBuilder> codeConsumer = codeBuilder -> codeBuilder.multianewarray(ClassDesc.ofDescriptor(descriptor), numDimensions);
            this.addInstruction(codeConsumer);
        }

        public void visitLineNumber(int line, org.objectweb.asm.Label start) {
            this.lineNumbers.put(start, line);
        }

        public void visitLocalVariable(String name, String descriptor, String signature, org.objectweb.asm.Label start, org.objectweb.asm.Label end, int index) {
            this.undelayInstruction();
            this.codeConsumers.add(codeBuilder -> {
                if (descriptor != null) {
                    codeBuilder.localVariable(index, name, ClassDesc.ofDescriptor(descriptor), this.labels.computeIfAbsent(start, label -> codeBuilder.newLabel()), this.labels.computeIfAbsent(end, label -> codeBuilder.newLabel()));
                }
                if (signature != null) {
                    codeBuilder.localVariableType(index, name, Signature.parseFrom((String)signature), this.labels.computeIfAbsent(start, label -> codeBuilder.newLabel()), this.labels.computeIfAbsent(end, label -> codeBuilder.newLabel()));
                }
            });
        }

        public void visitTryCatchBlock(org.objectweb.asm.Label start, org.objectweb.asm.Label end, org.objectweb.asm.Label handler, String type) {
            this.undelayInstruction();
            ++this.catchCount;
            this.codeConsumers.add(codeBuilder -> {
                if (type == null) {
                    codeBuilder.exceptionCatchAll(this.labels.computeIfAbsent(start, label -> codeBuilder.newLabel()), this.labels.computeIfAbsent(end, label -> codeBuilder.newLabel()), this.labels.computeIfAbsent(handler, label -> codeBuilder.newLabel()));
                } else {
                    codeBuilder.exceptionCatch(this.labels.computeIfAbsent(start, label -> codeBuilder.newLabel()), this.labels.computeIfAbsent(end, label -> codeBuilder.newLabel()), this.labels.computeIfAbsent(handler, label -> codeBuilder.newLabel()), ClassDesc.ofInternalName(type));
                }
            });
        }

        public void visitMaxs(int maxStack, int maxLocals) {
        }

        public void visitEnd() {
            JdkClassWriter.this.classConsumers.add(classBuilder -> classBuilder.withMethod(this.name, MethodTypeDesc.ofDescriptor(this.descriptor), this.access & 0xFFFDFFFF, methodBuilder -> {
                ArrayList annotations;
                int index;
                if ((this.access & 0x20000) != 0) {
                    methodBuilder.with((ClassFileElement)DeprecatedAttribute.of());
                }
                if (this.signature != null) {
                    methodBuilder.with((ClassFileElement)SignatureAttribute.of((Utf8Entry)classBuilder.constantPool().utf8Entry(this.signature)));
                }
                if (this.exceptions != null) {
                    ClassDesc[] entries = new ClassDesc[this.exceptions.length];
                    for (index = 0; index < this.exceptions.length; ++index) {
                        entries[index] = ClassDesc.ofInternalName(this.exceptions[index]);
                    }
                    methodBuilder.with((ClassFileElement)ExceptionsAttribute.ofSymbols((ClassDesc[])entries));
                }
                for (MethodElement attribute : this.attributes) {
                    methodBuilder.with((ClassFileElement)attribute);
                }
                if (this.defaultValue != null) {
                    methodBuilder.with((ClassFileElement)AnnotationDefaultAttribute.of((AnnotationValue)this.defaultValue));
                }
                if (!this.visibleAnnotations.isEmpty()) {
                    methodBuilder.with((ClassFileElement)RuntimeVisibleAnnotationsAttribute.of(this.visibleAnnotations));
                }
                if (!this.invisibleAnnotations.isEmpty()) {
                    methodBuilder.with((ClassFileElement)RuntimeInvisibleAnnotationsAttribute.of(this.invisibleAnnotations));
                }
                if (!this.visibleTypeAnnotations.isEmpty()) {
                    methodBuilder.with((ClassFileElement)RuntimeVisibleTypeAnnotationsAttribute.of(this.visibleTypeAnnotations));
                }
                if (!this.invisibleTypeAnnotations.isEmpty()) {
                    methodBuilder.with((ClassFileElement)RuntimeInvisibleTypeAnnotationsAttribute.of(this.invisibleTypeAnnotations));
                }
                if (!this.methodParameters.isEmpty()) {
                    methodBuilder.with((ClassFileElement)MethodParametersAttribute.of(this.methodParameters));
                }
                if (!this.visibleParameterAnnotations.isEmpty()) {
                    annotations = new ArrayList();
                    for (index = 0; index < Math.max(this.visibleParameterAnnotationsCount, this.visibleParameterAnnotations.size()); ++index) {
                        annotations.add(this.visibleParameterAnnotations.getOrDefault(index, List.of()));
                    }
                    methodBuilder.with((ClassFileElement)RuntimeVisibleParameterAnnotationsAttribute.of(annotations));
                }
                if (!this.invisibleParameterAnnotations.isEmpty()) {
                    annotations = new ArrayList();
                    for (index = 0; index < Math.max(this.invisibleParameterAnnotationsCount, this.invisibleParameterAnnotations.size()); ++index) {
                        annotations.add(this.invisibleParameterAnnotations.getOrDefault(index, List.of()));
                    }
                    methodBuilder.with((ClassFileElement)RuntimeInvisibleParameterAnnotationsAttribute.of(annotations));
                }
                if (this.codeConsumers != null) {
                    this.undelayInstruction();
                    methodBuilder.withCode(codeBuilder -> {
                        this.codeConsumers.forEach(codeConsumer -> codeConsumer.accept(codeBuilder));
                        if (!this.stackMapFrames.isEmpty()) {
                            codeBuilder.with((ClassFileElement)StackMapTableAttribute.of(this.stackMapFrames));
                        }
                        for (CodeElement attribute : this.codeAttributes) {
                            codeBuilder.with((ClassFileElement)attribute);
                        }
                    });
                }
            }));
        }
    }
}

