/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.components.jms;

import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.Topic;
import javax.jms.TopicConnection;
import javax.jms.TopicPublisher;
import javax.jms.TopicSession;
import org.apache.avalon.framework.activity.Disposable;
import org.apache.avalon.framework.activity.Initializable;
import org.apache.avalon.framework.logger.AbstractLogEnabled;
import org.apache.avalon.framework.parameters.ParameterException;
import org.apache.avalon.framework.parameters.Parameterizable;
import org.apache.avalon.framework.parameters.Parameters;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.avalon.framework.service.Serviceable;
import org.apache.cocoon.components.jms.JMSConnectionEventListener;
import org.apache.cocoon.components.jms.JMSConnectionEventNotifier;
import org.apache.cocoon.components.jms.JMSConnectionManager;

public abstract class AbstractMessagePublisher
extends AbstractLogEnabled
implements Serviceable,
Parameterizable,
Initializable,
Disposable,
JMSConnectionEventListener {
    private static final String CONNECTION_PARAM = "connection";
    private static final String TOPIC_PARAM = "topic";
    private static final String PRIORITY_PARAM = "priority";
    private static final String TIME_TO_LIVE_PARAM = "time-to-live";
    private static final String PERSISTENT_DELIVERY_PARAM = "persistent-delivery";
    private static final int DEFAULT_PRIORITY = 4;
    private static final int DEFAULT_TIME_TO_LIVE = 10000;
    private ServiceManager m_manager;
    private JMSConnectionManager m_connectionManager;
    protected TopicSession m_session;
    protected TopicPublisher m_publisher;
    protected int m_mode;
    protected int m_priority;
    protected int m_timeToLive;
    protected String m_topicName;
    protected int m_acknowledgeMode;
    protected String m_connectionName;

    public void service(ServiceManager manager) throws ServiceException {
        this.m_manager = manager;
        this.m_connectionManager = (JMSConnectionManager)this.m_manager.lookup(JMSConnectionManager.ROLE);
    }

    public void parameterize(Parameters parameters) throws ParameterException {
        this.m_connectionName = parameters.getParameter(CONNECTION_PARAM);
        this.m_topicName = parameters.getParameter(TOPIC_PARAM);
        this.m_priority = parameters.getParameterAsInteger(PRIORITY_PARAM, 4);
        boolean persistent = parameters.getParameterAsBoolean(PERSISTENT_DELIVERY_PARAM, false);
        this.m_mode = persistent ? 2 : 1;
        this.m_timeToLive = parameters.getParameterAsInteger(TIME_TO_LIVE_PARAM, 10000);
    }

    public void initialize() throws Exception {
        if (this.m_connectionManager instanceof JMSConnectionEventNotifier) {
            ((JMSConnectionEventNotifier)((Object)this.m_connectionManager)).addConnectionListener(this.m_connectionName, this);
        }
        this.createSessionAndPublisher();
    }

    public void dispose() {
        this.closePublisherAndSession();
        if (this.m_manager != null && this.m_connectionManager != null) {
            this.m_manager.release((Object)this.m_connectionManager);
        }
    }

    public void onConnection(String name) {
        block3: {
            if (this.getLogger().isInfoEnabled()) {
                this.getLogger().info("Creating publisher because of reconnection");
            }
            try {
                this.createSessionAndPublisher();
            }
            catch (JMSException e) {
                if (!this.getLogger().isWarnEnabled()) break block3;
                this.getLogger().warn("Reinitialization after reconnection failed", (Throwable)e);
            }
        }
    }

    public void onDisconnection(String name) {
        if (this.getLogger().isInfoEnabled()) {
            this.getLogger().info("Closing subscriber because of disconnection");
        }
        this.closePublisherAndSession();
    }

    protected synchronized void publishMessage(Message message) throws JMSException {
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug("Publishing message '" + message + "'");
        }
        this.m_publisher.publish(message, this.m_mode, this.m_priority, (long)this.m_timeToLive);
    }

    private void createSessionAndPublisher() throws JMSException {
        this.m_acknowledgeMode = 3;
        TopicConnection connection = (TopicConnection)this.m_connectionManager.getConnection(this.m_connectionName);
        if (connection != null) {
            this.m_session = connection.createTopicSession(false, this.m_acknowledgeMode);
            Topic topic = this.m_session.createTopic(this.m_topicName);
            this.m_publisher = this.m_session.createPublisher(topic);
        } else if (this.getLogger().isWarnEnabled()) {
            this.getLogger().warn("Could not obtain JMS connection '" + this.m_connectionName + "'");
        }
    }

    private void closePublisherAndSession() {
        if (this.m_publisher != null) {
            try {
                this.m_publisher.close();
            }
            catch (JMSException e) {
                this.getLogger().error("Error closing publisher.", (Throwable)e);
            }
        }
        if (this.m_session != null) {
            try {
                this.m_session.close();
            }
            catch (JMSException e) {
                this.getLogger().warn("Error closing session.", (Throwable)e);
            }
        }
    }
}

