/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.components.jms;

import javax.jms.ExceptionListener;
import javax.jms.JMSException;
import javax.jms.MessageListener;
import javax.jms.Topic;
import javax.jms.TopicConnection;
import javax.jms.TopicSession;
import javax.jms.TopicSubscriber;
import org.apache.avalon.framework.activity.Disposable;
import org.apache.avalon.framework.activity.Initializable;
import org.apache.avalon.framework.logger.AbstractLogEnabled;
import org.apache.avalon.framework.parameters.ParameterException;
import org.apache.avalon.framework.parameters.Parameterizable;
import org.apache.avalon.framework.parameters.Parameters;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.avalon.framework.service.Serviceable;
import org.apache.cocoon.components.jms.JMSConnectionManager;

public abstract class AbstractMessageListener
extends AbstractLogEnabled
implements MessageListener,
ExceptionListener,
Serviceable,
Parameterizable,
Initializable,
Disposable {
    private static final String CONNECTION_PARAM = "connection";
    private static final String TOPIC_PARAM = "topic";
    private static final String SUBSCRIPTION_ID_PARAM = "subscription-id";
    private static final String MESSAGE_SELECTOR_PARAM = "message-selector";
    protected ServiceManager m_manager;
    private String m_connectionName;
    private String m_topicName;
    private String m_subscriptionId;
    private String m_selector;
    protected int m_acknowledgeMode;
    private JMSConnectionManager m_jmsConnectionManager;
    private TopicSession m_session;
    private TopicSubscriber m_subscriber;

    public void service(ServiceManager manager) throws ServiceException {
        this.m_manager = manager;
        this.m_jmsConnectionManager = (JMSConnectionManager)this.m_manager.lookup(JMSConnectionManager.ROLE);
    }

    public void parameterize(Parameters parameters) throws ParameterException {
        this.m_connectionName = parameters.getParameter(CONNECTION_PARAM);
        this.m_topicName = parameters.getParameter(TOPIC_PARAM);
        this.m_subscriptionId = parameters.getParameter(SUBSCRIPTION_ID_PARAM, null);
        this.m_selector = parameters.getParameter(MESSAGE_SELECTOR_PARAM, null);
    }

    public void initialize() throws Exception {
        this.m_acknowledgeMode = 3;
        TopicConnection connection = (TopicConnection)this.m_jmsConnectionManager.getConnection(this.m_connectionName);
        if (connection != null) {
            this.m_session = connection.createTopicSession(false, this.m_acknowledgeMode);
            Topic topic = this.m_session.createTopic(this.m_topicName);
            this.m_subscriber = this.m_subscriptionId != null ? this.m_session.createDurableSubscriber(topic, this.m_subscriptionId, this.m_selector, false) : this.m_session.createSubscriber(topic, this.m_selector, false);
            this.m_subscriber.setMessageListener((MessageListener)this);
        } else if (this.getLogger().isWarnEnabled()) {
            this.getLogger().warn("Could not obtain JMS connection '" + this.m_connectionName + "'");
        }
    }

    public void dispose() {
        if (this.m_subscriber != null) {
            try {
                this.m_subscriber.close();
            }
            catch (JMSException e) {
                this.getLogger().error("Error closing subscriber", (Throwable)e);
            }
        }
        if (this.m_session != null) {
            try {
                this.m_session.close();
            }
            catch (JMSException e) {
                this.getLogger().error("Error closing session", (Throwable)e);
            }
        }
        this.m_manager.release((Object)this.m_jmsConnectionManager);
    }

    public void onException(JMSException exception) {
        if (this.getLogger().isWarnEnabled()) {
            this.getLogger().warn("JMS problem detected", (Throwable)exception);
        }
    }
}

