/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.components.jms;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import javax.jms.Connection;
import javax.jms.ConnectionFactory;
import javax.jms.JMSException;
import javax.jms.QueueConnection;
import javax.jms.QueueConnectionFactory;
import javax.jms.TopicConnection;
import javax.jms.TopicConnectionFactory;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import org.apache.avalon.framework.activity.Disposable;
import org.apache.avalon.framework.activity.Initializable;
import org.apache.avalon.framework.activity.Startable;
import org.apache.avalon.framework.configuration.Configurable;
import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.configuration.ConfigurationException;
import org.apache.avalon.framework.logger.AbstractLogEnabled;
import org.apache.avalon.framework.parameters.ParameterException;
import org.apache.avalon.framework.parameters.Parameters;
import org.apache.avalon.framework.thread.ThreadSafe;
import org.apache.cocoon.components.jms.JMSConnectionManager;

public class JMSConnectionManagerImpl
extends AbstractLogEnabled
implements JMSConnectionManager,
Configurable,
Initializable,
Startable,
Disposable,
ThreadSafe {
    private static final int TOPIC_CONNECTION_TYPE = 1;
    private static final int QUEUE_CONNECTION_TYPE = 2;
    private static final int CONNECTION_TYPE = 3;
    private static final String CONNECTION_CONFIG = "connection";
    private static final String TOPIC_CONNECTION_CONFIG = "topic-connection";
    private static final String QUEUE_CONNECTION_CONFIG = "queue-connection";
    private static final String NAME_ATTR = "name";
    private static final String CONNECTION_FACTORY_PARAM = "connection-factory";
    private static final String USERNAME_PARAM = "username";
    private static final String PASSWORD_PARAM = "password";
    private static final String JNDI_PROPERTY_PREFIX = "java.naming.";
    private Map m_configurations;
    private Map m_connections;

    public void configure(Configuration configuration) throws ConfigurationException {
        this.m_configurations = new HashMap(configuration.getChildren().length);
        Configuration[] configurations = configuration.getChildren(CONNECTION_CONFIG);
        this.configureConnections(configurations, 3);
        configurations = configuration.getChildren(TOPIC_CONNECTION_CONFIG);
        this.configureConnections(configurations, 1);
        configurations = configuration.getChildren(QUEUE_CONNECTION_CONFIG);
        this.configureConnections(configurations, 2);
    }

    private void configureConnections(Configuration[] connections, int type) throws ConfigurationException {
        int i = 0;
        while (i < connections.length) {
            String name = connections[i].getAttribute(NAME_ATTR);
            if (this.m_configurations.containsKey(name)) {
                throw new ConfigurationException("Duplicate connection name '" + name + "'." + " Connection names must be unique.");
            }
            Parameters parameters = Parameters.fromConfiguration((Configuration)connections[i]);
            ConnectionConfiguration cc = new ConnectionConfiguration(name, parameters, type);
            this.m_configurations.put(name, cc);
            ++i;
        }
    }

    public void initialize() throws Exception {
        block7: {
            this.m_connections = new HashMap(this.m_configurations.size());
            Iterator iter = this.m_configurations.values().iterator();
            try {
                while (iter.hasNext()) {
                    ConnectionConfiguration cc = (ConnectionConfiguration)iter.next();
                    InitialContext context = this.createInitialContext(cc.getJNDIProperties());
                    ConnectionFactory factory = (ConnectionFactory)context.lookup(cc.getConnectionFactory());
                    Connection connection = this.createConnection(factory, cc);
                    this.m_connections.put(cc.getName(), connection);
                }
            }
            catch (NamingException e) {
                if (!this.getLogger().isWarnEnabled()) break block7;
                Throwable rootCause = e.getRootCause();
                if (rootCause != null) {
                    String message = e.getRootCause().getMessage();
                    if (rootCause instanceof ClassNotFoundException) {
                        String info = "WARN! *** JMS block is installed but jms client library not found. ***\n- For the jms block to work you must install and start a JMS server and place the client jar in WEB-INF/lib.";
                        if (message.indexOf("exolab") > 0) {
                            info = info + "\n- The default server, OpenJMS is configured in cocoon.xconf but is not bundled with Cocoon.";
                        }
                        System.err.println(info);
                        this.getLogger().warn(info, (Throwable)e);
                    } else {
                        System.out.println(message);
                        this.getLogger().warn("Cannot get Initial Context. Is the JNDI server reachable?", (Throwable)e);
                    }
                }
                this.getLogger().warn("Failed to initialize JMS.", (Throwable)e);
            }
        }
        this.m_configurations = null;
    }

    public void start() throws Exception {
        Iterator iter = this.m_connections.entrySet().iterator();
        while (iter.hasNext()) {
            Map.Entry entry = iter.next();
            if (this.getLogger().isDebugEnabled()) {
                this.getLogger().debug("Starting JMS connection " + entry.getKey());
            }
            Connection connection = (Connection)entry.getValue();
            connection.start();
        }
    }

    public void stop() throws Exception {
        Iterator iter = this.m_connections.entrySet().iterator();
        while (iter.hasNext()) {
            Map.Entry entry = iter.next();
            if (this.getLogger().isDebugEnabled()) {
                this.getLogger().debug("Stopping JMS connection " + entry.getKey());
            }
            try {
                Connection connection = (Connection)entry.getValue();
                connection.stop();
            }
            catch (JMSException e) {
                this.getLogger().error("Error stopping JMS connection " + entry.getKey(), (Throwable)e);
            }
        }
    }

    public void dispose() {
        Iterator iter = this.m_connections.entrySet().iterator();
        while (iter.hasNext()) {
            Map.Entry entry = iter.next();
            if (this.getLogger().isDebugEnabled()) {
                this.getLogger().debug("Closing JMS connection " + entry.getKey());
            }
            try {
                Connection connection = (Connection)entry.getValue();
                connection.close();
            }
            catch (JMSException e) {
                this.getLogger().error("Error closing JMS connection " + entry.getKey(), (Throwable)e);
            }
        }
    }

    public Connection getConnection(String name) {
        return (Connection)this.m_connections.get(name);
    }

    public TopicConnection getTopicConnection(String name) {
        return (TopicConnection)this.m_connections.get(name);
    }

    public QueueConnection getQueueConnection(String name) {
        return (QueueConnection)this.m_connections.get(name);
    }

    private InitialContext createInitialContext(Properties properties) throws NamingException {
        if (properties != null) {
            return new InitialContext(properties);
        }
        return new InitialContext();
    }

    private Connection createConnection(ConnectionFactory factory, ConnectionConfiguration cc) throws JMSException {
        if (cc.getUserName() != null) {
            switch (cc.getType()) {
                case 3: {
                    return factory.createConnection(cc.getUserName(), cc.getPassword());
                }
                case 1: {
                    TopicConnectionFactory topicFactory = (TopicConnectionFactory)factory;
                    return topicFactory.createTopicConnection(cc.getUserName(), cc.getPassword());
                }
                case 2: {
                    QueueConnectionFactory queueFactory = (QueueConnectionFactory)factory;
                    return queueFactory.createQueueConnection(cc.getUserName(), cc.getPassword());
                }
            }
        }
        switch (cc.getType()) {
            case 3: {
                return factory.createConnection();
            }
            case 1: {
                TopicConnectionFactory topicFactory = (TopicConnectionFactory)factory;
                return topicFactory.createTopicConnection();
            }
            case 2: {
                QueueConnectionFactory queueFactory = (QueueConnectionFactory)factory;
                return queueFactory.createQueueConnection();
            }
        }
        return null;
    }

    private static final class ConnectionConfiguration {
        private final String m_name;
        private final int m_type;
        private final String m_connectionFactory;
        private final String m_username;
        private final String m_password;
        private Properties m_jndiProperties;

        private ConnectionConfiguration(String name, Parameters parameters, int type) throws ConfigurationException {
            this.m_name = name;
            try {
                this.m_connectionFactory = parameters.getParameter(JMSConnectionManagerImpl.CONNECTION_FACTORY_PARAM);
                this.m_username = parameters.getParameter(JMSConnectionManagerImpl.USERNAME_PARAM, null);
                this.m_password = parameters.getParameter(JMSConnectionManagerImpl.PASSWORD_PARAM, null);
                String[] names = parameters.getNames();
                int i = 0;
                while (i < names.length) {
                    if (names[i].startsWith(JMSConnectionManagerImpl.JNDI_PROPERTY_PREFIX)) {
                        if (this.m_jndiProperties == null) {
                            this.m_jndiProperties = new Properties();
                        }
                        this.m_jndiProperties.put(names[i], parameters.getParameter(names[i]));
                    }
                    ++i;
                }
            }
            catch (ParameterException e) {
                throw new ConfigurationException(e.getLocalizedMessage());
            }
            this.m_type = type;
        }

        private String getName() {
            return this.m_name;
        }

        private int getType() {
            return this.m_type;
        }

        private Properties getJNDIProperties() {
            return this.m_jndiProperties;
        }

        private String getConnectionFactory() {
            return this.m_connectionFactory;
        }

        private String getUserName() {
            return this.m_username;
        }

        private String getPassword() {
            return this.m_password;
        }

        public int hashCode() {
            return this.m_name.hashCode();
        }
    }
}

