/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.components.jms;

import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.Topic;
import javax.jms.TopicConnection;
import javax.jms.TopicPublisher;
import javax.jms.TopicSession;
import org.apache.avalon.framework.activity.Disposable;
import org.apache.avalon.framework.activity.Initializable;
import org.apache.avalon.framework.logger.AbstractLogEnabled;
import org.apache.avalon.framework.parameters.ParameterException;
import org.apache.avalon.framework.parameters.Parameterizable;
import org.apache.avalon.framework.parameters.Parameters;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.avalon.framework.service.Serviceable;
import org.apache.cocoon.components.jms.JMSConnectionManager;

public abstract class AbstractMessagePublisher
extends AbstractLogEnabled
implements Serviceable,
Parameterizable,
Initializable,
Disposable {
    private static final String CONNECTION_PARAM = "connection";
    private static final String TOPIC_PARAM = "topic";
    private static final String PRIORITY_PARAM = "priority";
    private static final String TIME_TO_LIVE_PARAM = "time-to-live";
    private static final String PERSISTENT_DELIVERY_PARAM = "persistent-delivery";
    private static final int DEFAULT_PRIORITY = 4;
    private static final int DEFAULT_TIME_TO_LIVE = 10000;
    private ServiceManager m_manager;
    private JMSConnectionManager m_connectionManager;
    protected TopicSession m_session;
    protected TopicPublisher m_publisher;
    private int m_mode;
    private int m_priority;
    private int m_timeToLive;
    private String m_topicName;
    private int m_acknowledgeMode;
    private String m_connectionName;

    public void service(ServiceManager manager) throws ServiceException {
        this.m_manager = manager;
        this.m_connectionManager = (JMSConnectionManager)this.m_manager.lookup(JMSConnectionManager.ROLE);
    }

    public void parameterize(Parameters parameters) throws ParameterException {
        this.m_connectionName = parameters.getParameter(CONNECTION_PARAM);
        this.m_topicName = parameters.getParameter(TOPIC_PARAM);
        this.m_priority = parameters.getParameterAsInteger(PRIORITY_PARAM, 4);
        boolean persistent = parameters.getParameterAsBoolean(PERSISTENT_DELIVERY_PARAM, false);
        this.m_mode = persistent ? 2 : 1;
        this.m_timeToLive = parameters.getParameterAsInteger(TIME_TO_LIVE_PARAM, 10000);
    }

    public void initialize() throws Exception {
        this.m_acknowledgeMode = 3;
        TopicConnection connection = (TopicConnection)this.m_connectionManager.getConnection(this.m_connectionName);
        if (connection != null) {
            this.m_session = connection.createTopicSession(false, this.m_acknowledgeMode);
            Topic topic = this.m_session.createTopic(this.m_topicName);
            this.m_publisher = this.m_session.createPublisher(topic);
        } else if (this.getLogger().isWarnEnabled()) {
            this.getLogger().warn("Could not obtain JMS connection '" + this.m_connectionName + "'");
        }
    }

    public void dispose() {
        if (this.m_publisher != null) {
            try {
                this.m_publisher.close();
            }
            catch (JMSException e) {
                this.getLogger().error("Error closing publisher.", (Throwable)e);
            }
        }
        if (this.m_session != null) {
            try {
                this.m_session.close();
            }
            catch (JMSException e) {
                this.getLogger().warn("Error closing session.", (Throwable)e);
            }
        }
        if (this.m_manager != null && this.m_connectionManager != null) {
            this.m_manager.release((Object)this.m_connectionManager);
        }
    }

    protected synchronized void publishMessage(Message message) throws JMSException {
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug("Publishing message '" + message + "'");
        }
        this.m_publisher.publish(message, this.m_mode, this.m_priority, (long)this.m_timeToLive);
    }
}

