/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.components.jms;

import java.util.Hashtable;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import javax.jms.JMSException;
import javax.jms.MessageListener;
import javax.jms.Topic;
import javax.jms.TopicConnection;
import javax.jms.TopicConnectionFactory;
import javax.jms.TopicPublisher;
import javax.jms.TopicSession;
import javax.jms.TopicSubscriber;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import org.apache.avalon.framework.CascadingException;
import org.apache.avalon.framework.activity.Disposable;
import org.apache.avalon.framework.activity.Initializable;
import org.apache.avalon.framework.configuration.Configurable;
import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.configuration.ConfigurationException;
import org.apache.avalon.framework.logger.AbstractLogEnabled;
import org.apache.avalon.framework.parameters.Parameters;
import org.apache.avalon.framework.thread.ThreadSafe;
import org.apache.cocoon.components.jms.JMSConnection;

public class JMSConnectionImpl
extends AbstractLogEnabled
implements Configurable,
Disposable,
ThreadSafe,
Initializable,
JMSConnection {
    private boolean available = false;
    protected String topicFactoryName;
    protected String topicName;
    protected String ackModeName = "dups";
    protected String durableSubscriptionID;
    protected TopicConnection connection = null;
    protected TopicSession session = null;
    protected List subscribers = null;
    protected Topic topic = null;
    protected int ackMode = 3;
    protected Context context = null;
    protected TopicConnectionFactory topicConnectionFactory;
    private Parameters jndiParams;

    public void configure(Configuration conf) throws ConfigurationException {
        Parameters parameters = Parameters.fromConfiguration((Configuration)conf);
        this.jndiParams = Parameters.fromConfiguration((Configuration)conf.getChild("jndi-info"));
        this.topicFactoryName = parameters.getParameter("topic-factory", null);
        this.topicName = parameters.getParameter("topic", null);
        this.durableSubscriptionID = parameters.getParameter("durable-subscription-id", null);
        this.ackModeName = parameters.getParameter("ack-mode", this.ackModeName).toLowerCase();
        this.ackMode = 2;
        if (this.ackModeName.equals("auto")) {
            this.ackMode = 1;
        } else if (this.ackModeName.equals("dups")) {
            this.ackMode = 3;
        } else if (!this.ackModeName.equals("client")) {
            this.ackMode = -1;
        }
    }

    public void initialize() throws Exception {
        block9: {
            try {
                this.context = this.setupContext();
                this.setupConnection();
                this.setupSession();
                this.available = true;
            }
            catch (NamingException e) {
                if (this.getLogger().isWarnEnabled()) {
                    Throwable rootCause = e.getRootCause();
                    if (rootCause != null) {
                        String message = e.getRootCause().getMessage();
                        if (rootCause instanceof ClassNotFoundException) {
                            String info = "WARN! *** JMS block is installed but jms client library not found. ***\n- For the jms block to work you must install and start a JMS server and place the client jar in WEB-INF/lib.";
                            if (message.indexOf("exolab") > 0) {
                                info = info + "\n- The default server, OpenJMS is configured in cocoon.xconf but is not bundled with Cocoon.";
                            }
                            System.err.println(info);
                            this.getLogger().warn(info, (Throwable)e);
                        } else {
                            System.out.println(message);
                            this.getLogger().warn("Cannot get Initial Context. Is the JNDI server reachable?", (Throwable)e);
                        }
                    } else {
                        this.getLogger().warn("Failed to initialize JMS.", (Throwable)e);
                    }
                }
            }
            catch (JMSException e) {
                if (!this.getLogger().isWarnEnabled()) break block9;
                this.getLogger().warn("Failed to initialize JMS.", (Throwable)e);
            }
        }
    }

    public void dispose() {
        try {
            this.disconnect();
        }
        catch (JMSException e) {
        }
        catch (NamingException namingException) {
            // empty catch block
        }
    }

    public synchronized void registerListener(MessageListener listener, String selector) throws CascadingException, JMSException, NamingException {
        if (!this.available) {
            throw new CascadingException("Attempt to register Listener on unavailable JMS Connection");
        }
        TopicSubscriber subscriber = null;
        subscriber = this.durableSubscriptionID != null ? this.getSession().createDurableSubscriber(this.topic, this.durableSubscriptionID, selector, false) : this.getSession().createSubscriber(this.topic, selector, false);
        if (this.subscribers == null) {
            this.subscribers = new LinkedList();
        }
        this.subscribers.add(subscriber);
        subscriber.setMessageListener(listener);
    }

    public TopicPublisher getPublisher() throws JMSException, NamingException {
        TopicSession session = this.getSession();
        if (session != null) {
            return session.createPublisher(this.topic);
        }
        return null;
    }

    public TopicSession getSession() throws NamingException, JMSException {
        return this.session;
    }

    protected Context setupContext() throws NamingException {
        InitialContext ctx;
        String[] jndiKeys = this.jndiParams.getNames();
        if (jndiKeys.length > 0) {
            Hashtable<String, String> properties = null;
            properties = new Hashtable<String, String>();
            for (int i = 0; i < jndiKeys.length; ++i) {
                properties.put(jndiKeys[i], this.jndiParams.getParameter(jndiKeys[i], ""));
            }
            ctx = new InitialContext(properties);
        } else {
            ctx = new InitialContext();
        }
        return ctx;
    }

    private void setupConnection() throws NamingException, JMSException {
        if (this.context != null) {
            this.topicConnectionFactory = (TopicConnectionFactory)this.context.lookup(this.topicFactoryName);
            this.connection = this.topicConnectionFactory.createTopicConnection();
            this.connection.start();
        }
    }

    private void setupSession() throws JMSException {
        if (this.connection != null) {
            this.session = this.connection.createTopicSession(false, this.ackMode);
            this.topic = this.session.createTopic(this.topicName);
        }
    }

    private void disconnect() throws JMSException, NamingException {
        if (this.subscribers != null) {
            Iterator i = this.subscribers.iterator();
            while (i.hasNext()) {
                ((TopicSubscriber)i.next()).close();
            }
            this.subscribers.clear();
        }
        if (this.session != null) {
            this.session.close();
        }
        if (this.connection != null) {
            this.connection.close();
        }
    }
}

