/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.components.jms;

import java.util.Collections;
import java.util.Map;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.TextMessage;
import javax.jms.TopicPublisher;
import org.apache.avalon.framework.activity.Disposable;
import org.apache.avalon.framework.activity.Initializable;
import org.apache.avalon.framework.logger.AbstractLogEnabled;
import org.apache.avalon.framework.parameters.ParameterException;
import org.apache.avalon.framework.parameters.Parameterizable;
import org.apache.avalon.framework.parameters.Parameters;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.avalon.framework.service.Serviceable;
import org.apache.avalon.framework.thread.ThreadSafe;
import org.apache.cocoon.acting.Action;
import org.apache.cocoon.components.jms.JMSConnection;
import org.apache.cocoon.environment.Redirector;
import org.apache.cocoon.environment.SourceResolver;

public class JMSPublisherAction
extends AbstractLogEnabled
implements Action,
Serviceable,
Parameterizable,
ThreadSafe,
Initializable,
Disposable {
    protected ServiceManager manager = null;
    protected JMSConnection connection = null;
    protected TopicPublisher publisher = null;
    protected int mode = 1;
    protected boolean persistent = false;
    protected int priority = 4;
    protected int timeToLive = 10000;
    protected String connectionName = null;

    public Map act(Redirector redirector, SourceResolver resolver, Map objectModel, String source, Parameters parameters) throws Exception {
        Map result;
        block3: {
            result = null;
            TextMessage message = null;
            try {
                message = this.connection.getSession().createTextMessage(parameters.getParameter("event"));
                this.publisher.publish((Message)message, this.mode, this.priority, (long)this.timeToLive);
                result = Collections.EMPTY_MAP;
                if (this.getLogger().isInfoEnabled()) {
                    this.getLogger().info("Sent message '" + parameters.getParameter("event") + "'");
                }
            }
            catch (Exception e) {
                if (!this.getLogger().isWarnEnabled()) break block3;
                this.getLogger().warn("Could not deliver message.", (Throwable)e);
            }
        }
        return result;
    }

    public void service(ServiceManager manager) throws ServiceException {
        this.manager = manager;
    }

    public void parameterize(Parameters parameters) throws ParameterException {
        this.connectionName = parameters.getParameter("connection");
        this.priority = parameters.getParameterAsInteger("priority", this.priority);
        this.persistent = parameters.getParameterAsBoolean("persistent-delivery", this.persistent);
        this.mode = this.persistent ? 2 : 1;
        this.timeToLive = parameters.getParameterAsInteger("time-to-live", this.timeToLive);
    }

    public void initialize() throws Exception {
        this.connection = (JMSConnection)this.manager.lookup(JMSConnection.ROLE + "/" + this.connectionName);
        this.publisher = this.connection.getPublisher();
    }

    public void dispose() {
        block4: {
            if (this.publisher != null) {
                try {
                    this.publisher.close();
                }
                catch (JMSException e) {
                    if (!this.getLogger().isWarnEnabled()) break block4;
                    this.getLogger().warn("Could not close publisher.", (Throwable)e);
                }
            }
        }
        if (this.connection != null && this.manager != null) {
            this.manager.release((Object)this.connection);
            this.connection = null;
        }
    }
}

