/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.components.jms;

import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageListener;
import javax.naming.NamingException;
import org.apache.avalon.framework.CascadingException;
import org.apache.avalon.framework.activity.Disposable;
import org.apache.avalon.framework.activity.Initializable;
import org.apache.avalon.framework.logger.AbstractLogEnabled;
import org.apache.avalon.framework.parameters.ParameterException;
import org.apache.avalon.framework.parameters.Parameterizable;
import org.apache.avalon.framework.parameters.Parameters;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.avalon.framework.service.Serviceable;
import org.apache.avalon.framework.thread.ThreadSafe;
import org.apache.cocoon.caching.EventAware;
import org.apache.cocoon.caching.validity.Event;
import org.apache.cocoon.caching.validity.NamedEvent;
import org.apache.cocoon.components.jms.JMSConnection;

public class JMSEventListener
extends AbstractLogEnabled
implements Serviceable,
Parameterizable,
MessageListener,
Initializable,
Disposable,
ThreadSafe {
    protected String selector = "";
    protected ServiceManager manager;
    protected String serviceName = null;
    protected EventAware service = null;
    protected String connectionName = null;
    protected JMSConnection connection = null;

    public void service(ServiceManager manager) throws ServiceException {
        this.manager = manager;
    }

    public void parameterize(Parameters parameters) throws ParameterException {
        this.connectionName = parameters.getParameter("connection");
        this.serviceName = parameters.getParameter("component");
        this.selector = parameters.getParameter("message-selector", this.selector);
    }

    public void initialize() {
        block8: {
            try {
                this.connection = (JMSConnection)this.manager.lookup(JMSConnection.ROLE + "/" + this.connectionName);
                this.connection.registerListener(this, this.selector);
            }
            catch (ServiceException e) {
                if (this.getLogger().isWarnEnabled()) {
                    this.getLogger().warn("Could not obtain JMSConnection");
                }
            }
            catch (JMSException e) {
                if (this.getLogger().isWarnEnabled()) {
                    this.getLogger().warn("Could not obtain JMSConnection");
                }
            }
            catch (NamingException e) {
                if (this.getLogger().isWarnEnabled()) {
                    this.getLogger().warn("Could not obtain JMSConnection");
                }
            }
            catch (CascadingException e) {
                if (!this.getLogger().isWarnEnabled()) break block8;
                this.getLogger().warn("Could not obtain JMSConnection");
            }
        }
    }

    public void dispose() {
        if (this.manager != null) {
            this.manager.release((Object)this.connection);
            this.manager.release((Object)this.service);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public synchronized void onMessage(Message message) {
        EventAware service = this.service;
        try {
            try {
                if (service == null) {
                    service = (EventAware)this.manager.lookup(this.serviceName);
                }
                Event event = this.convertMessage(message);
                if (this.getLogger().isInfoEnabled()) {
                    this.getLogger().info("Notifying " + this.serviceName + " of " + event);
                }
                service.processEvent(event);
            }
            catch (ServiceException e) {
                if (this.getLogger().isErrorEnabled()) {
                    this.getLogger().error("Could not obtain " + this.serviceName + " from component manager.", (Throwable)e);
                }
                Object var5_6 = null;
                if (service instanceof ThreadSafe) {
                    this.service = service;
                    return;
                }
                this.manager.release((Object)service);
                return;
            }
            Object var5_5 = null;
        }
        catch (Throwable throwable) {
            Object var5_7 = null;
            if (service instanceof ThreadSafe) {
                this.service = service;
                throw throwable;
            }
            this.manager.release((Object)service);
            throw throwable;
        }
        if (service instanceof ThreadSafe) {
            this.service = service;
            return;
        }
        this.manager.release((Object)service);
    }

    protected Event convertMessage(Message message) {
        String name = message.toString();
        int pos = name.indexOf(124);
        return new NamedEvent(name.substring(pos + 1));
    }
}

