/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.components.jms;

import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import javax.jms.Connection;
import javax.jms.ConnectionFactory;
import javax.jms.ExceptionListener;
import javax.jms.JMSException;
import javax.jms.QueueConnection;
import javax.jms.QueueConnectionFactory;
import javax.jms.TopicConnection;
import javax.jms.TopicConnectionFactory;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import org.apache.avalon.framework.CascadingException;
import org.apache.avalon.framework.activity.Disposable;
import org.apache.avalon.framework.activity.Initializable;
import org.apache.avalon.framework.activity.Startable;
import org.apache.avalon.framework.configuration.Configurable;
import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.configuration.ConfigurationException;
import org.apache.avalon.framework.logger.AbstractLogEnabled;
import org.apache.avalon.framework.logger.Logger;
import org.apache.avalon.framework.parameters.ParameterException;
import org.apache.avalon.framework.parameters.Parameters;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.avalon.framework.service.Serviceable;
import org.apache.avalon.framework.thread.ThreadSafe;
import org.apache.cocoon.components.cron.CronJob;
import org.apache.cocoon.components.cron.JobScheduler;
import org.apache.cocoon.components.jms.JMSConnectionEventListener;
import org.apache.cocoon.components.jms.JMSConnectionEventNotifier;
import org.apache.cocoon.components.jms.JMSConnectionManager;

public class JMSConnectionManagerImpl
extends AbstractLogEnabled
implements JMSConnectionManager,
Serviceable,
Configurable,
Initializable,
Startable,
Disposable,
ThreadSafe,
JMSConnectionEventNotifier {
    private static final int TOPIC_CONNECTION_TYPE = 1;
    private static final int QUEUE_CONNECTION_TYPE = 2;
    private static final int CONNECTION_TYPE = 3;
    private static final String CONNECTION_CONFIG = "connection";
    private static final String TOPIC_CONNECTION_CONFIG = "topic-connection";
    private static final String QUEUE_CONNECTION_CONFIG = "queue-connection";
    private static final String NAME_ATTR = "name";
    private static final String CONNECTION_FACTORY_PARAM = "connection-factory";
    private static final String USERNAME_PARAM = "username";
    private static final String PASSWORD_PARAM = "password";
    private static final String AUTO_RECONNECT_PARAM = "auto-reconnect";
    private static final String AUTO_RECONNECT_DELAY_PARAM = "auto-reconnect-delay";
    private static final int DEFAULT_AUTO_RECONNECT_DELAY = 1000;
    private static final String JNDI_PROPERTY_PREFIX = "java.naming.";
    private ServiceManager m_serviceManager;
    private Map m_configurations;
    private Map m_connections;
    private Map m_listeners;

    public void service(ServiceManager manager) {
        this.m_serviceManager = manager;
    }

    public void configure(Configuration configuration) throws ConfigurationException {
        this.m_configurations = new HashMap(configuration.getChildren().length);
        Configuration[] configurations = configuration.getChildren(CONNECTION_CONFIG);
        this.configureConnections(configurations, 3);
        configurations = configuration.getChildren(TOPIC_CONNECTION_CONFIG);
        this.configureConnections(configurations, 1);
        configurations = configuration.getChildren(QUEUE_CONNECTION_CONFIG);
        this.configureConnections(configurations, 2);
    }

    private void configureConnections(Configuration[] connections, int type) throws ConfigurationException {
        for (int i = 0; i < connections.length; ++i) {
            String name = connections[i].getAttribute(NAME_ATTR);
            if (this.m_configurations.containsKey(name)) {
                throw new ConfigurationException("Duplicate connection name '" + name + "'." + " Connection names must be unique.");
            }
            Parameters parameters = Parameters.fromConfiguration((Configuration)connections[i]);
            ConnectionConfiguration cc = new ConnectionConfiguration(name, parameters, type);
            this.m_configurations.put(name, cc);
        }
    }

    public void initialize() throws Exception {
        this.m_listeners = new HashMap();
        this.m_connections = new HashMap(this.m_configurations.size());
        Iterator iter = this.m_configurations.values().iterator();
        while (iter.hasNext()) {
            ConnectionConfiguration cc = (ConnectionConfiguration)iter.next();
            try {
                Connection connection = this.createConnection(cc);
                this.m_connections.put(cc.getName(), connection);
            }
            catch (NamingException namingException) {}
        }
        this.m_configurations = null;
    }

    public void start() throws Exception {
        Iterator iter = this.m_connections.entrySet().iterator();
        while (iter.hasNext()) {
            Map.Entry entry = iter.next();
            if (this.getLogger().isDebugEnabled()) {
                this.getLogger().debug("Starting JMS connection " + entry.getKey());
            }
            Connection connection = (Connection)entry.getValue();
            connection.start();
        }
    }

    public void stop() throws Exception {
        Iterator iter = this.m_connections.entrySet().iterator();
        while (iter.hasNext()) {
            Map.Entry entry = iter.next();
            this.stopConnection((String)entry.getKey(), (Connection)entry.getValue());
        }
    }

    void stopConnection(String name, Connection connection) {
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug("Stopping JMS connection " + name);
        }
        try {
            connection.stop();
        }
        catch (JMSException jMSException) {
            // empty catch block
        }
    }

    public void dispose() {
        Iterator iter = this.m_connections.entrySet().iterator();
        while (iter.hasNext()) {
            Map.Entry entry = iter.next();
            if (this.getLogger().isDebugEnabled()) {
                this.getLogger().debug("Closing JMS connection " + entry.getKey());
            }
            try {
                Connection connection = (Connection)entry.getValue();
                connection.close();
            }
            catch (JMSException e) {
                this.getLogger().error("Error closing JMS connection " + entry.getKey(), (Throwable)e);
            }
        }
    }

    public synchronized Connection getConnection(String name) {
        return (Connection)this.m_connections.get(name);
    }

    public synchronized TopicConnection getTopicConnection(String name) {
        return (TopicConnection)this.m_connections.get(name);
    }

    public synchronized QueueConnection getQueueConnection(String name) {
        return (QueueConnection)this.m_connections.get(name);
    }

    public synchronized void addConnectionListener(String name, JMSConnectionEventListener listener) {
        HashSet<JMSConnectionEventListener> connectionListeners = (HashSet<JMSConnectionEventListener>)this.m_listeners.get(name);
        if (connectionListeners == null) {
            connectionListeners = new HashSet<JMSConnectionEventListener>();
            this.m_listeners.put(name, connectionListeners);
        }
        connectionListeners.add(listener);
    }

    public synchronized void removeConnectionListener(String name, JMSConnectionEventListener listener) {
        Set connectionListeners = (Set)this.m_listeners.get(name);
        if (connectionListeners != null) {
            connectionListeners.remove(listener);
        }
    }

    Connection createConnection(ConnectionConfiguration cc) throws NamingException, JMSException {
        try {
            InitialContext context = this.createInitialContext(cc.getJNDIProperties());
            ConnectionFactory factory = (ConnectionFactory)context.lookup(cc.getConnectionFactory());
            Connection connection = this.createConnection(factory, cc);
            if (cc.isAutoReconnect()) {
                connection.setExceptionListener((ExceptionListener)new ReconnectionListener(this, cc));
            }
            return connection;
        }
        catch (NamingException e) {
            if (this.getLogger().isWarnEnabled()) {
                Throwable rootCause = e.getRootCause();
                if (rootCause != null) {
                    String message = e.getRootCause().getMessage();
                    if (rootCause instanceof ClassNotFoundException) {
                        String info = "WARN! *** JMS block is installed but jms client library not found. ***\n- For the jms block to work you must install and start a JMS server and place the client jar in WEB-INF/lib.";
                        if (message.indexOf("exolab") > 0) {
                            info = info + "\n- The default server, OpenJMS is configured in cocoon.xconf but is not bundled with Cocoon.";
                        }
                        System.err.println(info);
                        this.getLogger().warn(info, (Throwable)e);
                    } else {
                        System.out.println(message);
                        this.getLogger().warn("Cannot get Initial Context. Is the JNDI server reachable?", (Throwable)e);
                    }
                } else {
                    this.getLogger().warn("Failed to initialize JMS.", (Throwable)e);
                }
            }
            throw e;
        }
    }

    private Connection createConnection(ConnectionFactory factory, ConnectionConfiguration cc) throws JMSException {
        if (cc.getUserName() != null) {
            switch (cc.getType()) {
                case 3: {
                    return factory.createConnection(cc.getUserName(), cc.getPassword());
                }
                case 1: {
                    TopicConnectionFactory topicFactory = (TopicConnectionFactory)factory;
                    return topicFactory.createTopicConnection(cc.getUserName(), cc.getPassword());
                }
                case 2: {
                    QueueConnectionFactory queueFactory = (QueueConnectionFactory)factory;
                    return queueFactory.createQueueConnection(cc.getUserName(), cc.getPassword());
                }
            }
        }
        switch (cc.getType()) {
            case 3: {
                return factory.createConnection();
            }
            case 1: {
                TopicConnectionFactory topicFactory = (TopicConnectionFactory)factory;
                return topicFactory.createTopicConnection();
            }
            case 2: {
                QueueConnectionFactory queueFactory = (QueueConnectionFactory)factory;
                return queueFactory.createQueueConnection();
            }
        }
        return null;
    }

    private InitialContext createInitialContext(Properties properties) throws NamingException {
        if (properties != null) {
            return new InitialContext(properties);
        }
        return new InitialContext();
    }

    synchronized void removeConnection(String name) {
        this.notifyListenersOfDisconnection(name);
        Connection connection = (Connection)this.m_connections.remove(name);
        this.stopConnection(name, connection);
    }

    synchronized void addConnection(String name, Connection connection) {
        this.m_connections.put(name, connection);
        this.notifyListenersOfConnection(name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    void scheduleReconnectionJob(ConnectionConfiguration configuration) {
        if (this.getLogger().isInfoEnabled()) {
            this.getLogger().info("Scheduling JMS reconnection job for: " + configuration.getName());
        }
        JobScheduler scheduler = null;
        try {
            try {
                scheduler = (JobScheduler)this.m_serviceManager.lookup(JobScheduler.ROLE);
                Date executionTime = new Date(System.currentTimeMillis() + (long)configuration.getAutoReconnectDelay());
                ReconnectionJob job = new ReconnectionJob(this, configuration);
                scheduler.fireJobAt(executionTime, "reconnect_" + configuration.getName(), (Object)job);
            }
            catch (ServiceException e) {
                if (this.getLogger().isWarnEnabled()) {
                    this.getLogger().warn("Cannot obtain scheduler.", (Throwable)e);
                }
                Object var6_8 = null;
                if (scheduler == null) return;
                this.m_serviceManager.release((Object)scheduler);
                return;
            }
            catch (CascadingException e) {
                if (this.getLogger().isWarnEnabled()) {
                    this.getLogger().warn("Unable to schedule reconnection job.", (Throwable)e);
                }
                Object var6_9 = null;
                if (scheduler == null) return;
                this.m_serviceManager.release((Object)scheduler);
                return;
            }
            Object var6_7 = null;
            if (scheduler == null) return;
        }
        catch (Throwable throwable) {
            Object var6_10 = null;
            if (scheduler == null) throw throwable;
            this.m_serviceManager.release((Object)scheduler);
            throw throwable;
        }
        this.m_serviceManager.release((Object)scheduler);
    }

    private void notifyListenersOfConnection(String name) {
        Set connectionListeners = (Set)this.m_listeners.get(name);
        if (connectionListeners != null) {
            Iterator listenersIterator = connectionListeners.iterator();
            while (listenersIterator.hasNext()) {
                JMSConnectionEventListener listener = (JMSConnectionEventListener)listenersIterator.next();
                listener.onConnection(name);
            }
        }
    }

    private void notifyListenersOfDisconnection(String name) {
        Set connectionListeners = (Set)this.m_listeners.get(name);
        if (connectionListeners != null) {
            Iterator listenersIterator = connectionListeners.iterator();
            while (listenersIterator.hasNext()) {
                JMSConnectionEventListener listener = (JMSConnectionEventListener)listenersIterator.next();
                listener.onDisconnection(name);
            }
        }
    }

    static final class ReconnectionJob
    implements CronJob {
        private final JMSConnectionManagerImpl m_manager;
        private final ConnectionConfiguration m_configuration;

        ReconnectionJob(JMSConnectionManagerImpl manager, ConnectionConfiguration configuration) {
            this.m_manager = manager;
            this.m_configuration = configuration;
        }

        public void execute(String jobname) {
            Logger logger = this.m_manager.getLogger();
            if (logger.isInfoEnabled()) {
                logger.info("Reconnecting JMS connection: " + this.m_configuration.getName());
            }
            try {
                Connection connection = this.m_manager.createConnection(this.m_configuration);
                this.m_manager.addConnection(this.m_configuration.getName(), connection);
                if (logger.isInfoEnabled()) {
                    logger.info("Successfully reconnected JMS connection: " + this.m_configuration.getName());
                }
            }
            catch (NamingException e) {
                if (logger.isWarnEnabled()) {
                    logger.warn("Failed to reconnect.", (Throwable)e);
                }
                this.m_manager.scheduleReconnectionJob(this.m_configuration);
            }
            catch (JMSException e) {
                if (logger.isWarnEnabled()) {
                    logger.warn("Failed to reconnect.", (Throwable)e);
                }
                this.m_manager.scheduleReconnectionJob(this.m_configuration);
            }
        }
    }

    static final class ReconnectionListener
    implements ExceptionListener {
        private final JMSConnectionManagerImpl m_manager;
        private final ConnectionConfiguration m_configuration;

        ReconnectionListener(JMSConnectionManagerImpl manager, ConnectionConfiguration configuration) {
            this.m_manager = manager;
            this.m_configuration = configuration;
        }

        public void onException(JMSException exception) {
            this.m_manager.removeConnection(this.m_configuration.getName());
            this.m_manager.scheduleReconnectionJob(this.m_configuration);
        }
    }

    static final class ConnectionConfiguration {
        private final String m_name;
        private final int m_type;
        private final String m_connectionFactory;
        private final String m_username;
        private final String m_password;
        private final boolean m_autoReconnect;
        private final int m_autoReconnectDelay;
        private Properties m_jndiProperties = new Properties();

        ConnectionConfiguration(String name, Parameters parameters, int type) throws ConfigurationException {
            this.m_name = name;
            try {
                this.m_connectionFactory = parameters.getParameter(JMSConnectionManagerImpl.CONNECTION_FACTORY_PARAM);
                this.m_username = parameters.getParameter(JMSConnectionManagerImpl.USERNAME_PARAM, null);
                this.m_password = parameters.getParameter(JMSConnectionManagerImpl.PASSWORD_PARAM, null);
                this.m_autoReconnect = parameters.getParameterAsBoolean(JMSConnectionManagerImpl.AUTO_RECONNECT_PARAM, false);
                this.m_autoReconnectDelay = parameters.getParameterAsInteger(JMSConnectionManagerImpl.AUTO_RECONNECT_DELAY_PARAM, 1000);
                String[] names = parameters.getNames();
                for (int i = 0; i < names.length; ++i) {
                    if (!names[i].startsWith(JMSConnectionManagerImpl.JNDI_PROPERTY_PREFIX)) continue;
                    this.m_jndiProperties.put(names[i], parameters.getParameter(names[i]));
                }
            }
            catch (ParameterException e) {
                throw new ConfigurationException(e.getLocalizedMessage());
            }
            this.m_type = type;
        }

        String getName() {
            return this.m_name;
        }

        int getType() {
            return this.m_type;
        }

        Properties getJNDIProperties() {
            return this.m_jndiProperties;
        }

        String getConnectionFactory() {
            return this.m_connectionFactory;
        }

        String getUserName() {
            return this.m_username;
        }

        String getPassword() {
            return this.m_password;
        }

        boolean isAutoReconnect() {
            return this.m_autoReconnect;
        }

        int getAutoReconnectDelay() {
            return this.m_autoReconnectDelay;
        }

        public int hashCode() {
            return this.m_name.hashCode();
        }
    }
}

