/*
 * Decompiled with CFR 0.152.
 */
package co.uzzu.dotenv.gradle;

import co.uzzu.dotenv.DotEnvParser;
import co.uzzu.dotenv.gradle.Configuration;
import co.uzzu.dotenv.gradle.ConfigurationResolver;
import co.uzzu.dotenv.gradle.DefaultConfiguration;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.io.FilesKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import org.gradle.api.Project;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u001c\u0010\n\u001a\u0010\u0012\u0004\u0012\u00020\b\u0012\u0006\u0012\u0004\u0018\u00010\b0\u00072\u0006\u0010\u0002\u001a\u00020\u0003J\u001a\u0010\u000b\u001a\u0010\u0012\u0004\u0012\u00020\b\u0012\u0006\u0012\u0004\u0018\u00010\b0\u0007*\u00020\u0003H\u0002J \u0010\f\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\b0\u0007*\u00020\u00032\u0006\u0010\r\u001a\u00020\u000eH\u0002J \u0010\u000f\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\b0\u0007*\u00020\u00032\u0006\u0010\r\u001a\u00020\u000eH\u0002J\u0014\u0010\u0010\u001a\u00020\b*\u00020\u00032\u0006\u0010\u0011\u001a\u00020\bH\u0002R(\u0010\u0005\u001a\u001c\u0012\u0004\u0012\u00020\u0003\u0012\u0012\u0012\u0010\u0012\u0004\u0012\u00020\b\u0012\u0006\u0012\u0004\u0018\u00010\b0\u00070\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lco/uzzu/dotenv/gradle/DotEnvResolver;", "", "project", "Lorg/gradle/api/Project;", "(Lorg/gradle/api/Project;)V", "dotenvCache", "", "", "", "rootProject", "resolve", "dotenv", "dotenvSource", "config", "Lco/uzzu/dotenv/gradle/Configuration;", "dotenvTemplate", "readText", "filename", "plugin"})
@SourceDebugExtension(value={"SMAP\nDotEnvResolver.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DotEnvResolver.kt\nco/uzzu/dotenv/gradle/DotEnvResolver\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,100:1\n1789#2,2:101\n1791#2:104\n1271#2,2:105\n1285#2,4:107\n1#3:103\n*S KotlinDebug\n*F\n+ 1 DotEnvResolver.kt\nco/uzzu/dotenv/gradle/DotEnvResolver\n*L\n33#1:101,2\n33#1:104\n45#1:105,2\n45#1:107,4\n*E\n"})
public final class DotEnvResolver {
    @NotNull
    private final Project rootProject;
    @NotNull
    private final Map<Project, Map<String, String>> dotenvCache;

    public DotEnvResolver(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        this.dotenvCache = new LinkedHashMap();
        Project project2 = project.getRootProject();
        Intrinsics.checkNotNullExpressionValue((Object)project2, (String)"getRootProject(...)");
        this.rootProject = project2;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final Map<String, String> resolve(@NotNull Project project) {
        void $this$fold$iv;
        void initial$iv;
        Object dotenv;
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        List dotenvList = new ArrayList();
        Project current = project;
        while (true) {
            dotenv = this.dotenv(current);
            dotenvList.add(0, dotenv);
            if (Intrinsics.areEqual((Object)current, (Object)this.rootProject) || current.getParent() == null) break;
            if (current.getParent() != null) continue;
            String string = "Required value was null.";
            throw new IllegalStateException(string.toString());
        }
        dotenv = dotenvList;
        Map map = new LinkedHashMap();
        boolean $i$f$fold = false;
        void accumulator$iv = initial$iv;
        for (Object element$iv : $this$fold$iv) {
            void dotenv2;
            void var13_14;
            Map map2 = (Map)element$iv;
            void destination = accumulator$iv;
            boolean bl = false;
            void $this$resolve_u24lambda_u241_u24lambda_u240 = var13_14 = destination;
            boolean bl2 = false;
            $this$resolve_u24lambda_u241_u24lambda_u240.putAll(dotenv2);
            accumulator$iv = var13_14;
        }
        return MapsKt.toMap((Map)accumulator$iv);
    }

    /*
     * WARNING - void declaration
     */
    private final Map<String, String> dotenv(Project $this$dotenv) {
        if (!Intrinsics.areEqual((Object)$this$dotenv.getRootProject(), (Object)this.rootProject)) {
            String string = "Failed requirement.";
            throw new IllegalArgumentException(string.toString());
        }
        Configuration config = new ConfigurationResolver($this$dotenv).resolve();
        if (this.dotenvCache.get($this$dotenv) == null) {
            void $this$associateWith$iv;
            Map<String, String> dotenvTemplate = this.dotenvTemplate($this$dotenv, config);
            Map<String, String> dotenvSource = this.dotenvSource($this$dotenv, config);
            Object object = CollectionsKt.union((Iterable)dotenvTemplate.keySet(), (Iterable)dotenvSource.keySet());
            boolean $i$f$associateWith = false;
            LinkedHashMap result$iv = new LinkedHashMap(RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associateWith$iv, (int)10)), (int)16));
            void $this$associateWithTo$iv$iv = $this$associateWith$iv;
            boolean $i$f$associateWithTo = false;
            for (Object element$iv$iv : $this$associateWithTo$iv$iv) {
                void it;
                String string = (String)element$iv$iv;
                Object t = element$iv$iv;
                Map map = result$iv;
                boolean bl = false;
                String string2 = dotenvSource.get(it);
                map.put(t, string2);
            }
            Map variables = result$iv;
            object = this.dotenvCache;
            Project project = $this$dotenv.getProject();
            Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
            object.put(project, variables);
        }
        Map<String, String> map = this.dotenvCache.get($this$dotenv.getProject());
        if (map == null) {
            String string = "Required value was null.";
            throw new IllegalStateException(string.toString());
        }
        return map;
    }

    private final Map<String, String> dotenvTemplate(Project $this$dotenvTemplate, Configuration config) {
        File templateFile;
        String it = config.getTemplateFilename();
        boolean bl = false;
        if (!(Intrinsics.areEqual((Object)it, (Object)DefaultConfiguration.INSTANCE.getTemplateFilename()) || (templateFile = $this$dotenvTemplate.file((Object)it)).exists() && templateFile.canRead())) {
            StringBuilder stringBuilder;
            StringBuilder $this$dotenvTemplate_u24lambda_u244_u24lambda_u243 = stringBuilder = new StringBuilder();
            boolean bl2 = false;
            $this$dotenvTemplate_u24lambda_u244_u24lambda_u243.append("Could not read the dotenv template file specified in the gradle.properties.");
            $this$dotenvTemplate_u24lambda_u244_u24lambda_u243.append(" dotenv.template.filename: " + it + ',');
            $this$dotenvTemplate_u24lambda_u244_u24lambda_u243.append(" path: " + templateFile.getAbsolutePath());
            String string = stringBuilder.toString();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
            String string2 = string;
            throw new IOException(string2);
        }
        String filename = it;
        String string = this.readText($this$dotenvTemplate, filename);
        DotEnvParser dotEnvParser = DotEnvParser.INSTANCE;
        String p0 = string;
        boolean bl3 = false;
        return dotEnvParser.parse(p0);
    }

    private final Map<String, String> dotenvSource(Project $this$dotenvSource, Configuration config) {
        File envFile;
        String it = config.getFilename();
        boolean bl = false;
        if (!(Intrinsics.areEqual((Object)it, (Object)DefaultConfiguration.INSTANCE.getFilename()) || (envFile = $this$dotenvSource.file((Object)it)).exists() && envFile.canRead())) {
            StringBuilder stringBuilder;
            StringBuilder $this$dotenvSource_u24lambda_u246_u24lambda_u245 = stringBuilder = new StringBuilder();
            boolean bl2 = false;
            $this$dotenvSource_u24lambda_u246_u24lambda_u245.append("Could not read the dotenv file specified in the gradle.properties.");
            $this$dotenvSource_u24lambda_u246_u24lambda_u245.append(" dotenv.filename: " + it + ',');
            $this$dotenvSource_u24lambda_u246_u24lambda_u245.append(" path: " + envFile.getAbsolutePath());
            String string = stringBuilder.toString();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
            String string2 = string;
            throw new IOException(string2);
        }
        String envFilename = it;
        String string = this.readText($this$dotenvSource, envFilename);
        DotEnvParser dotEnvParser = DotEnvParser.INSTANCE;
        String p0 = string;
        boolean bl3 = false;
        return dotEnvParser.parse(p0);
    }

    private final String readText(Project $this$readText, String filename) {
        String string;
        File file = $this$readText.file((Object)filename);
        if (file.exists()) {
            Intrinsics.checkNotNull((Object)file);
            Charset charset = Charset.forName("UTF-8");
            Intrinsics.checkNotNullExpressionValue((Object)charset, (String)"forName(...)");
            string = FilesKt.readText((File)file, (Charset)charset);
        } else {
            string = "";
        }
        return string;
    }
}

