/*
 * Decompiled with CFR 0.152.
 */
package co.unruly.matchers;

import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import java.util.PrimitiveIterator;
import java.util.stream.BaseStream;
import java.util.stream.DoubleStream;
import java.util.stream.IntStream;
import java.util.stream.LongStream;
import java.util.stream.Stream;
import org.hamcrest.Description;
import org.hamcrest.Matcher;
import org.hamcrest.TypeSafeMatcher;

public class StreamMatchers {
    public static <T, S extends BaseStream<T, S>> Matcher<BaseStream<T, S>> empty() {
        return new TypeSafeMatcher<BaseStream<T, S>>(){
            private Iterator<T> actualIterator;

            protected boolean matchesSafely(BaseStream<T, S> actual) {
                this.actualIterator = actual.iterator();
                return !this.actualIterator.hasNext();
            }

            public void describeTo(Description description) {
                description.appendText("An empty Stream");
            }

            protected void describeMismatchSafely(BaseStream<T, S> item, Description description) {
                description.appendText("A non empty Stream starting with ").appendValue(this.actualIterator.next());
            }
        };
    }

    public static <T, S extends BaseStream<T, S>> Matcher<BaseStream<T, S>> equalTo(final BaseStream<T, S> expected) {
        return new BaseStreamMatcher<T, BaseStream<T, S>>(){

            protected boolean matchesSafely(BaseStream<T, S> actual) {
                return this.remainingItemsEqual(expected.iterator(), actual.iterator());
            }
        };
    }

    public static <T> Matcher<Stream<T>> startsWith(final Stream<T> expected, final long limit) {
        return new BaseStreamMatcher<T, Stream<T>>(){

            protected boolean matchesSafely(Stream<T> actual) {
                return this.remainingItemsEqual(expected.limit(limit).iterator(), actual.limit(limit).iterator());
            }
        };
    }

    public static Matcher<DoubleStream> startsWith(final DoubleStream expected, final long limit) {
        return new BaseStreamMatcher<Double, DoubleStream>(){

            protected boolean matchesSafely(DoubleStream actual) {
                return this.remainingItemsEqual(expected.limit(limit).iterator(), actual.limit(limit).iterator());
            }
        };
    }

    public static Matcher<IntStream> startsWith(final IntStream expected, final long limit) {
        return new BaseStreamMatcher<Integer, IntStream>(){

            protected boolean matchesSafely(IntStream actual) {
                return this.remainingItemsEqual(expected.limit(limit).iterator(), actual.limit(limit).iterator());
            }
        };
    }

    public static Matcher<LongStream> startsWith(final LongStream expected, final long limit) {
        return new BaseStreamMatcher<Long, LongStream>(){

            protected boolean matchesSafely(LongStream actual) {
                return this.remainingItemsEqual(expected.limit(limit).iterator(), actual.limit(limit).iterator());
            }
        };
    }

    private static void describeToStartsAllWith(Description description, long limit, Matcher<?> matcher) {
        description.appendText("First ").appendText(Long.toString(limit)).appendText(" to match ").appendValue(matcher);
    }

    public static <T> Matcher<Stream<T>> startsWithAll(final Matcher<T> matcher, final long limit) {
        return new StreamAllMatches<T>(matcher){

            @Override
            protected boolean matchesSafely(Stream<T> actual) {
                return super.matchesSafely(actual.limit(limit));
            }

            public void describeTo(Description description) {
                StreamMatchers.describeToStartsAllWith(description, limit, matcher);
            }
        };
    }

    public static Matcher<LongStream> startsWithAllLong(final Matcher<Long> matcher, final long limit) {
        return new LongStreamAllMatches(matcher){

            @Override
            protected boolean matchesSafely(LongStream actual) {
                return super.matchesSafely(actual.limit(limit));
            }

            public void describeTo(Description description) {
                StreamMatchers.describeToStartsAllWith(description, limit, matcher);
            }
        };
    }

    public static Matcher<IntStream> startsWithAllInt(final Matcher<Integer> matcher, final long limit) {
        return new IntStreamAllMatches(matcher){

            @Override
            protected boolean matchesSafely(IntStream actual) {
                return super.matchesSafely(actual.limit(limit));
            }

            public void describeTo(Description description) {
                StreamMatchers.describeToStartsAllWith(description, limit, matcher);
            }
        };
    }

    public static Matcher<DoubleStream> startsWithAllDouble(final Matcher<Double> matcher, final long limit) {
        return new DoubleStreamAllMatches(matcher){

            @Override
            protected boolean matchesSafely(DoubleStream actual) {
                return super.matchesSafely(actual.limit(limit));
            }

            public void describeTo(Description description) {
                StreamMatchers.describeToStartsAllWith(description, limit, matcher);
            }
        };
    }

    private static void describeToStartsAnyWith(Description description, long limit, Matcher<?> matcher) {
        description.appendText("Any of first ").appendText(Long.toString(limit)).appendText(" to match ").appendValue(matcher);
    }

    public static <T> Matcher<Stream<T>> startsWithAny(Matcher<T> matcher, final long limit) {
        return new StreamAnyMatches<T>(matcher){

            @Override
            protected boolean matchesSafely(Stream<T> actual) {
                return super.matchesSafely(actual.limit(limit));
            }

            public void describeTo(Description description) {
                StreamMatchers.describeToStartsAnyWith(description, limit, this.matcher);
            }
        };
    }

    public static Matcher<LongStream> startsWithAnyLong(Matcher<Long> matcher, final long limit) {
        return new LongStreamAnyMatches(matcher){

            @Override
            protected boolean matchesSafely(LongStream actual) {
                return super.matchesSafely(actual.limit(limit));
            }

            public void describeTo(Description description) {
                StreamMatchers.describeToStartsAnyWith(description, limit, this.matcher);
            }
        };
    }

    public static Matcher<DoubleStream> startsWithAnyDouble(Matcher<Double> matcher, final long limit) {
        return new DoubleStreamAnyMatches(matcher){

            @Override
            protected boolean matchesSafely(DoubleStream actual) {
                return super.matchesSafely(actual.limit(limit));
            }

            public void describeTo(Description description) {
                StreamMatchers.describeToStartsAnyWith(description, limit, this.matcher);
            }
        };
    }

    public static Matcher<IntStream> startsWithAnyInt(Matcher<Integer> matcher, final long limit) {
        return new IntStreamAnyMatches(matcher){

            @Override
            protected boolean matchesSafely(IntStream actual) {
                return super.matchesSafely(actual.limit(limit));
            }

            public void describeTo(Description description) {
                StreamMatchers.describeToStartsAnyWith(description, limit, this.matcher);
            }
        };
    }

    @SafeVarargs
    public static <T, S extends BaseStream<T, S>> Matcher<S> contains(final T ... expected) {
        return new BaseStreamMatcher<T, S>(){

            protected boolean matchesSafely(S actual) {
                return this.remainingItemsEqual(new ArrayIterator<Object>(expected), actual.iterator());
            }
        };
    }

    public static <T> Matcher<Stream<T>> allMatch(final Matcher<T> matcher) {
        return new StreamAllMatches<T>(matcher){

            public void describeTo(Description description) {
                description.appendText("All to match ").appendValue((Object)matcher);
            }
        };
    }

    public static Matcher<IntStream> allMatchInt(final Matcher<Integer> matcher) {
        return new IntStreamAllMatches(matcher){

            public void describeTo(Description description) {
                description.appendText("All to match ").appendValue((Object)matcher);
            }
        };
    }

    public static Matcher<LongStream> allMatchLong(final Matcher<Long> matcher) {
        return new LongStreamAllMatches(matcher){

            public void describeTo(Description description) {
                description.appendText("All to match ").appendValue((Object)matcher);
            }
        };
    }

    public static Matcher<DoubleStream> allMatchDouble(final Matcher<Double> matcher) {
        return new DoubleStreamAllMatches(matcher){

            public void describeTo(Description description) {
                description.appendText("All to match ").appendValue((Object)matcher);
            }
        };
    }

    public static <T> Matcher<Stream<T>> anyMatch(Matcher<T> matcher) {
        return new StreamAnyMatches<T>((Matcher)matcher){

            public void describeTo(Description description) {
                description.appendText("Any to match ").appendValue((Object)this.matcher);
            }
        };
    }

    public static Matcher<LongStream> anyMatchLong(Matcher<Long> matcher) {
        return new LongStreamAnyMatches((Matcher)matcher){

            public void describeTo(Description description) {
                description.appendText("Any to match ").appendValue((Object)this.matcher);
            }
        };
    }

    public static Matcher<DoubleStream> anyMatchDouble(Matcher<Double> matcher) {
        return new DoubleStreamAnyMatches((Matcher)matcher){

            public void describeTo(Description description) {
                description.appendText("Any to match ").appendValue((Object)this.matcher);
            }
        };
    }

    public static Matcher<IntStream> anyMatchInt(Matcher<Integer> matcher) {
        return new IntStreamAnyMatches((Matcher)matcher){

            public void describeTo(Description description) {
                description.appendText("Any to match ").appendValue((Object)this.matcher);
            }
        };
    }

    @SafeVarargs
    public static <T> Matcher<Stream<T>> startsWith(final T ... expected) {
        return new BaseStreamMatcher<T, Stream<T>>(){

            protected boolean matchesSafely(Stream<T> actual) {
                return this.remainingItemsEqual(new ArrayIterator<Object>(expected), actual.limit(expected.length).iterator());
            }
        };
    }

    public static Matcher<DoubleStream> startsWithDouble(final double ... expected) {
        return new BaseStreamMatcher<Double, DoubleStream>(){

            protected boolean matchesSafely(DoubleStream actual) {
                return this.remainingItemsEqual(new DoubleArrayIterator(expected), actual.limit(expected.length).iterator());
            }
        };
    }

    public static Matcher<LongStream> startsWithLong(final long ... expected) {
        return new BaseStreamMatcher<Long, LongStream>(){

            protected boolean matchesSafely(LongStream actual) {
                return this.remainingItemsEqual(new LongArrayIterator(expected), actual.limit(expected.length).iterator());
            }
        };
    }

    public static Matcher<IntStream> startsWithInt(final int ... expected) {
        return new BaseStreamMatcher<Integer, IntStream>(){

            protected boolean matchesSafely(IntStream actual) {
                return this.remainingItemsEqual(new IntArrayIterator(expected), actual.limit(expected.length).iterator());
            }
        };
    }

    private static void allMatchMismatch(Description mismatchDescription, long position, Object nonMatch) {
        mismatchDescription.appendText("Item ").appendText(Long.toString(position)).appendText(" failed to match: ").appendValue(nonMatch);
    }

    private static void anyMatchMismatch(Description mismatchDescription, List<?> accumulator) {
        mismatchDescription.appendText("None of these items matched: ").appendValueList("[", ",", "]", accumulator);
    }

    private static class DoubleArrayIterator
    implements PrimitiveIterator.OfDouble {
        private final double[] expected;
        private int currentPos = 0;

        public DoubleArrayIterator(double ... expected) {
            this.expected = expected;
        }

        @Override
        public boolean hasNext() {
            return this.currentPos < this.expected.length;
        }

        @Override
        public double nextDouble() {
            return this.expected[this.currentPos++];
        }
    }

    private static class LongArrayIterator
    implements PrimitiveIterator.OfLong {
        private final long[] expected;
        private int currentPos = 0;

        public LongArrayIterator(long ... expected) {
            this.expected = expected;
        }

        @Override
        public boolean hasNext() {
            return this.currentPos < this.expected.length;
        }

        @Override
        public long nextLong() {
            return this.expected[this.currentPos++];
        }
    }

    private static class IntArrayIterator
    implements PrimitiveIterator.OfInt {
        private final int[] expected;
        private int currentPos = 0;

        public IntArrayIterator(int ... expected) {
            this.expected = expected;
        }

        @Override
        public boolean hasNext() {
            return this.currentPos < this.expected.length;
        }

        @Override
        public int nextInt() {
            return this.expected[this.currentPos++];
        }
    }

    private static class ArrayIterator<T>
    implements Iterator<T> {
        private final T[] expected;
        private int currentPos = 0;

        @SafeVarargs
        public ArrayIterator(T ... expected) {
            this.expected = expected;
        }

        @Override
        public boolean hasNext() {
            return this.currentPos < this.expected.length;
        }

        @Override
        public T next() {
            return this.expected[this.currentPos++];
        }
    }

    private static abstract class DoubleStreamAnyMatches
    extends TypeSafeMatcher<DoubleStream> {
        final List<Double> accumulator = new LinkedList<Double>();
        final Matcher<Double> matcher;

        DoubleStreamAnyMatches(Matcher<Double> matcher) {
            this.matcher = matcher;
        }

        protected boolean matchesSafely(DoubleStream actual) {
            return actual.peek(this.accumulator::add).anyMatch(arg_0 -> this.matcher.matches(arg_0));
        }

        protected void describeMismatchSafely(DoubleStream actual, Description mismatchDescription) {
            StreamMatchers.anyMatchMismatch(mismatchDescription, this.accumulator);
        }
    }

    private static abstract class IntStreamAnyMatches
    extends TypeSafeMatcher<IntStream> {
        final List<Integer> accumulator = new LinkedList<Integer>();
        final Matcher<Integer> matcher;

        IntStreamAnyMatches(Matcher<Integer> matcher) {
            this.matcher = matcher;
        }

        protected boolean matchesSafely(IntStream actual) {
            return actual.peek(this.accumulator::add).anyMatch(arg_0 -> this.matcher.matches(arg_0));
        }

        protected void describeMismatchSafely(IntStream actual, Description mismatchDescription) {
            StreamMatchers.anyMatchMismatch(mismatchDescription, this.accumulator);
        }
    }

    private static abstract class LongStreamAnyMatches
    extends TypeSafeMatcher<LongStream> {
        final List<Long> accumulator = new LinkedList<Long>();
        final Matcher<Long> matcher;

        LongStreamAnyMatches(Matcher<Long> matcher) {
            this.matcher = matcher;
        }

        protected boolean matchesSafely(LongStream actual) {
            return actual.peek(this.accumulator::add).anyMatch(arg_0 -> this.matcher.matches(arg_0));
        }

        protected void describeMismatchSafely(LongStream actual, Description mismatchDescription) {
            StreamMatchers.anyMatchMismatch(mismatchDescription, this.accumulator);
        }
    }

    private static abstract class StreamAnyMatches<T>
    extends TypeSafeMatcher<Stream<T>> {
        final List<T> accumulator = new LinkedList<T>();
        final Matcher<T> matcher;

        StreamAnyMatches(Matcher<T> matcher) {
            this.matcher = matcher;
        }

        protected boolean matchesSafely(Stream<T> actual) {
            return actual.peek(this.accumulator::add).anyMatch(arg_0 -> this.matcher.matches(arg_0));
        }

        protected void describeMismatchSafely(Stream<T> actual, Description mismatchDescription) {
            StreamMatchers.anyMatchMismatch(mismatchDescription, this.accumulator);
        }
    }

    private static abstract class DoubleStreamAllMatches
    extends TypeSafeMatcher<DoubleStream> {
        private double nonMatching;
        private long positionNonMatching = -1L;
        private final Matcher<Double> matcher;

        DoubleStreamAllMatches(Matcher<Double> matcher) {
            this.matcher = matcher;
        }

        protected boolean matchesSafely(DoubleStream actual) {
            return actual.peek(i -> {
                this.nonMatching = i;
                ++this.positionNonMatching;
            }).allMatch(arg_0 -> this.matcher.matches(arg_0));
        }

        protected void describeMismatchSafely(DoubleStream actual, Description mismatchDescription) {
            StreamMatchers.allMatchMismatch(mismatchDescription, this.positionNonMatching, this.nonMatching);
        }
    }

    private static abstract class LongStreamAllMatches
    extends TypeSafeMatcher<LongStream> {
        private long nonMatching;
        private long positionNonMatching = -1L;
        private final Matcher<Long> matcher;

        LongStreamAllMatches(Matcher<Long> matcher) {
            this.matcher = matcher;
        }

        protected boolean matchesSafely(LongStream actual) {
            return actual.peek(i -> {
                this.nonMatching = i;
                ++this.positionNonMatching;
            }).allMatch(arg_0 -> this.matcher.matches(arg_0));
        }

        protected void describeMismatchSafely(LongStream actual, Description mismatchDescription) {
            StreamMatchers.allMatchMismatch(mismatchDescription, this.positionNonMatching, this.nonMatching);
        }
    }

    private static abstract class IntStreamAllMatches
    extends TypeSafeMatcher<IntStream> {
        private int nonMatching;
        private long positionNonMatching = -1L;
        private final Matcher<Integer> matcher;

        IntStreamAllMatches(Matcher<Integer> matcher) {
            this.matcher = matcher;
        }

        protected boolean matchesSafely(IntStream actual) {
            return actual.peek(i -> {
                this.nonMatching = i;
                ++this.positionNonMatching;
            }).allMatch(arg_0 -> this.matcher.matches(arg_0));
        }

        protected void describeMismatchSafely(IntStream actual, Description mismatchDescription) {
            StreamMatchers.allMatchMismatch(mismatchDescription, this.positionNonMatching, this.nonMatching);
        }
    }

    private static abstract class StreamAllMatches<T>
    extends TypeSafeMatcher<Stream<T>> {
        private T nonMatching;
        private long positionNonMatching = -1L;
        private final Matcher<T> matcher;

        StreamAllMatches(Matcher<T> matcher) {
            this.matcher = matcher;
        }

        protected boolean matchesSafely(Stream<T> actual) {
            return actual.peek(i -> {
                this.nonMatching = i;
                ++this.positionNonMatching;
            }).allMatch(arg_0 -> this.matcher.matches(arg_0));
        }

        protected void describeMismatchSafely(Stream<T> actual, Description mismatchDescription) {
            StreamMatchers.allMatchMismatch(mismatchDescription, this.positionNonMatching, this.nonMatching);
        }
    }

    private static abstract class BaseStreamMatcher<T, S extends BaseStream<T, ?>>
    extends TypeSafeMatcher<S> {
        final List<T> expectedAccumulator = new LinkedList<T>();
        final List<T> actualAccumulator = new LinkedList<T>();

        private BaseStreamMatcher() {
        }

        public void describeTo(Description description) {
            this.describe(description, this.expectedAccumulator);
        }

        protected void describeMismatchSafely(S item, Description description) {
            this.describe(description, this.actualAccumulator);
        }

        private void describe(Description description, List<T> values) {
            description.appendText("Stream of ").appendValueList("[", ",", "]", values);
        }

        boolean remainingItemsEqual(Iterator<T> expectedIterator, Iterator<T> actualIterator) {
            if (!expectedIterator.hasNext() && !actualIterator.hasNext()) {
                return true;
            }
            if (expectedIterator.hasNext() && actualIterator.hasNext()) {
                T nextExpected = expectedIterator.next();
                this.expectedAccumulator.add(nextExpected);
                T nextActual = actualIterator.next();
                this.actualAccumulator.add(nextActual);
                if (Objects.equals(nextExpected, nextActual)) {
                    return this.remainingItemsEqual(expectedIterator, actualIterator);
                }
            }
            expectedIterator.forEachRemaining(this.expectedAccumulator::add);
            actualIterator.forEachRemaining(this.actualAccumulator::add);
            return false;
        }
    }
}

