/*
 * Decompiled with CFR 0.152.
 */
package co.touchlab.squeaky.stmt.query;

import co.touchlab.squeaky.dao.SqueakyContext;
import co.touchlab.squeaky.field.FieldType;
import co.touchlab.squeaky.sql.SqlHelper;
import co.touchlab.squeaky.stmt.JoinAlias;
import co.touchlab.squeaky.stmt.query.BaseComparison;
import java.sql.SQLException;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;

public class In
extends BaseComparison {
    private Collection<?> objects;
    private final boolean in;

    public In(FieldType fieldType, Collection<?> objects, boolean in, JoinAlias joinAlias) throws SQLException {
        super(fieldType, null, true, joinAlias);
        this.objects = objects;
        this.in = in;
    }

    public In(FieldType fieldType, Object[] objects, boolean in, JoinAlias joinAlias) throws SQLException {
        super(fieldType, null, true, joinAlias);
        this.objects = Arrays.asList(objects);
        this.in = in;
    }

    @Override
    public String getOperation() {
        StringBuilder sb = new StringBuilder();
        if (this.in) {
            sb.append("IN (");
        } else {
            sb.append("NOT IN (");
        }
        for (int i = 0; i < this.objects.size(); ++i) {
            if (i > 0) {
                sb.append(',');
            }
            sb.append('?');
        }
        sb.append(')');
        return sb.toString();
    }

    @Override
    public void appendValue(SqueakyContext squeakyContext, List<String> params) throws SQLException {
        for (Object value : this.objects) {
            if (value == null) {
                throw new IllegalArgumentException("one of the IN values for '" + this.fieldType.getColumnName() + "' is null");
            }
            SqlHelper.appendArgOrValue((SqueakyContext)squeakyContext, (FieldType)this.fieldType, params, value);
        }
    }
}

