/*
 * Decompiled with CFR 0.152.
 */
package co.touchlab.squeaky.stmt.query;

import co.touchlab.squeaky.dao.SqueakyContext;
import co.touchlab.squeaky.field.FieldType;
import co.touchlab.squeaky.sql.SqlHelper;
import co.touchlab.squeaky.stmt.JoinAlias;
import co.touchlab.squeaky.stmt.query.Comparison;
import java.sql.SQLException;
import java.util.List;

abstract class BaseComparison
implements Comparison {
    private static final String NUMBER_CHARACTERS = "0123456789.-+";
    protected final FieldType fieldType;
    private final JoinAlias joinAlias;
    private final Object value;

    protected BaseComparison(FieldType fieldType, Object value, boolean isComparison, JoinAlias joinAlias) throws SQLException {
        this.joinAlias = joinAlias;
        if (isComparison && fieldType != null && !fieldType.isComparable()) {
            throw new SQLException("Field '" + fieldType.getColumnName() + "' is of data type " + fieldType.getDataPersister() + " which can not be compared");
        }
        this.fieldType = fieldType;
        this.value = value;
    }

    @Override
    public abstract String getOperation();

    @Override
    public void appendSql(SqueakyContext squeakyContext, StringBuilder sb, boolean joinsAllowed) throws SQLException {
        SqlHelper.appendWhereClauseBody((StringBuilder)sb, (String)(joinsAllowed ? this.joinAlias.tablePrefix : null), (String)this.getOperation(), (FieldType)this.fieldType);
    }

    @Override
    public void appendValue(SqueakyContext squeakyContext, List<String> params) throws SQLException {
        SqlHelper.appendArgOrValue((SqueakyContext)squeakyContext, (FieldType)this.fieldType, params, (Object)this.value);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.fieldType.getColumnName()).append(' ');
        sb.append(this.getOperation());
        sb.append(' ');
        sb.append(this.value);
        return sb.toString();
    }
}

