/*
 * Decompiled with CFR 0.152.
 */
package co.touchlab.squeaky.table;

import co.touchlab.squeaky.dao.SqueakyContext;
import co.touchlab.squeaky.db.SQLiteDatabase;
import co.touchlab.squeaky.field.DataPersister;
import co.touchlab.squeaky.field.FieldType;
import co.touchlab.squeaky.field.SqlType;
import co.touchlab.squeaky.logger.OLog;
import co.touchlab.squeaky.misc.SqlExceptionUtil;
import co.touchlab.squeaky.table.GeneratedTableMapper;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;

public class TableUtils {
    public static final String TAG = TableUtils.class.getSimpleName();

    private TableUtils() {
    }

    public static <T> int createTables(SQLiteDatabase connectionSource, Class ... clazz) throws SQLException {
        int count = 0;
        for (Class aClass : clazz) {
            count += TableUtils.createTable(connectionSource, aClass, false);
        }
        return count;
    }

    private static GeneratedTableMapper loadTableMapper(Class dataclass) {
        return SqueakyContext.loadGeneratedTableMapper(dataclass);
    }

    public static <T> int createTablesIfNotExists(SQLiteDatabase connectionSource, Class ... clazz) throws SQLException {
        int count = 0;
        for (Class aClass : clazz) {
            count += TableUtils.createTable(connectionSource, aClass, true);
        }
        return count;
    }

    public static <T> List<String> getCreateTableStatements(SQLiteDatabase connectionSource, Class clazz) throws SQLException {
        return TableUtils.addCreateTableStatements(TableUtils.loadTableMapper(clazz), false);
    }

    public static <T> int dropTables(SQLiteDatabase connectionSource, boolean ignoreErrors, Class ... clazz) throws SQLException {
        int count = 0;
        for (Class aClass : clazz) {
            count += TableUtils.doDropTable(connectionSource, TableUtils.loadTableMapper(aClass), ignoreErrors);
        }
        return count;
    }

    public static <T> int dropViews(SQLiteDatabase connectionSource, boolean ignoreErrors, Class ... clazz) throws SQLException {
        int count = 0;
        for (Class aClass : clazz) {
            count += TableUtils.doDropView(connectionSource, TableUtils.loadTableMapper(aClass), ignoreErrors);
        }
        return count;
    }

    public static <T> void clearTable(SQLiteDatabase connectionSource, Class clazz) throws SQLException {
        TableUtils.clearTable(connectionSource, TableUtils.loadTableMapper(clazz).getTableConfig().getTableName());
    }

    private static <T> int createTable(SQLiteDatabase connectionSource, Class clazz, boolean ifNotExists) throws SQLException {
        return TableUtils.doCreateTable(connectionSource, TableUtils.loadTableMapper(clazz), ifNotExists);
    }

    private static void clearTable(SQLiteDatabase connectionSource, String tableName) throws SQLException {
        StringBuilder sb = new StringBuilder(48);
        sb.append("DELETE FROM ");
        TableUtils.appendEscapedEntityName(sb, tableName);
        String statement = sb.toString();
        OLog.i(TAG, "clearing table '{" + tableName + "}' with '{" + statement + "}");
        connectionSource.execSQL(sb.toString());
    }

    private static <T> int doDropTable(SQLiteDatabase connectionSource, GeneratedTableMapper<T> tableInfo, boolean ignoreErrors) throws SQLException {
        OLog.i(TAG, "dropping table '{" + tableInfo.getTableConfig().getTableName() + "}'");
        ArrayList<String> statements = new ArrayList<String>();
        TableUtils.addDropIndexStatements(tableInfo, statements);
        TableUtils.addDropTableStatements(tableInfo, statements);
        return TableUtils.doStatements(connectionSource, "drop", statements, ignoreErrors, false, false);
    }

    private static <T> int doDropView(SQLiteDatabase connectionSource, GeneratedTableMapper<T> tableInfo, boolean ignoreErrors) throws SQLException {
        OLog.i(TAG, "dropping table '{" + tableInfo.getTableConfig().getTableName() + "}'");
        ArrayList<String> statements = new ArrayList<String>();
        TableUtils.addDropViewStatements(tableInfo, statements);
        return TableUtils.doStatements(connectionSource, "drop", statements, ignoreErrors, false, false);
    }

    private static <T> void addDropIndexStatements(GeneratedTableMapper<T> tableInfo, List<String> statements) throws SQLException {
        HashSet<String> indexSet = new HashSet<String>();
        for (FieldType fieldType : tableInfo.getTableConfig().getFieldTypes()) {
            String uniqueIndexName;
            String indexName = fieldType.getIndexName();
            if (indexName != null) {
                indexSet.add(indexName);
            }
            if ((uniqueIndexName = fieldType.getUniqueIndexName()) == null) continue;
            indexSet.add(uniqueIndexName);
        }
        StringBuilder sb = new StringBuilder(48);
        for (String indexName : indexSet) {
            OLog.i(TAG, "dropping index '{" + indexName + "}' for table '{" + tableInfo.getTableConfig().getTableName() + "}");
            sb.append("DROP INDEX ");
            TableUtils.appendEscapedEntityName(sb, indexName);
            statements.add(sb.toString());
            sb.setLength(0);
        }
    }

    private static <T> void addCreateTableStatements(GeneratedTableMapper<T> tableInfo, List<String> statements, boolean ifNotExists) throws SQLException {
        StringBuilder sb = new StringBuilder(256);
        sb.append("CREATE TABLE ");
        if (ifNotExists) {
            sb.append("IF NOT EXISTS ");
        }
        TableUtils.appendEscapedEntityName(sb, tableInfo.getTableConfig().getTableName());
        sb.append(" (");
        ArrayList<String> additionalArgs = new ArrayList<String>();
        ArrayList statementsBefore = new ArrayList();
        ArrayList statementsAfter = new ArrayList();
        boolean first = true;
        for (FieldType fieldType : tableInfo.getTableConfig().getFieldTypes()) {
            if (first) {
                first = false;
            } else {
                sb.append(", ");
            }
            TableUtils.appendColumnArg(sb, fieldType, additionalArgs);
        }
        TableUtils.addPrimaryKeySql(tableInfo.getTableConfig().getFieldTypes(), additionalArgs);
        TableUtils.addUniqueComboSql(tableInfo.getTableConfig().getFieldTypes(), additionalArgs);
        for (String arg : additionalArgs) {
            sb.append(", ").append(arg);
        }
        sb.append(") ");
        statements.addAll(statementsBefore);
        statements.add(sb.toString());
        statements.addAll(statementsAfter);
        TableUtils.addCreateIndexStatements(tableInfo, statements, ifNotExists, false);
        TableUtils.addCreateIndexStatements(tableInfo, statements, ifNotExists, true);
    }

    private static <T> void addCreateIndexStatements(GeneratedTableMapper<T> tableInfo, List<String> statements, boolean ifNotExists, boolean unique) throws SQLException {
        HashMap<String, ArrayList<String>> indexMap = new HashMap<String, ArrayList<String>>();
        for (FieldType fieldType : tableInfo.getTableConfig().getFieldTypes()) {
            String indexName = unique ? fieldType.getUniqueIndexName() : fieldType.getIndexName();
            if (indexName == null) continue;
            ArrayList<String> columnList = (ArrayList<String>)indexMap.get(indexName);
            if (columnList == null) {
                columnList = new ArrayList<String>();
                indexMap.put(indexName, columnList);
            }
            columnList.add(fieldType.getColumnName());
        }
        StringBuilder sb = new StringBuilder(128);
        for (Map.Entry indexEntry : indexMap.entrySet()) {
            OLog.i(TAG, "creating index '{" + (String)indexEntry.getKey() + "}' for table '{" + tableInfo.getTableConfig().getTableName() + "}");
            sb.append("CREATE ");
            if (unique) {
                sb.append("UNIQUE ");
            }
            sb.append("INDEX ");
            if (ifNotExists) {
                sb.append("IF NOT EXISTS ");
            }
            TableUtils.appendEscapedEntityName(sb, (String)indexEntry.getKey());
            sb.append(" ON ");
            TableUtils.appendEscapedEntityName(sb, tableInfo.getTableConfig().getTableName());
            sb.append(" ( ");
            boolean first = true;
            for (String columnName : (List)indexEntry.getValue()) {
                if (first) {
                    first = false;
                } else {
                    sb.append(", ");
                }
                TableUtils.appendEscapedEntityName(sb, columnName);
            }
            sb.append(" )");
            statements.add(sb.toString());
            sb.setLength(0);
        }
    }

    private static <T> void addDropTableStatements(GeneratedTableMapper<T> tableInfo, List<String> statements) throws SQLException {
        ArrayList statementsBefore = new ArrayList();
        ArrayList statementsAfter = new ArrayList();
        StringBuilder sb = new StringBuilder(64);
        sb.append("DROP TABLE ");
        TableUtils.appendEscapedEntityName(sb, tableInfo.getTableConfig().getTableName());
        sb.append(' ');
        statements.addAll(statementsBefore);
        statements.add(sb.toString());
        statements.addAll(statementsAfter);
    }

    private static <T> void addDropViewStatements(GeneratedTableMapper<T> tableInfo, List<String> statements) throws SQLException {
        StringBuilder sb = new StringBuilder(64);
        sb.append("DROP VIEW ");
        TableUtils.appendEscapedEntityName(sb, tableInfo.getTableConfig().getTableName());
        sb.append(' ');
        statements.add(sb.toString());
    }

    private static <T> int doCreateTable(SQLiteDatabase connectionSource, GeneratedTableMapper<T> tableInfo, boolean ifNotExists) throws SQLException {
        OLog.i(TAG, "creating table '{" + tableInfo.getTableConfig().getTableName() + "}'");
        ArrayList<String> statements = new ArrayList<String>();
        TableUtils.addCreateTableStatements(tableInfo, statements, ifNotExists);
        int stmtC = TableUtils.doStatements(connectionSource, "create", statements, false, false, false);
        return stmtC;
    }

    private static int doStatements(SQLiteDatabase connection, String label, Collection<String> statements, boolean ignoreErrors, boolean returnsNegative, boolean expectingZero) throws SQLException {
        int stmtC = 0;
        for (String statement : statements) {
            try {
                connection.execSQL(statement);
                OLog.i(TAG, "executed {" + label + "} table statement changed: {" + statement + "}");
            }
            catch (Exception e) {
                if (ignoreErrors) {
                    OLog.i(TAG, "ignoring {" + label + "} error for statement: {" + statement + "}", e);
                }
                throw SqlExceptionUtil.create("SQL statement failed: " + statement, e);
            }
            ++stmtC;
        }
        return stmtC;
    }

    private static <T> List<String> addCreateTableStatements(GeneratedTableMapper<T> tableInfo, boolean ifNotExists) throws SQLException {
        ArrayList<String> statements = new ArrayList<String>();
        TableUtils.addCreateTableStatements(tableInfo, statements, ifNotExists);
        return statements;
    }

    public static void appendEscapedEntityName(StringBuilder sb, String name) {
        sb.append('`').append(name).append('`');
    }

    private static void appendDefaultValue(StringBuilder sb, FieldType fieldType, Object defaultValue) {
        if (fieldType.isEscapedDefaultValue()) {
            TableUtils.appendEscapedWord(sb, defaultValue.toString());
        } else {
            sb.append(defaultValue);
        }
    }

    public static void addPrimaryKeySql(FieldType[] fieldTypes, List<String> additionalArgs) {
        StringBuilder sb = null;
        for (FieldType fieldType : fieldTypes) {
            if (fieldType.isGeneratedId() || !fieldType.isId()) continue;
            if (sb == null) {
                sb = new StringBuilder(48);
                sb.append("PRIMARY KEY (");
            } else {
                sb.append(',');
            }
            TableUtils.appendEscapedEntityName(sb, fieldType.getColumnName());
        }
        if (sb != null) {
            sb.append(") ");
            additionalArgs.add(sb.toString());
        }
    }

    public static void addUniqueComboSql(FieldType[] fieldTypes, List<String> additionalArgs) {
        StringBuilder sb = null;
        for (FieldType fieldType : fieldTypes) {
            if (!fieldType.isUniqueCombo()) continue;
            if (sb == null) {
                sb = new StringBuilder(48);
                sb.append("UNIQUE (");
            } else {
                sb.append(',');
            }
            TableUtils.appendEscapedEntityName(sb, fieldType.getColumnName());
        }
        if (sb != null) {
            sb.append(") ");
            additionalArgs.add(sb.toString());
        }
    }

    public static void appendEscapedWord(StringBuilder sb, String word) {
        sb.append('\'').append(word).append('\'');
    }

    private static void addSingleUnique(FieldType fieldType, List<String> additionalArgs) {
        StringBuilder alterSb = new StringBuilder();
        alterSb.append(" UNIQUE (");
        TableUtils.appendEscapedEntityName(alterSb, fieldType.getColumnName());
        alterSb.append(")");
        additionalArgs.add(alterSb.toString());
    }

    public static void appendColumnArg(StringBuilder sb, FieldType fieldType, List<String> additionalArgs) throws SQLException {
        TableUtils.appendEscapedEntityName(sb, fieldType.getColumnName());
        sb.append(' ');
        DataPersister dataPersister = fieldType.getDataPersister();
        switch (dataPersister.getSqlType()) {
            case STRING: {
                TableUtils.appendStringType(sb);
                break;
            }
            case LONG_STRING: {
                TableUtils.appendLongStringType(sb);
                break;
            }
            case BOOLEAN: {
                TableUtils.appendBooleanType(sb);
                break;
            }
            case DATE: {
                TableUtils.appendDateType(sb);
                break;
            }
            case CHAR: {
                TableUtils.appendCharType(sb);
                break;
            }
            case BYTE: {
                TableUtils.appendByteType(sb);
                break;
            }
            case BYTE_ARRAY: {
                TableUtils.appendByteArrayType(sb);
                break;
            }
            case SHORT: {
                TableUtils.appendShortType(sb);
                break;
            }
            case INTEGER: {
                TableUtils.appendIntegerType(sb);
                break;
            }
            case LONG: {
                TableUtils.appendLongType(sb, fieldType);
                break;
            }
            case FLOAT: {
                TableUtils.appendFloatType(sb);
                break;
            }
            case DOUBLE: {
                TableUtils.appendDoubleType(sb);
                break;
            }
            case SERIALIZABLE: {
                TableUtils.appendSerializableType(sb);
                break;
            }
            case BIG_DECIMAL: {
                TableUtils.appendBigDecimalNumericType(sb);
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown SQL-type " + (Object)((Object)dataPersister.getSqlType()));
            }
        }
        sb.append(' ');
        if (fieldType.isGeneratedId()) {
            TableUtils.configureGeneratedId(sb, fieldType);
        }
        if (!fieldType.isGeneratedId()) {
            Object defaultValue = fieldType.getDefaultValue();
            if (defaultValue != null) {
                sb.append("DEFAULT ");
                TableUtils.appendDefaultValue(sb, fieldType, defaultValue);
                sb.append(' ');
            }
            if (!fieldType.isCanBeNull()) {
                sb.append("NOT NULL ");
            }
            if (fieldType.isUnique()) {
                TableUtils.addSingleUnique(fieldType, additionalArgs);
            }
        }
    }

    protected static void appendStringType(StringBuilder sb) {
        sb.append("VARCHAR");
    }

    protected static void appendLongStringType(StringBuilder sb) {
        sb.append("TEXT");
    }

    protected static void appendDateType(StringBuilder sb) {
        sb.append("TIMESTAMP");
    }

    protected static void appendBooleanType(StringBuilder sb) {
        sb.append("BOOLEAN");
    }

    protected static void appendCharType(StringBuilder sb) {
        sb.append("CHAR");
    }

    protected static void appendByteType(StringBuilder sb) {
        sb.append("TINYINT");
    }

    protected static void appendShortType(StringBuilder sb) {
        sb.append("SMALLINT");
    }

    private static void appendIntegerType(StringBuilder sb) {
        sb.append("INTEGER");
    }

    private static void appendFloatType(StringBuilder sb) {
        sb.append("FLOAT");
    }

    private static void appendDoubleType(StringBuilder sb) {
        sb.append("DOUBLE PRECISION");
    }

    protected static void appendByteArrayType(StringBuilder sb) {
        sb.append("BLOB");
    }

    protected static void appendSerializableType(StringBuilder sb) {
        sb.append("BLOB");
    }

    protected static void appendBigDecimalNumericType(StringBuilder sb) {
        sb.append("NUMERIC");
    }

    protected static void appendLongType(StringBuilder sb, FieldType fieldType) {
        if (fieldType.getSqlType() == SqlType.LONG && fieldType.isGeneratedId()) {
            sb.append("INTEGER");
        } else {
            sb.append("BIGINT");
        }
    }

    protected static void configureGeneratedId(StringBuilder sb, FieldType fieldType) {
        if (fieldType.getSqlType() != SqlType.INTEGER && fieldType.getSqlType() != SqlType.LONG) {
            throw new IllegalArgumentException("Sqlite requires that auto-increment generated-id be integer or long type");
        }
        sb.append("PRIMARY KEY AUTOINCREMENT ");
    }
}

