/*
 * Decompiled with CFR 0.152.
 */
package co.touchlab.squeaky.field.types;

import android.database.Cursor;
import co.touchlab.squeaky.field.FieldType;
import co.touchlab.squeaky.field.SqlType;
import co.touchlab.squeaky.field.types.BaseDataType;
import co.touchlab.squeaky.misc.IOUtils;
import co.touchlab.squeaky.misc.SqlExceptionUtil;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.sql.SQLException;
import java.util.Arrays;

public class SerializableType
extends BaseDataType {
    private static final SerializableType singleTon = new SerializableType();

    public static SerializableType getSingleton() {
        return singleTon;
    }

    private SerializableType() {
        super(SqlType.SERIALIZABLE);
    }

    protected SerializableType(SqlType sqlType, Class<?>[] classes) {
        super(sqlType, classes);
    }

    @Override
    public Object parseDefaultString(FieldType fieldType, String defaultStr) throws SQLException {
        throw new SQLException("Default values for serializable types are not supported");
    }

    @Override
    public Object resultToSqlArg(FieldType fieldType, Cursor results, int columnPos) throws SQLException {
        return results.getBlob(columnPos);
    }

    @Override
    public Object sqlArgToJava(FieldType fieldType, Object sqlArg, int columnPos) throws SQLException {
        Object object;
        byte[] bytes = (byte[])sqlArg;
        ObjectInputStream objInStream = null;
        try {
            objInStream = new ObjectInputStream(new ByteArrayInputStream(bytes));
            object = objInStream.readObject();
        }
        catch (Exception e) {
            try {
                throw SqlExceptionUtil.create("Could not read serialized object from byte array: " + Arrays.toString(bytes) + "(len " + bytes.length + ")", e);
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(objInStream);
                throw throwable;
            }
        }
        IOUtils.closeQuietly(objInStream);
        return object;
    }

    @Override
    public Object javaToSqlArg(FieldType fieldType, Object obj) throws SQLException {
        byte[] byArray;
        ObjectOutputStream objOutStream = null;
        try {
            ByteArrayOutputStream outStream = new ByteArrayOutputStream();
            objOutStream = new ObjectOutputStream(outStream);
            objOutStream.writeObject(obj);
            objOutStream.close();
            objOutStream = null;
            byArray = outStream.toByteArray();
        }
        catch (Exception e) {
            try {
                throw SqlExceptionUtil.create("Could not write serialized object to byte array: " + obj, e);
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(objOutStream);
                throw throwable;
            }
        }
        IOUtils.closeQuietly(objOutStream);
        return byArray;
    }

    @Override
    public boolean isComparable() {
        return false;
    }
}

