/*
 * Decompiled with CFR 0.152.
 */
package co.touchlab.squeaky.field.types;

import android.database.Cursor;
import co.touchlab.squeaky.field.FieldType;
import co.touchlab.squeaky.field.SqlType;
import co.touchlab.squeaky.field.types.BooleanType;
import java.sql.SQLException;

public class BooleanIntegerType
extends BooleanType {
    private static final Integer TRUE_VALUE = 1;
    private static final Integer FALSE_VALUE = 0;
    private static final BooleanIntegerType singleTon = new BooleanIntegerType();

    public static BooleanIntegerType getSingleton() {
        return singleTon;
    }

    public BooleanIntegerType() {
        super(SqlType.INTEGER);
    }

    @Override
    public Object parseDefaultString(FieldType fieldType, String defaultStr) {
        return this.javaToSqlArg(fieldType, Boolean.parseBoolean(defaultStr));
    }

    @Override
    public Object javaToSqlArg(FieldType fieldType, Object obj) {
        return (Boolean)obj != false ? TRUE_VALUE : FALSE_VALUE;
    }

    @Override
    public Object resultToSqlArg(FieldType fieldType, Cursor results, int columnPos) throws SQLException {
        return results.getInt(columnPos);
    }

    @Override
    public Object sqlArgToJava(FieldType fieldType, Object sqlArg, int columnPos) {
        return (Integer)sqlArg == 0 ? Boolean.FALSE : Boolean.TRUE;
    }
}

