/*
 * Decompiled with CFR 0.152.
 */
package co.touchlab.squeaky.field;

import android.database.Cursor;
import android.text.TextUtils;
import co.touchlab.squeaky.field.BaseFieldConverter;
import co.touchlab.squeaky.field.DataPersister;
import co.touchlab.squeaky.field.DataType;
import co.touchlab.squeaky.field.FieldConverter;
import co.touchlab.squeaky.field.SqlType;
import co.touchlab.squeaky.field.types.BigDecimalStringType;
import co.touchlab.squeaky.field.types.DateStringType;
import co.touchlab.squeaky.field.types.TimeStampStringType;
import co.touchlab.squeaky.field.types.TimeStampType;
import java.sql.SQLException;

public class FieldType {
    public static final String FOREIGN_ID_FIELD_SUFFIX = "_id";
    private static boolean DEFAULT_VALUE_BOOLEAN;
    private static byte DEFAULT_VALUE_BYTE;
    private static char DEFAULT_VALUE_CHAR;
    private static short DEFAULT_VALUE_SHORT;
    private static int DEFAULT_VALUE_INT;
    private static long DEFAULT_VALUE_LONG;
    private static float DEFAULT_VALUE_FLOAT;
    private static double DEFAULT_VALUE_DOUBLE;
    private final String columnName;
    private final boolean isId;
    private final boolean isGeneratedId;
    private final boolean isForeign;
    private final String fieldName;
    private final DataType dataType;
    private final Class fieldType;
    private final boolean canBeNull;
    private final String format;
    private final boolean unique;
    private final boolean uniqueCombo;
    private final boolean index;
    private final boolean uniqueIndex;
    private final boolean foreignAutoRefresh;
    private String indexNameBase;
    private String indexName;
    private String uniqueIndexName;
    private DataPersister dataPersister;
    private Object defaultValue;
    private Object dataTypeConfigObj;
    private FieldConverter fieldConverter;
    private static final FieldConverter booleanConverter;

    public FieldType(String indexNameBase, String fieldName, String columnName, boolean isId, boolean isGeneratedId, boolean isForeign, DataType dataType, Class fieldType, boolean canBeNull, String format, boolean unique, boolean uniqueCombo, boolean index, boolean uniqueIndex, String indexName, String uniqueIndexName, String configDefaultValue, boolean foreignAutoRefresh) {
        this.fieldName = fieldName;
        this.indexNameBase = indexNameBase;
        this.canBeNull = canBeNull;
        this.format = format;
        this.unique = unique;
        this.uniqueCombo = uniqueCombo;
        this.index = index;
        this.uniqueIndex = uniqueIndex;
        this.indexName = indexName;
        this.uniqueIndexName = uniqueIndexName;
        this.foreignAutoRefresh = foreignAutoRefresh;
        this.dataPersister = dataType.getDataPersister();
        this.isForeign = isForeign;
        this.dataType = dataType;
        this.fieldType = fieldType;
        this.columnName = columnName;
        this.isId = isId;
        this.isGeneratedId = isGeneratedId;
        if ((this.isId || this.isGeneratedId) && this.isForeign) {
            throw new IllegalArgumentException("Id field " + fieldName + " cannot also be a foreign object");
        }
        try {
            this.assignDataType(this.dataPersister, configDefaultValue);
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
    }

    public String getFieldName() {
        return this.fieldName;
    }

    public String getColumnName() {
        return this.columnName;
    }

    public DataPersister getDataPersister() {
        return this.dataPersister;
    }

    public Object getDataTypeConfigObj() {
        return this.dataTypeConfigObj;
    }

    public SqlType getSqlType() {
        return this.fieldConverter.getSqlType();
    }

    public Object getDefaultValue() {
        return this.defaultValue;
    }

    public boolean isCanBeNull() {
        return this.canBeNull;
    }

    public Class getFieldType() {
        return this.fieldType;
    }

    public boolean isId() {
        return this.isId;
    }

    public boolean isGeneratedId() {
        return this.isGeneratedId;
    }

    public boolean isForeign() {
        return this.isForeign;
    }

    public Object convertJavaFieldToSqlArgValue(Object fieldVal) throws SQLException {
        if (fieldVal == null) {
            return null;
        }
        return this.fieldConverter.javaToSqlArg(this, fieldVal);
    }

    public boolean isEscapedValue() {
        return this.dataPersister.isEscapedValue();
    }

    public boolean isForeignAutoRefresh() {
        return this.foreignAutoRefresh;
    }

    public String getFormat() {
        return this.format;
    }

    public boolean isUnique() {
        return this.unique;
    }

    public boolean isUniqueCombo() {
        return this.uniqueCombo;
    }

    public String getIndexName() {
        return this.getIndexName(this.indexNameBase);
    }

    public String getIndexName(String indexNameBase) {
        if (this.index && TextUtils.isEmpty((CharSequence)this.indexName)) {
            this.indexName = this.findIndexName(indexNameBase);
        }
        return this.indexName;
    }

    public String getUniqueIndexName(String indexNameBase) {
        if (this.uniqueIndex && (this.uniqueIndexName == null || this.uniqueIndexName.equals(""))) {
            this.uniqueIndexName = this.findIndexName(indexNameBase);
        }
        return this.uniqueIndexName;
    }

    private String findIndexName(String indexNameBase) {
        if (this.columnName == null) {
            return indexNameBase + "_" + this.fieldName + "_idx";
        }
        return indexNameBase + "_" + this.columnName + "_idx";
    }

    public String getUniqueIndexName() {
        return this.getUniqueIndexName(this.indexNameBase);
    }

    public DataType getDataType() {
        return this.dataType;
    }

    public boolean isEscapedDefaultValue() {
        return this.dataPersister.isEscapedDefaultValue();
    }

    public boolean isComparable() throws SQLException {
        if (this.dataPersister == null) {
            throw new SQLException("Internal error.  Data-persister is not configured for field.  Please post _full_ exception with associated data objects to mailing list: " + this);
        }
        return this.dataPersister.isComparable();
    }

    public Object getJavaDefaultValueDefault() {
        if (this.dataType == null) {
            return null;
        }
        if (this.dataType == DataType.BOOLEAN) {
            return DEFAULT_VALUE_BOOLEAN;
        }
        if (this.dataType == DataType.BYTE || this.dataType == DataType.CHAR_OBJ) {
            return DEFAULT_VALUE_BYTE;
        }
        if (this.dataType == DataType.CHAR || this.dataType == DataType.CHAR_OBJ) {
            return Character.valueOf(DEFAULT_VALUE_CHAR);
        }
        if (this.dataType == DataType.SHORT || this.dataType == DataType.SHORT_OBJ) {
            return DEFAULT_VALUE_SHORT;
        }
        if (this.dataType == DataType.INTEGER || this.dataType == DataType.INTEGER_OBJ) {
            return DEFAULT_VALUE_INT;
        }
        if (this.dataType == DataType.LONG || this.dataType == DataType.LONG_OBJ) {
            return DEFAULT_VALUE_LONG;
        }
        if (this.dataType == DataType.FLOAT || this.dataType == DataType.FLOAT_OBJ) {
            return Float.valueOf(DEFAULT_VALUE_FLOAT);
        }
        if (this.dataType == DataType.DOUBLE || this.dataType == DataType.DOUBLE_OBJ) {
            return DEFAULT_VALUE_DOUBLE;
        }
        return null;
    }

    public String toString() {
        return this.getClass().getSimpleName() + ":name=" + this.fieldName + ",type=" + (Object)((Object)this.dataType);
    }

    private void assignDataType(DataPersister dataPersister, String defaultStr) throws SQLException {
        this.dataPersister = dataPersister = this.getDataPersister(dataPersister);
        this.fieldConverter = this.getFieldConverter(dataPersister);
        this.dataTypeConfigObj = dataPersister.makeConfigObject(this);
        if (defaultStr == null) {
            this.defaultValue = null;
        } else {
            if (this.isGeneratedId) {
                throw new SQLException("Field '" + this.fieldName + "' cannot be a generatedId and have a default value '" + defaultStr + "'");
            }
            this.defaultValue = this.fieldConverter.parseDefaultString(this, defaultStr);
        }
    }

    public DataPersister getDataPersister(DataPersister defaultPersister) {
        if (defaultPersister == null) {
            return null;
        }
        switch (defaultPersister.getSqlType()) {
            case DATE: {
                if (defaultPersister instanceof TimeStampType) {
                    return TimeStampStringType.getSingleton();
                }
                return DateStringType.getSingleton();
            }
        }
        return defaultPersister;
    }

    public FieldConverter getFieldConverter(DataPersister dataPersister) {
        switch (dataPersister.getSqlType()) {
            case BOOLEAN: {
                return booleanConverter;
            }
            case BIG_DECIMAL: {
                return BigDecimalStringType.getSingleton();
            }
        }
        return dataPersister;
    }

    static {
        booleanConverter = new BooleanNumberFieldConverter();
    }

    protected static class BooleanNumberFieldConverter
    extends BaseFieldConverter {
        protected BooleanNumberFieldConverter() {
        }

        @Override
        public SqlType getSqlType() {
            return SqlType.BOOLEAN;
        }

        @Override
        public Object parseDefaultString(FieldType fieldType, String defaultStr) {
            boolean bool = Boolean.parseBoolean(defaultStr);
            return bool ? Byte.valueOf((byte)1) : Byte.valueOf((byte)0);
        }

        @Override
        public Object javaToSqlArg(FieldType fieldType, Object obj) {
            Boolean bool = (Boolean)obj;
            return bool != false ? Byte.valueOf((byte)1) : Byte.valueOf((byte)0);
        }

        @Override
        public Object resultToSqlArg(FieldType fieldType, Cursor results, int columnPos) throws SQLException {
            return (byte)results.getShort(columnPos);
        }

        @Override
        public Object sqlArgToJava(FieldType fieldType, Object sqlArg, int columnPos) {
            byte arg = (Byte)sqlArg;
            return arg == 1;
        }

        @Override
        public Object resultToJava(FieldType fieldType, Cursor results, int columnPos) throws SQLException {
            return this.sqlArgToJava(fieldType, this.resultToSqlArg(fieldType, results, columnPos), columnPos);
        }
    }
}

