/*
 * Decompiled with CFR 0.152.
 */
package co.touchlab.squeaky.dao;

import co.touchlab.squeaky.dao.Dao;
import co.touchlab.squeaky.dao.ModelDao;
import co.touchlab.squeaky.db.SQLiteDatabase;
import co.touchlab.squeaky.db.SQLiteOpenHelper;
import co.touchlab.squeaky.field.FieldType;
import co.touchlab.squeaky.table.GeneratedTableMapper;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Map;

public class SqueakyContext {
    private final SQLiteOpenHelper helper;
    private final Map<Class, ModelDao> daoMap = new HashMap<Class, ModelDao>();
    private final Map<Class, GeneratedTableMapper> generatedTableMapperMap = new HashMap<Class, GeneratedTableMapper>();

    public SqueakyContext(SQLiteOpenHelper helper) {
        this.helper = helper;
    }

    public synchronized Dao getDao(Class clazz) {
        ModelDao dao = this.daoMap.get(clazz);
        if (dao == null) {
            dao = new ModelDao(this, clazz, this.getGeneratedTableMapper(clazz));
            this.daoMap.put(clazz, dao);
        }
        return dao;
    }

    public synchronized void close() {
        for (Dao dao : this.daoMap.values()) {
            ((ModelDao)dao).cleanUp();
        }
        this.daoMap.clear();
    }

    public synchronized GeneratedTableMapper getGeneratedTableMapper(Class clazz) {
        GeneratedTableMapper generatedTableMapper = this.generatedTableMapperMap.get(clazz);
        if (generatedTableMapper == null) {
            generatedTableMapper = SqueakyContext.loadGeneratedTableMapper(clazz);
            this.generatedTableMapperMap.put(clazz, generatedTableMapper);
        }
        return generatedTableMapper;
    }

    public SQLiteDatabase getDatabase() {
        return this.helper.getWrappedDatabase();
    }

    public FieldType findFieldType(Class c, String columnFieldName) throws SQLException {
        FieldType[] fieldTypes;
        GeneratedTableMapper generatedTableMapper = this.getGeneratedTableMapper(c);
        for (FieldType fieldType : fieldTypes = generatedTableMapper.getTableConfig().getFieldTypes()) {
            if (!fieldType.getFieldName().equalsIgnoreCase(columnFieldName) && !fieldType.getColumnName().equalsIgnoreCase(columnFieldName)) continue;
            return fieldType;
        }
        throw new SQLException("No field type found for " + columnFieldName);
    }

    public static GeneratedTableMapper loadGeneratedTableMapper(Class clazz) {
        try {
            return (GeneratedTableMapper)Class.forName(clazz.getName() + "$$Configuration").newInstance();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

