/*
 * Decompiled with CFR 0.152.
 */
package co.touchlab.squeaky.dao;

import android.database.Cursor;
import co.touchlab.squeaky.dao.CloseableIterator;
import co.touchlab.squeaky.dao.Dao;
import co.touchlab.squeaky.dao.ModelDao;
import co.touchlab.squeaky.table.GeneratedTableMapper;
import co.touchlab.squeaky.table.TransientCache;
import java.io.IOException;
import java.sql.SQLException;

public class SelectIterator<T>
implements CloseableIterator<T> {
    private final Cursor cursor;
    private final ModelDao<T> modelDao;
    private final GeneratedTableMapper<T> generatedTableMapper;
    private final TransientCache objectCache = new TransientCache();
    private final Dao.ForeignRefresh[] foreignRefreshMap;

    public SelectIterator(Cursor cursor, ModelDao<T> modelDao, Dao.ForeignRefresh[] foreignRefreshMap) {
        this.cursor = cursor;
        this.modelDao = modelDao;
        this.foreignRefreshMap = foreignRefreshMap;
        this.generatedTableMapper = modelDao.getGeneratedTableMapper();
    }

    @Override
    public void closeQuietly() {
        try {
            this.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public void moveToNext() {
        this.cursor.moveToNext();
    }

    @Override
    public T first() throws SQLException {
        return this.cursor.moveToFirst() ? (T)this.makeData() : null;
    }

    @Override
    public T previous() throws SQLException {
        return this.cursor.moveToPrevious() ? (T)this.makeData() : null;
    }

    @Override
    public T current() throws SQLException {
        return this.makeData();
    }

    @Override
    public T nextThrow() throws SQLException {
        return this.cursor.moveToNext() ? (T)this.makeData() : null;
    }

    @Override
    public T moveRelative(int offset) throws SQLException {
        return this.cursor.move(offset) ? (T)this.makeData() : null;
    }

    @Override
    public void close() throws IOException {
        this.cursor.close();
    }

    @Override
    public boolean hasNext() {
        boolean next = this.cursor.moveToNext();
        this.cursor.moveToPrevious();
        return next;
    }

    @Override
    public T next() {
        try {
            return this.nextThrow();
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException("Can't remove from cursor");
    }

    private T makeData() throws SQLException {
        T data = this.generatedTableMapper.createObject(this.cursor);
        this.generatedTableMapper.fillRow(data, this.cursor, this.modelDao, this.foreignRefreshMap, this.objectCache);
        return data;
    }
}

