/*
 * Decompiled with CFR 0.152.
 */
package co.touchlab.squeaky.dao;

import android.content.ContentValues;
import android.database.Cursor;
import android.database.sqlite.SQLiteException;
import android.text.TextUtils;
import co.touchlab.squeaky.dao.CloseableIterator;
import co.touchlab.squeaky.dao.Dao;
import co.touchlab.squeaky.dao.DaoHelper;
import co.touchlab.squeaky.dao.Query;
import co.touchlab.squeaky.dao.SelectIterator;
import co.touchlab.squeaky.dao.SqueakyContext;
import co.touchlab.squeaky.db.SQLiteDatabase;
import co.touchlab.squeaky.db.SQLiteStatement;
import co.touchlab.squeaky.field.FieldType;
import co.touchlab.squeaky.field.ForeignCollectionInfo;
import co.touchlab.squeaky.sql.SqlHelper;
import co.touchlab.squeaky.table.GeneratedTableMapper;
import co.touchlab.squeaky.table.TableInfo;
import co.touchlab.squeaky.table.TableUtils;
import co.touchlab.squeaky.table.TransientCache;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;

public class ModelDao<T>
implements Dao<T> {
    public static final String DEFAULT_TABLE_PREFIX = "t";
    public static final String EQ_OPERATION = "= ?";
    private final Class<T> entityClass;
    private final GeneratedTableMapper<T> generatedTableMapper;
    private final Set<Dao.DaoObserver> daoObserverSet = Collections.newSetFromMap(new ConcurrentHashMap());
    private final String[] tableCols;
    private final SqueakyContext squeakyContext;
    private final FieldType idFieldType;
    private final List<SQLiteStatement> statementList = Collections.synchronizedList(new ArrayList());
    private ThreadLocal<SQLiteStatement> createStatement = new ThreadLocal<SQLiteStatement>(){

        @Override
        protected SQLiteStatement initialValue() {
            SQLiteStatement sqLiteStatement = ModelDao.this.makeCreateStatement();
            ModelDao.this.statementList.add(sqLiteStatement);
            return sqLiteStatement;
        }
    };
    private ThreadLocal<SQLiteStatement> updateStatement = new ThreadLocal<SQLiteStatement>(){

        @Override
        protected SQLiteStatement initialValue() {
            SQLiteStatement sqLiteStatement = ModelDao.this.makeUpdateStatement();
            ModelDao.this.statementList.add(sqLiteStatement);
            return sqLiteStatement;
        }
    };

    protected ModelDao(SqueakyContext openHelper, Class<T> entityClass, GeneratedTableMapper<T> generatedTableMapper) {
        this.squeakyContext = openHelper;
        this.entityClass = entityClass;
        try {
            FieldType[] fieldTypes;
            this.generatedTableMapper = generatedTableMapper;
            FieldType idField = null;
            for (FieldType fieldType : fieldTypes = generatedTableMapper.getTableConfig().getFieldTypes()) {
                if (!fieldType.isId() && !fieldType.isGeneratedId()) continue;
                idField = fieldType;
                break;
            }
            this.idFieldType = idField;
            this.tableCols = this.buildSelect();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public void cleanUp() {
        for (SQLiteStatement sqLiteStatement : this.statementList) {
            sqLiteStatement.close();
        }
    }

    private String[] buildSelect() throws SQLException {
        FieldType[] fieldTypes = this.generatedTableMapper.getTableConfig().getFieldTypes();
        String[] selectList = new String[fieldTypes.length];
        for (int i = 0; i < fieldTypes.length; ++i) {
            selectList[i] = "t." + fieldTypes[i].getColumnName();
        }
        return selectList;
    }

    @Override
    public T queryForId(Object id) throws SQLException {
        List<T> tList = this.queryForEq(this.idFieldType.getColumnName(), id).list();
        return tList.size() == 0 ? null : (T)tList.get(0);
    }

    @Override
    public Dao.QueryModifiers<T> queryForAll() throws SQLException {
        return new QueryModifiersImpl(this.createDefaultFrom(), null, null);
    }

    @Override
    public Dao.QueryModifiers<T> queryForEq(String fieldName, Object value) throws SQLException {
        ArrayList<String> params = new ArrayList<String>();
        Class dataClass = this.generatedTableMapper.getTableConfig().dataClass;
        FieldType fieldType = this.squeakyContext.findFieldType(dataClass, fieldName);
        SqlHelper.appendArgOrValue(this.squeakyContext, fieldType, params, value);
        StringBuilder sb = new StringBuilder();
        SqlHelper.appendWhereClauseBody(sb, DEFAULT_TABLE_PREFIX, EQ_OPERATION, fieldType);
        return new QueryModifiersImpl(this.createDefaultFrom(), sb.toString(), params.toArray(new String[params.size()]));
    }

    @Override
    public Dao.QueryModifiers<T> queryForFieldValues(Map<String, Object> fieldValues) throws SQLException {
        StringBuilder query = new StringBuilder();
        ArrayList<String> params = new ArrayList<String>();
        for (String field : fieldValues.keySet()) {
            if (query.length() > 0) {
                query.append(" and ");
            }
            Class dataClass = this.generatedTableMapper.getTableConfig().dataClass;
            FieldType fieldType = this.squeakyContext.findFieldType(dataClass, field);
            SqlHelper.appendWhereClauseBody(query, DEFAULT_TABLE_PREFIX, EQ_OPERATION, fieldType);
            SqlHelper.appendArgOrValue(this.squeakyContext, fieldType, params, fieldValues.get(field));
        }
        return new QueryModifiersImpl(this.createDefaultFrom(), query.toString(), params.toArray(new String[params.size()]));
    }

    private String createDefaultFrom() throws SQLException {
        StringBuilder sb = new StringBuilder();
        sb.append(this.generatedTableMapper.getTableConfig().getTableName());
        sb.append(' ');
        sb.append(DEFAULT_TABLE_PREFIX);
        return sb.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<T> makeCursorResults(String from, String where, String[] args, String orderBy, Integer limit, Integer offset, Dao.ForeignRefresh[] foreignRefreshMap) throws SQLException {
        ArrayList<T> results = new ArrayList<T>();
        TransientCache objectCache = new TransientCache();
        try (Cursor cursor = this.makeCursor(from, where, args, orderBy, limit, offset);){
            if (cursor.moveToFirst()) {
                do {
                    T object = this.generatedTableMapper.createObject(cursor);
                    this.generatedTableMapper.fillRow(object, cursor, this, foreignRefreshMap, objectCache);
                    results.add(object);
                } while (cursor.moveToNext());
            }
        }
        return results;
    }

    private Cursor makeCursor(String from, String where, String[] args, String orderBy, Integer limit, Integer offset) {
        StringBuilder sb = new StringBuilder();
        sb.append("select ").append(TextUtils.join((CharSequence)",", (Object[])this.tableCols)).append(" from ").append(from);
        if (!TextUtils.isEmpty((CharSequence)where)) {
            sb.append(" where ").append(where);
        }
        if (!TextUtils.isEmpty((CharSequence)orderBy)) {
            sb.append(" order by ").append(orderBy);
        }
        if (limit != null) {
            sb.append(" limit ").append(limit);
        }
        if (offset != null) {
            sb.append(" offset ").append(offset);
        }
        String sql = sb.toString();
        return this.squeakyContext.getDatabase().rawQuery(sql, args);
    }

    @Override
    public Dao.QueryModifiers<T> query(String where, String[] args) throws SQLException {
        return new QueryModifiersImpl(this.createDefaultFrom(), where, args);
    }

    @Override
    public Dao.QueryModifiers<T> query(Query where) throws SQLException {
        return new QueryModifiersImpl(where.getFromStatement(true), where.getWhereStatement(true), where.getParameters());
    }

    @Override
    public void create(T data) throws SQLException {
        SQLiteStatement sqLiteStatement = this.createStatement.get();
        this.generatedTableMapper.bindCreateVals(sqLiteStatement, data);
        try {
            long newRowId = sqLiteStatement.executeInsert();
            if (this.idFieldType != null && this.idFieldType.isGeneratedId()) {
                this.generatedTableMapper.assignId(data, newRowId);
            }
            this.notifyChanges();
        }
        catch (SQLiteException e) {
            throw new SQLException("create failed", e);
        }
    }

    private SQLiteStatement makeCreateStatement() {
        try {
            SQLiteDatabase db = this.squeakyContext.getDatabase();
            TableInfo<T> tableConfig = this.generatedTableMapper.getTableConfig();
            StringBuilder sb = new StringBuilder();
            sb.append("insert into ");
            sb.append(tableConfig.getTableName());
            sb.append("(");
            boolean first = true;
            StringBuilder args = new StringBuilder();
            for (FieldType fieldType : this.generatedTableMapper.getTableConfig().getFieldTypes()) {
                if (fieldType.isGeneratedId()) continue;
                if (!first) {
                    sb.append(",");
                    args.append(",");
                }
                sb.append(fieldType.getColumnName());
                args.append("?");
                first = false;
            }
            sb.append(")values(").append(args.toString()).append(")");
            return db.compileStatement(sb.toString());
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
    }

    private void fillContentVal(ContentValues values, FieldType fieldType, Object val) {
        if (val instanceof String) {
            values.put(fieldType.getColumnName(), (String)val);
        } else if (val instanceof Integer) {
            values.put(fieldType.getColumnName(), (Integer)val);
        } else if (val instanceof Long) {
            values.put(fieldType.getColumnName(), (Long)val);
        } else if (val instanceof Byte) {
            values.put(fieldType.getColumnName(), (Byte)val);
        } else if (val instanceof Short) {
            values.put(fieldType.getColumnName(), (Short)val);
        } else if (val instanceof Float) {
            values.put(fieldType.getColumnName(), (Float)val);
        } else if (val instanceof Double) {
            values.put(fieldType.getColumnName(), (Double)val);
        } else if (val instanceof Boolean) {
            values.put(fieldType.getColumnName(), (Boolean)val);
        } else if (val instanceof byte[]) {
            values.put(fieldType.getColumnName(), (byte[])val);
        } else {
            throw new IllegalArgumentException("Don't recognize type for: " + val);
        }
    }

    @Override
    public T createIfNotExists(T data) throws SQLException {
        if (data == null) {
            return null;
        }
        T existing = this.queryForId(this.generatedTableMapper.extractId(data));
        if (existing == null) {
            this.create(data);
            return data;
        }
        return existing;
    }

    @Override
    public void createOrUpdate(T data) throws SQLException {
        Object id = this.extractId(data);
        if (id == null || !this.idExists(id)) {
            this.create(data);
        } else {
            this.update(data);
        }
    }

    @Override
    public void update(T data) throws SQLException {
        SQLiteStatement us = this.updateStatement.get();
        this.generatedTableMapper.bindVals(us, data);
        us.executeUpdateDelete();
        this.notifyChanges();
    }

    private SQLiteStatement makeUpdateStatement() {
        try {
            SQLiteDatabase db = this.squeakyContext.getDatabase();
            TableInfo<T> tableConfig = this.generatedTableMapper.getTableConfig();
            StringBuilder sb = new StringBuilder();
            sb.append("update ").append(tableConfig.getTableName()).append(" set ");
            boolean first = true;
            for (FieldType fieldType : this.generatedTableMapper.getTableConfig().getFieldTypes()) {
                if (fieldType.isGeneratedId() || fieldType.isId()) continue;
                if (!first) {
                    sb.append(",");
                }
                sb.append(fieldType.getColumnName()).append(" = ?");
                first = false;
            }
            sb.append(" where ").append(this.generatedTableMapper.getTableConfig().idField.getColumnName()).append(" = ?");
            return db.compileStatement(sb.toString());
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public int updateId(T data, Object newId) throws SQLException {
        SQLiteDatabase db = this.squeakyContext.getDatabase();
        ContentValues values = new ContentValues();
        this.fillContentVal(values, this.idFieldType, newId);
        int result = db.update(this.generatedTableMapper.getTableConfig().getTableName(), values, this.idFieldType.getColumnName() + " = ?", new String[]{this.generatedTableMapper.extractId(data).toString()});
        this.notifyChanges();
        return result;
    }

    @Override
    public int update(Query where, Map<String, Object> valueMap) throws SQLException {
        SQLiteDatabase db = this.squeakyContext.getDatabase();
        ContentValues values = new ContentValues();
        for (String fieldKey : valueMap.keySet()) {
            FieldType fieldType = this.squeakyContext.findFieldType(this.generatedTableMapper.getTableConfig().dataClass, fieldKey);
            this.fillContentVal(values, fieldType, SqlHelper.pullArgOrValue(this.squeakyContext, fieldType, valueMap.get(fieldKey)));
        }
        int result = db.update(this.generatedTableMapper.getTableConfig().getTableName(), values, where.getWhereStatement(false), where.getParameters());
        this.notifyChanges();
        return result;
    }

    @Override
    public void refresh(T data) throws SQLException {
        this.refresh(data, this.generateDefaultForeignRefreshMap());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void refresh(T data, Dao.ForeignRefresh[] foreignRefreshMap) throws SQLException {
        try (Cursor cursor = this.makeCursor(this.createDefaultFrom(), this.idFieldType.getColumnName() + " = ?", new String[]{this.generatedTableMapper.extractId(data).toString()}, null, null, null);){
            if (cursor.moveToFirst()) {
                do {
                    this.generatedTableMapper.fillRow(data, cursor, this, foreignRefreshMap, null);
                } while (cursor.moveToNext());
            }
        }
    }

    @Override
    public int delete(T data) throws SQLException {
        return data == null ? 0 : this.deleteById(this.generatedTableMapper.extractId(data));
    }

    @Override
    public int deleteById(Object id) throws SQLException {
        int result = this.squeakyContext.getDatabase().delete(this.generatedTableMapper.getTableConfig().getTableName(), this.idFieldType.getColumnName() + EQ_OPERATION, new String[]{id.toString()});
        this.notifyChanges();
        return result;
    }

    @Override
    public int delete(Collection<T> datas) throws SQLException {
        ArrayList<Object> ids = new ArrayList<Object>(datas.size());
        for (T data : datas) {
            ids.add(this.generatedTableMapper.extractId(data));
        }
        return this.deleteIds(ids);
    }

    @Override
    public int deleteIds(Collection<Object> ids) throws SQLException {
        final StringBuilder sb = new StringBuilder();
        sb.append(this.idFieldType.getColumnName()).append(" in (");
        boolean first = true;
        for (Object id : ids) {
            if (first) {
                first = false;
            } else {
                sb.append(',');
            }
            if (this.idFieldType.isEscapedValue()) {
                TableUtils.appendEscapedWord(sb, id.toString());
                continue;
            }
            sb.append(id.toString());
        }
        sb.append(")");
        return this.delete(new Query(){

            @Override
            public String getWhereStatement(boolean joinsAllowed) {
                return sb.toString();
            }

            @Override
            public String[] getParameters() throws SQLException {
                return null;
            }

            @Override
            public String getFromStatement(boolean joinsAllowed) throws SQLException {
                return ModelDao.this.generatedTableMapper.getTableConfig().getTableName();
            }
        });
    }

    @Override
    public int delete(Query where) throws SQLException {
        long result = this.squeakyContext.getDatabase().delete(where.getFromStatement(false), where.getWhereStatement(false), where.getParameters());
        this.notifyChanges();
        return (int)result;
    }

    @Override
    public CloseableIterator<T> iterator() throws SQLException {
        return new SelectIterator(this.makeCursor(this.createDefaultFrom(), null, null, null, null, null), this, this.generateDefaultForeignRefreshMap());
    }

    private Dao.ForeignRefresh[] generateDefaultForeignRefreshMap() throws SQLException {
        return DaoHelper.fillForeignRefreshMap(this.squeakyContext, this.generatedTableMapper.getTableConfig().getFieldTypes(), 2);
    }

    @Override
    public CloseableIterator<T> iterator(Query where) throws SQLException {
        return new SelectIterator(this.makeCursor(where.getFromStatement(true), where.getWhereStatement(true), where.getParameters(), null, null, null), this, this.generateDefaultForeignRefreshMap());
    }

    @Override
    public long queryRawValue(String query, String ... arguments) throws SQLException {
        return this.squeakyContext.getDatabase().longForQuery(query, arguments);
    }

    @Override
    public String objectToString(T data) throws SQLException {
        return this.generatedTableMapper.objectToString(data);
    }

    @Override
    public boolean objectsEqual(T data1, T data2) throws SQLException {
        return this.generatedTableMapper.objectsEqual(data1, data2);
    }

    @Override
    public Object extractId(T data) throws SQLException {
        return this.generatedTableMapper.extractId(data);
    }

    @Override
    public void fillForeignCollection(T data, String fieldName) throws SQLException {
        this.generatedTableMapper.fillForeignCollection(data, this, fieldName);
    }

    @Override
    public Class<T> getDataClass() {
        return this.entityClass;
    }

    @Override
    public boolean isUpdatable() {
        return true;
    }

    @Override
    public long countOf() throws SQLException {
        return this.squeakyContext.getDatabase().countOf(this.generatedTableMapper.getTableConfig().getTableName());
    }

    @Override
    public long countOf(Query where) throws SQLException {
        return this.squeakyContext.getDatabase().countOf(where);
    }

    @Override
    public boolean idExists(Object id) throws SQLException {
        return this.queryForId(id) != null;
    }

    @Override
    public void registerObserver(Dao.DaoObserver observer) {
        this.daoObserverSet.add(observer);
    }

    @Override
    public void unregisterObserver(Dao.DaoObserver observer) {
        this.daoObserverSet.remove(observer);
    }

    @Override
    public void notifyChanges() {
        for (Dao.DaoObserver next : this.daoObserverSet) {
            next.onChange();
        }
    }

    @Override
    public Query all() {
        return new Query(){

            @Override
            public String getFromStatement(boolean joinsAllowed) throws SQLException {
                StringBuilder sb = new StringBuilder();
                sb.append(ModelDao.this.generatedTableMapper.getTableConfig().getTableName());
                if (joinsAllowed) {
                    sb.append(" ").append(ModelDao.DEFAULT_TABLE_PREFIX);
                }
                return sb.toString();
            }

            @Override
            public String getWhereStatement(boolean joinsAllowed) throws SQLException {
                return null;
            }

            @Override
            public String[] getParameters() throws SQLException {
                return null;
            }
        };
    }

    public GeneratedTableMapper<T> getGeneratedTableMapper() {
        return this.generatedTableMapper;
    }

    public SqueakyContext getOpenHelper() {
        return this.squeakyContext;
    }

    public ForeignCollectionInfo findForeignCollectionInfo(String name) throws SQLException {
        for (ForeignCollectionInfo foreignCollectionInfo : this.generatedTableMapper.getTableConfig().getForeignCollections()) {
            if (!name.equals(foreignCollectionInfo.variableName)) continue;
            return foreignCollectionInfo;
        }
        throw new SQLException("Couldn't find foreign collection children");
    }

    class QueryModifiersImpl
    implements Dao.QueryModifiers<T> {
        private final String from;
        private final String where;
        private final String[] args;
        private String orderBy;
        private Integer limit;
        private Integer offset;
        private Dao.ForeignRefresh[] foreignRefreshMap;

        public QueryModifiersImpl(String from, String where, String[] args) {
            this.from = from;
            this.where = where;
            this.args = args;
        }

        @Override
        public Dao.QueryModifiers<T> orderBy(String s) {
            this.orderBy = s;
            return this;
        }

        @Override
        public Dao.QueryModifiers<T> limit(Integer i) {
            this.limit = i;
            return this;
        }

        @Override
        public Dao.QueryModifiers<T> offset(Integer i) {
            this.offset = i;
            return this;
        }

        @Override
        public Dao.QueryModifiers<T> foreignRefreshMap(Dao.ForeignRefresh[] foreignRefreshMap) {
            this.foreignRefreshMap = foreignRefreshMap;
            return this;
        }

        @Override
        public List<T> list() throws SQLException {
            return ModelDao.this.makeCursorResults(this.from, this.where, this.args, this.orderBy, this.limit, this.offset, this.foreignRefreshMap == null ? ModelDao.this.generateDefaultForeignRefreshMap() : this.foreignRefreshMap);
        }
    }
}

