/*
 * Decompiled with CFR 0.152.
 */
package co.touchlab.squeaky.dao;

import co.touchlab.squeaky.dao.CloseableIterator;
import co.touchlab.squeaky.dao.Query;
import java.sql.SQLException;
import java.util.Collection;
import java.util.List;
import java.util.Map;

public interface Dao<T> {
    public T queryForId(Object var1) throws SQLException;

    public QueryModifiers<T> queryForAll() throws SQLException;

    public QueryModifiers<T> queryForEq(String var1, Object var2) throws SQLException;

    public QueryModifiers<T> queryForFieldValues(Map<String, Object> var1) throws SQLException;

    public QueryModifiers<T> query(Query var1) throws SQLException;

    public QueryModifiers<T> query(String var1, String[] var2) throws SQLException;

    public void create(T var1) throws SQLException;

    public T createIfNotExists(T var1) throws SQLException;

    public void createOrUpdate(T var1) throws SQLException;

    public void update(T var1) throws SQLException;

    public int updateId(T var1, Object var2) throws SQLException;

    public int update(Query var1, Map<String, Object> var2) throws SQLException;

    public void refresh(T var1) throws SQLException;

    public void refresh(T var1, ForeignRefresh[] var2) throws SQLException;

    public int delete(T var1) throws SQLException;

    public int deleteById(Object var1) throws SQLException;

    public int delete(Collection<T> var1) throws SQLException;

    public int deleteIds(Collection<Object> var1) throws SQLException;

    public int delete(Query var1) throws SQLException;

    public CloseableIterator<T> iterator() throws SQLException;

    public CloseableIterator<T> iterator(Query var1) throws SQLException;

    public long queryRawValue(String var1, String ... var2) throws SQLException;

    public String objectToString(T var1) throws SQLException;

    public boolean objectsEqual(T var1, T var2) throws SQLException;

    public Object extractId(T var1) throws SQLException;

    public void fillForeignCollection(T var1, String var2) throws SQLException;

    public Class<T> getDataClass();

    public boolean isUpdatable();

    public long countOf() throws SQLException;

    public long countOf(Query var1) throws SQLException;

    public boolean idExists(Object var1) throws SQLException;

    public void registerObserver(DaoObserver var1);

    public void unregisterObserver(DaoObserver var1);

    public void notifyChanges();

    public Query all();

    public static interface DaoObserver {
        public void onChange();
    }

    public static interface QueryModifiers<T> {
        public QueryModifiers<T> orderBy(String var1);

        public QueryModifiers<T> limit(Integer var1);

        public QueryModifiers<T> offset(Integer var1);

        public QueryModifiers<T> foreignRefreshMap(ForeignRefresh[] var1);

        public List<T> list() throws SQLException;
    }

    public static class ForeignRefresh {
        public final String field;
        public final ForeignRefresh[] refreshFields;

        public ForeignRefresh(String field) {
            this(field, null);
        }

        public ForeignRefresh(String field, ForeignRefresh[] refreshFields) {
            this.field = field;
            this.refreshFields = refreshFields;
        }
    }
}

