/*
 * Decompiled with CFR 0.152.
 */
package co.ronash.pushe.analytics;

import co.ronash.pushe.analytics.event.Ecommerce;
import co.ronash.pushe.analytics.event.Event;
import co.ronash.pushe.analytics.event.EventAction;
import co.ronash.pushe.analytics.messages.upstream.EcommerceMessage;
import co.ronash.pushe.analytics.messages.upstream.EventMessage;
import co.ronash.pushe.internal.PusheServiceApi;
import co.ronash.pushe.messaging.PostOffice;
import co.ronash.pushe.messaging.SendPriority;
import co.ronash.pushe.messaging.SendableUpstreamMessage;
import javax.inject.Inject;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u000f\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u000e\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bJ\u0016\u0010\u0005\u001a\u00020\u00062\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fJ\u000e\u0010\r\u001a\u00020\u00062\u0006\u0010\u000e\u001a\u00020\u000fJ\u000e\u0010\r\u001a\u00020\u00062\u0006\u0010\t\u001a\u00020\nR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lco/ronash/pushe/analytics/PusheAnalytics;", "Lco/ronash/pushe/internal/PusheServiceApi;", "postOffice", "Lco/ronash/pushe/messaging/PostOffice;", "(Lco/ronash/pushe/messaging/PostOffice;)V", "sendEcommerceData", "", "ecommerce", "Lco/ronash/pushe/analytics/event/Ecommerce;", "name", "", "price", "", "sendEvent", "event", "Lco/ronash/pushe/analytics/event/Event;", "analytics_release"})
public final class PusheAnalytics
implements PusheServiceApi {
    private final PostOffice postOffice;

    public final void sendEvent(@NotNull Event event) {
        Intrinsics.checkParameterIsNotNull((Object)event, (String)"event");
        String string = event.getName();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"event.name");
        String string2 = event.getAction().toString();
        Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"event.action.toString()");
        this.postOffice.sendMessage((SendableUpstreamMessage)new EventMessage(string, string2), SendPriority.SOON);
    }

    public final void sendEvent(@NotNull String name) {
        Intrinsics.checkParameterIsNotNull((Object)name, (String)"name");
        String string = EventAction.CUSTOM.toString();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"EventAction.CUSTOM.toString()");
        this.postOffice.sendMessage((SendableUpstreamMessage)new EventMessage(name, string), SendPriority.SOON);
    }

    public final void sendEcommerceData(@NotNull Ecommerce ecommerce) {
        Intrinsics.checkParameterIsNotNull((Object)ecommerce, (String)"ecommerce");
        String string = ecommerce.getName();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"ecommerce.name");
        Double d2 = ecommerce.getPrice();
        Intrinsics.checkExpressionValueIsNotNull((Object)d2, (String)"ecommerce.price");
        this.postOffice.sendMessage((SendableUpstreamMessage)new EcommerceMessage(string, d2, ecommerce.getCategory(), ecommerce.getQuantity()), SendPriority.SOON);
    }

    public final void sendEcommerceData(@NotNull String name, double price) {
        Intrinsics.checkParameterIsNotNull((Object)name, (String)"name");
        this.postOffice.sendMessage((SendableUpstreamMessage)new EcommerceMessage(name, price, null, null), SendPriority.SOON);
    }

    @Inject
    public PusheAnalytics(@NotNull PostOffice postOffice) {
        Intrinsics.checkParameterIsNotNull((Object)postOffice, (String)"postOffice");
        this.postOffice = postOffice;
    }
}

