package co.ronash.pushe.analytics.utils

import com.f2prateek.rx.preferences2.Preference
import com.squareup.moshi.JsonAdapter

class PreferenceConverter<T> constructor (
    private val moshiAdapter: JsonAdapter<T>
): Preference.Converter<T> {

    override fun deserialize(serialized: String): T {
        val t = moshiAdapter.fromJson(serialized)
        return t!!
    }

    override fun serialize(value: T): String {
        return moshiAdapter.toJson(value)
    }

}