package co.ronash.pushe.analytics

import android.app.Application
import android.content.Context
import co.ronash.pushe.LogTag
import co.ronash.pushe.Pushe
import co.ronash.pushe.analytics.dagger.AnalyticsComponent
import co.ronash.pushe.analytics.dagger.DaggerAnalyticsComponent
import co.ronash.pushe.dagger.CoreComponent
import co.ronash.pushe.internal.ComponentNotAvailableException
import co.ronash.pushe.internal.PusheComponentInitializer
import co.ronash.pushe.internal.PusheInternals
import co.ronash.pushe.utils.log.Plog


class AnalyticsInitializer : PusheComponentInitializer() {
    private lateinit var analyticsComponent: AnalyticsComponent

    override fun preInitialize(context: Context) {
        Plog[LogTag.T_INIT].trace("Initializing Pushe analytics component")

        val core = PusheInternals.getComponent(CoreComponent::class.java)
                ?: throw ComponentNotAvailableException(Pushe.CORE)

        analyticsComponent = DaggerAnalyticsComponent.builder()
            .coreComponent(core)
            .build()

        /* Extend Moshi */
        extendMoshi(analyticsComponent.moshi())

        /* Receive messages */
        analyticsComponent.messageDispatcher().listenForMessages()

        PusheInternals.registerComponent(Pushe.ANALYTICS, AnalyticsComponent::class.java, analyticsComponent)
        PusheInternals.registerApi(Pushe.ANALYTICS, PusheAnalytics::class.java, analyticsComponent.api())

        analyticsComponent.appLifeCycleListener().registerEndSessionListener()

        ((analyticsComponent.context().applicationContext) as Application)
            .registerActivityLifecycleCallbacks(analyticsComponent.appLifeCycleListener())

    }

    override fun postInitialize(context: Context) {
        analyticsComponent.goalProcessManager().initialize()
    }
}