/*
 * Decompiled with CFR 0.152.
 */
package co.pushe.plus.utils.log;

import android.util.Log;
import co.pushe.plus.utils.log.LogHandler;
import co.pushe.plus.utils.log.LogLevel;
import co.pushe.plus.utils.log.LogcatLogHandler$WhenMappings;
import co.pushe.plus.utils.log.Plogger;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B'\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\tJ\u0014\u0010\n\u001a\u00020\u000b2\n\u0010\f\u001a\u00060\rR\u00020\u000eH\u0016R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0004\u001a\u0004\u0018\u00010\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lco/pushe/plus/utils/log/LogcatLogHandler;", "Lco/pushe/plus/utils/log/LogHandler;", "logTag", "", "level", "Lco/pushe/plus/utils/log/LogLevel;", "includeLogData", "", "useFullTags", "(Ljava/lang/String;Lco/pushe/plus/utils/log/LogLevel;ZZ)V", "onLog", "", "logItem", "Lco/pushe/plus/utils/log/Plogger$LogItem;", "Lco/pushe/plus/utils/log/Plogger;", "utils_release"})
public final class LogcatLogHandler
implements LogHandler {
    private final String logTag;
    private final LogLevel level;
    private final boolean includeLogData;
    private final boolean useFullTags;

    @Override
    public void onLog(@NotNull Plogger.LogItem logItem) {
        String nonNullTag;
        block29: {
            block28: {
                Intrinsics.checkParameterIsNotNull((Object)logItem, (String)"logItem");
                if (this.level == null) break block28;
                LogLevel logLevel = logItem.getLogCatLevel();
                if (logLevel == null) {
                    logLevel = logItem.getLevel();
                }
                if (this.level.compareTo((Enum)logLevel) <= 0) break block29;
            }
            return;
        }
        String string = nonNullTag = !this.useFullTags ? this.logTag : this.logTag + " " + CollectionsKt.joinToString$default((Iterable)logItem.getTags(), (CharSequence)" , ", null, null, (int)0, null, null, (int)62, null);
        if (nonNullTag.length() > 23) {
            String string2 = nonNullTag;
            int n = 0;
            int n2 = 23;
            String string3 = string2;
            if (string3 == null) {
                throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
            }
            String string4 = string3.substring(n, n2);
            Intrinsics.checkExpressionValueIsNotNull((Object)string4, (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
            nonNullTag = string4;
        }
        String message = logItem.getMessage();
        Throwable t = logItem.getThrowable();
        if (this.includeLogData) {
            message = Intrinsics.stringPlus((String)message, (Object)("  " + logItem.getLogData()));
        }
        if (t == null) {
            LogLevel logLevel = logItem.getLogCatLevel();
            if (logLevel == null) {
                logLevel = logItem.getLevel();
            }
            switch (LogcatLogHandler$WhenMappings.$EnumSwitchMapping$0[logLevel.ordinal()]) {
                case 1: {
                    Log.v((String)nonNullTag, (String)message);
                    break;
                }
                case 2: {
                    Log.d((String)nonNullTag, (String)message);
                    break;
                }
                case 3: {
                    Log.i((String)nonNullTag, (String)message);
                    break;
                }
                case 4: {
                    Log.w((String)nonNullTag, (String)message);
                    break;
                }
                case 5: {
                    Log.e((String)nonNullTag, (String)message);
                    break;
                }
                case 6: {
                    Log.wtf((String)nonNullTag, (String)message);
                }
            }
        } else {
            LogLevel logLevel = logItem.getLogCatLevel();
            if (logLevel == null) {
                logLevel = logItem.getLevel();
            }
            switch (LogcatLogHandler$WhenMappings.$EnumSwitchMapping$1[logLevel.ordinal()]) {
                case 1: {
                    Log.v((String)nonNullTag, (String)message, (Throwable)t);
                    break;
                }
                case 2: {
                    Log.d((String)nonNullTag, (String)message, (Throwable)t);
                    break;
                }
                case 3: {
                    Log.i((String)nonNullTag, (String)message, (Throwable)t);
                    break;
                }
                case 4: {
                    Log.w((String)nonNullTag, (String)message, (Throwable)t);
                    break;
                }
                case 5: {
                    Log.e((String)nonNullTag, (String)message, (Throwable)t);
                    break;
                }
                case 6: {
                    if (message == null) {
                        Log.wtf((String)nonNullTag, (Throwable)t);
                        break;
                    }
                    Log.wtf((String)nonNullTag, (String)message, (Throwable)t);
                }
            }
        }
    }

    public LogcatLogHandler(@NotNull String logTag, @Nullable LogLevel level, boolean includeLogData, boolean useFullTags) {
        Intrinsics.checkParameterIsNotNull((Object)logTag, (String)"logTag");
        this.logTag = logTag;
        this.level = level;
        this.includeLogData = includeLogData;
        this.useFullTags = useFullTags;
    }
}

