/*
 * Decompiled with CFR 0.152.
 */
package co.omise.android.ui;

import android.os.Build;
import android.os.Bundle;
import android.os.Parcelable;
import android.view.View;
import android.widget.LinearLayout;
import co.omise.android.R;
import co.omise.android.models.BackendType;
import co.omise.android.models.PaymentMethod;
import co.omise.android.models.PaymentMethodKt;
import co.omise.android.models.SourceType;
import co.omise.android.ui.InstallmentResource;
import co.omise.android.ui.OmiseListFragment;
import co.omise.android.ui.PaymentCreatorNavigation;
import co.omise.android.ui.PaymentMethodResourcesKt;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\t\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u0000 '2\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001'B\u0005\u00a2\u0006\u0002\u0010\u0003J\b\u0010\u001d\u001a\u00020\u001eH\u0002J\u000e\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020\u00020\u0005H\u0016J\u0010\u0010 \u001a\u00020\u001e2\u0006\u0010!\u001a\u00020\u0002H\u0016J\u001a\u0010\"\u001a\u00020\u001e2\u0006\u0010#\u001a\u00020$2\b\u0010%\u001a\u0004\u0018\u00010&H\u0016R!\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u00058BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\t\u0010\n\u001a\u0004\b\u0007\u0010\bR\u001b\u0010\u000b\u001a\u00020\f8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u000f\u0010\n\u001a\u0004\b\r\u0010\u000eR\u001c\u0010\u0010\u001a\u0004\u0018\u00010\u0011X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0012\u0010\u0013\"\u0004\b\u0014\u0010\u0015R!\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00170\u00058BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0019\u0010\n\u001a\u0004\b\u0018\u0010\bR\u001b\u0010\u001a\u001a\u00020\f8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u001c\u0010\n\u001a\u0004\b\u001b\u0010\u000e\u00a8\u0006("}, d2={"Lco/omise/android/ui/InstallmentChooserFragment;", "Lco/omise/android/ui/OmiseListFragment;", "Lco/omise/android/ui/InstallmentResource;", "()V", "allowedInstallments", "", "Lco/omise/android/models/SourceType$Installment;", "getAllowedInstallments", "()Ljava/util/List;", "allowedInstallments$delegate", "Lkotlin/Lazy;", "capabilityInstallmentAmount", "", "getCapabilityInstallmentAmount", "()J", "capabilityInstallmentAmount$delegate", "navigation", "Lco/omise/android/ui/PaymentCreatorNavigation;", "getNavigation", "()Lco/omise/android/ui/PaymentCreatorNavigation;", "setNavigation", "(Lco/omise/android/ui/PaymentCreatorNavigation;)V", "paymentMethods", "Lco/omise/android/models/PaymentMethod;", "getPaymentMethods", "paymentMethods$delegate", "requestedInstallmentAmount", "getRequestedInstallmentAmount", "requestedInstallmentAmount$delegate", "addNoBanksSupportedMessage", "", "listItems", "onListItemClicked", "item", "onViewCreated", "view", "Landroid/view/View;", "savedInstanceState", "Landroid/os/Bundle;", "Companion", "sdk_productionRelease"})
public final class InstallmentChooserFragment
extends OmiseListFragment<InstallmentResource> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final String EXTRA_INSTALLMENT_METHODS = "InstallmentChooserFragment.installmentMethods";
    @NotNull
    private static final String EXTRA_REQUESTED_INSTALLMENT_AMOUNT = "InstallmentChooserFragment.requestedInstallmentAmount";
    @NotNull
    private static final String EXTRA_CAPABILITY_INSTALLMENT_AMOUNT = "InstallmentChooserFragment.capabilityInstallmentAmount";
    @NotNull
    private final Lazy paymentMethods$delegate;
    @NotNull
    private final Lazy requestedInstallmentAmount$delegate;
    @NotNull
    private final Lazy capabilityInstallmentAmount$delegate;
    @NotNull
    private final Lazy allowedInstallments$delegate;
    @Nullable
    private PaymentCreatorNavigation navigation;
    @NotNull
    public Map<Integer, View> _$_findViewCache = new LinkedHashMap<Integer, View>();

    public InstallmentChooserFragment() {
        this.paymentMethods$delegate = LazyKt.lazy((Function0)new Function0(this){
            final /* synthetic */ InstallmentChooserFragment a;
            {
                void var1_1;
                this.a = var1_1;
                super(0);
            }

            /*
             * Enabled aggressive block sorting
             */
            public final List a() {
                Bundle this_ = this_.a.getArguments();
                if (this_ == null) {
                    return CollectionsKt.emptyList();
                }
                Object object = InstallmentChooserFragment.EXTRA_INSTALLMENT_METHODS;
                if (Build.VERSION.SDK_INT >= 33) {
                    if ((this_ = (Parcelable[])this_.getParcelableArray((String)object, PaymentMethod.class)) != null) {
                        ArrayList arrayList;
                        Intrinsics.checkNotNullExpressionValue((Object)this_, (String)"getParcelableArray(key, T::class.java)");
                        object = arrayList;
                        arrayList = new ArrayList();
                        for (Object object2 : this_) {
                            if (object2 == null) continue;
                            object.add(object2);
                        }
                        PaymentMethod[] paymentMethodArray = object.toArray(new PaymentMethod[0]);
                        Intrinsics.checkNotNull((Object)paymentMethodArray, (String)"null cannot be cast to non-null type kotlin.Array<T of kotlin.collections.ArraysKt__ArraysJVMKt.toTypedArray>");
                        this_ = paymentMethodArray;
                        if (this_ != null) return ArraysKt.toList((Object[])this_);
                    }
                } else if ((this_ = this_.getParcelableArray((String)object)) != null) {
                    ArrayList arrayList;
                    Intrinsics.checkNotNullExpressionValue((Object)this_, (String)"getParcelableArray(key)");
                    object = arrayList;
                    arrayList = new ArrayList();
                    for (Object object3 : this_) {
                        if (!(object3 instanceof PaymentMethod)) {
                            object3 = null;
                        }
                        if ((object3 = (PaymentMethod)object3) == null) continue;
                        object.add(object3);
                    }
                    PaymentMethod[] paymentMethodArray = object.toArray(new PaymentMethod[0]);
                    Intrinsics.checkNotNull((Object)paymentMethodArray, (String)"null cannot be cast to non-null type kotlin.Array<T of kotlin.collections.ArraysKt__ArraysJVMKt.toTypedArray>");
                    this_ = paymentMethodArray;
                    if (this_ != null) return ArraysKt.toList((Object[])this_);
                }
                this_ = new PaymentMethod[0];
                return ArraysKt.toList((Object[])this_);
            }
        });
        this.requestedInstallmentAmount$delegate = LazyKt.lazy((Function0)new Function0(this){
            final /* synthetic */ InstallmentChooserFragment a;
            {
                void var1_1;
                this.a = var1_1;
                super(0);
            }

            public final Long a() {
                e this_ = this_.a.getArguments();
                if (this_ == null) {
                    return 0L;
                }
                return this_.getLong(InstallmentChooserFragment.EXTRA_REQUESTED_INSTALLMENT_AMOUNT);
            }
        });
        this.capabilityInstallmentAmount$delegate = LazyKt.lazy((Function0)new Function0(this){
            final /* synthetic */ InstallmentChooserFragment a;
            {
                void var1_1;
                this.a = var1_1;
                super(0);
            }

            public final Long a() {
                b this_ = this_.a.getArguments();
                if (this_ == null) {
                    return 0L;
                }
                return this_.getLong(InstallmentChooserFragment.EXTRA_CAPABILITY_INSTALLMENT_AMOUNT);
            }
        });
        this.allowedInstallments$delegate = LazyKt.lazy((Function0)new Function0(this){
            final /* synthetic */ InstallmentChooserFragment a;
            {
                void var1_1;
                this.a = var1_1;
                super(0);
            }

            public final List a() {
                ArrayList arrayList;
                ArrayList arrayList2;
                Object this_ = arrayList2;
                arrayList2 = new ArrayList();
                for (Object t2 : this_.a.getPaymentMethods()) {
                    PaymentMethod paymentMethod = (PaymentMethod)t2;
                    if (!(PaymentMethodKt.getBackendType(paymentMethod) instanceof BackendType.Source)) continue;
                    BackendType backendType = PaymentMethodKt.getBackendType(paymentMethod);
                    Intrinsics.checkNotNull((Object)backendType, (String)"null cannot be cast to non-null type co.omise.android.models.BackendType.Source");
                    if (!(((BackendType.Source)backendType).getSourceType() instanceof SourceType.Installment)) continue;
                    this_.add(t2);
                }
                ArrayList arrayList3 = arrayList;
                arrayList = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)this_, (int)10));
                this_ = this_.iterator();
                while (this_.hasNext()) {
                    BackendType backendType = PaymentMethodKt.getBackendType((PaymentMethod)this_.next());
                    Intrinsics.checkNotNull((Object)backendType, (String)"null cannot be cast to non-null type co.omise.android.models.BackendType.Source");
                    SourceType sourceType = ((BackendType.Source)backendType).getSourceType();
                    Intrinsics.checkNotNull((Object)sourceType, (String)"null cannot be cast to non-null type co.omise.android.models.SourceType.Installment");
                    arrayList3.add((SourceType.Installment)sourceType);
                }
                return arrayList3;
            }
        });
    }

    private final List<PaymentMethod> getPaymentMethods() {
        return (List)this.paymentMethods$delegate.getValue();
    }

    private final long getRequestedInstallmentAmount() {
        return ((Number)this.requestedInstallmentAmount$delegate.getValue()).longValue();
    }

    private final long getCapabilityInstallmentAmount() {
        return ((Number)this.capabilityInstallmentAmount$delegate.getValue()).longValue();
    }

    private final List<SourceType.Installment> getAllowedInstallments() {
        return (List)this.allowedInstallments$delegate.getValue();
    }

    /*
     * WARNING - void declaration
     */
    private final void addNoBanksSupportedMessage() {
        void var0_4;
        View view = this.getView();
        if (view != null) {
            LinearLayout linearLayout = (LinearLayout)view.findViewById(R.id.message_layout);
        } else {
            Object var0_3 = null;
        }
        if (var0_4 != null) {
            var0_4.setVisibility(0);
        }
    }

    @Nullable
    public final PaymentCreatorNavigation getNavigation() {
        return this.navigation;
    }

    /*
     * WARNING - void declaration
     */
    public final void setNavigation(@Nullable PaymentCreatorNavigation paymentCreatorNavigation) {
        void var1_1;
        this.navigation = var1_1;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void onViewCreated(@NotNull View view, @Nullable Bundle savedInstanceState) {
        void var2_2;
        void var1_1;
        InstallmentChooserFragment installmentChooserFragment = this;
        void v1 = var1_1;
        Intrinsics.checkNotNullParameter((Object)v1, (String)"view");
        super.onViewCreated((View)v1, (Bundle)var2_2);
        installmentChooserFragment.setTitle(installmentChooserFragment.getString(R.string.installments_title));
        installmentChooserFragment.setHasOptionsMenu(true);
        if (installmentChooserFragment.getRequestedInstallmentAmount() < this.getCapabilityInstallmentAmount()) {
            this.addNoBanksSupportedMessage();
        }
    }

    @Override
    @NotNull
    public List<InstallmentResource> listItems() {
        ArrayList arrayList;
        ArrayList<String> arrayList2;
        InstallmentChooserFragment installmentChooserFragment = this;
        Object object = CollectionsKt.toMutableList(PaymentMethodResourcesKt.getInstallmentResources(installmentChooserFragment.getAllowedInstallments()));
        Object object2 = PaymentMethodResourcesKt.getInstallmentResources(installmentChooserFragment.getAllowedInstallments());
        Object object3 = arrayList2;
        arrayList2 = new ArrayList<String>(CollectionsKt.collectionSizeOrDefault(object2, (int)10));
        object2 = object2.iterator();
        while (object2.hasNext()) {
            object3.add(((InstallmentResource)object2.next()).getSourceType().getName());
        }
        for (InstallmentResource object4 : PaymentMethodResourcesKt.getInstallmentResources(this.getAllowedInstallments())) {
            Function1 function1;
            String string2 = object4.getSourceType().getName();
            Intrinsics.checkNotNull((Object)string2);
            if (!StringsKt.contains$default((CharSequence)string2, (CharSequence)"_wlb_", (boolean)false, (int)2, null) || !object3.contains(StringsKt.replace$default((String)string2, (String)"_wlb_", (String)"_", (boolean)false, (int)4, null))) continue;
            string2 = function1;
            function1 = new Function1(object4){
                final /* synthetic */ InstallmentResource a;
                {
                    void var1_1;
                    this.a = var1_1;
                    super(1);
                }

                public final Boolean a(InstallmentResource it2) {
                    InstallmentResource installmentResource = it2;
                    Intrinsics.checkNotNullParameter((Object)installmentResource, (String)"it");
                    String string2 = installmentResource.getSourceType().getName();
                    String string3 = this.a.getSourceType().getName();
                    Intrinsics.checkNotNull((Object)string3);
                    return Intrinsics.areEqual((Object)string2, (Object)StringsKt.replace$default((String)string3, (String)"_wlb_", (String)"_", (boolean)false, (int)4, null));
                }
            };
            CollectionsKt.removeAll((List)object, (Function1)string2);
        }
        object2 = arrayList;
        arrayList = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)object, (int)10));
        object = object.iterator();
        while (object.hasNext()) {
            object3 = (InstallmentResource)object.next();
            Boolean bl2 = this.getRequestedInstallmentAmount() >= this.getCapabilityInstallmentAmount();
            ((InstallmentResource)object3).setEnabled(bl2);
            object2.add(object3);
        }
        return object2;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void onListItemClicked(@NotNull InstallmentResource item) {
        void var1_1;
        Intrinsics.checkNotNullParameter((Object)var1_1, (String)"item");
        for (PaymentMethod paymentMethod : ((InstallmentChooserFragment)((Object)this_)).getPaymentMethods()) {
            BackendType backendType = PaymentMethodKt.getBackendType(paymentMethod);
            Intrinsics.checkNotNull((Object)backendType, (String)"null cannot be cast to non-null type co.omise.android.models.BackendType.Source");
            if (!Intrinsics.areEqual((Object)((BackendType.Source)backendType).getSourceType(), (Object)var1_1.getSourceType())) continue;
            PaymentCreatorNavigation this_ = ((InstallmentChooserFragment)((Object)this_)).navigation;
            if (this_ != null) {
                this_.navigateToInstallmentTermChooser(paymentMethod);
            }
            return;
        }
        throw new NoSuchElementException("Collection contains no element matching the predicate.");
    }

    @Override
    public void _$_clearFindViewByIdCache() {
        this._$_findViewCache.clear();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @Nullable
    public View _$_findCachedViewById(int id2) {
        void var1_1;
        Map<Integer, View> map = this._$_findViewCache;
        View view = map.get((int)var1_1);
        if (view == null) {
            if ((this = this.getView()) != null && (view = this.findViewById((int)var1_1)) != null) {
                map.put((int)var1_1, view);
            } else {
                view = null;
            }
        }
        return view;
    }

    @Override
    public /* synthetic */ void onDestroyView() {
        InstallmentChooserFragment installmentChooserFragment = this;
        super.onDestroyView();
        installmentChooserFragment._$_clearFindViewByIdCache();
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J$\u0010\u0007\u001a\u00020\b2\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\n2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\rR\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lco/omise/android/ui/InstallmentChooserFragment$Companion;", "", "()V", "EXTRA_CAPABILITY_INSTALLMENT_AMOUNT", "", "EXTRA_INSTALLMENT_METHODS", "EXTRA_REQUESTED_INSTALLMENT_AMOUNT", "newInstance", "Lco/omise/android/ui/InstallmentChooserFragment;", "availableBanks", "", "Lco/omise/android/models/PaymentMethod;", "requestedInstallmentAmount", "", "capabilityInstallmentAmount", "sdk_productionRelease"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }

        /*
         * WARNING - void declaration
         */
        @NotNull
        public final InstallmentChooserFragment newInstance(@NotNull List<PaymentMethod> availableBanks, long requestedInstallmentAmount, long capabilityInstallmentAmount) {
            void var4_3;
            void var2_2;
            void var1_1;
            Intrinsics.checkNotNullParameter(availableBanks, (String)"availableBanks");
            InstallmentChooserFragment installmentChooserFragment = new InstallmentChooserFragment();
            Bundle bundle = new Bundle();
            PaymentMethod[] paymentMethodArray = var1_1.toArray(new PaymentMethod[0]);
            Intrinsics.checkNotNull((Object)paymentMethodArray, (String)"null cannot be cast to non-null type kotlin.Array<T of kotlin.collections.ArraysKt__ArraysJVMKt.toTypedArray>");
            bundle.putParcelableArray(InstallmentChooserFragment.EXTRA_INSTALLMENT_METHODS, (Parcelable[])paymentMethodArray);
            bundle.putLong(InstallmentChooserFragment.EXTRA_REQUESTED_INSTALLMENT_AMOUNT, (long)var2_2);
            bundle.putLong(InstallmentChooserFragment.EXTRA_CAPABILITY_INSTALLMENT_AMOUNT, (long)var4_3);
            installmentChooserFragment.setArguments(bundle);
            return installmentChooserFragment;
        }
    }
}

