/*
 * Decompiled with CFR 0.152.
 */
package co.nstant.in.cbor.model;

import co.nstant.in.cbor.CborException;
import co.nstant.in.cbor.model.Array;
import co.nstant.in.cbor.model.Number;
import java.math.BigInteger;

public class RationalNumber
extends Array {
    public RationalNumber(Number numerator, Number denominator) throws CborException {
        this.setTag(30L);
        if (numerator == null) {
            throw new CborException("Numerator is null");
        }
        if (denominator == null) {
            throw new CborException("Denominator is null");
        }
        if (denominator.getValue().equals(BigInteger.ZERO)) {
            throw new CborException("Denominator is zero");
        }
        this.add(numerator);
        this.add(denominator);
    }

    public Number getNumerator() {
        return (Number)this.getDataItems().get(0);
    }

    public Number getDenominator() {
        return (Number)this.getDataItems().get(1);
    }
}

