/*
 * Decompiled with CFR 0.152.
 */
package co.nstant.in.cbor.decoder;

import co.nstant.in.cbor.CborDecoder;
import co.nstant.in.cbor.CborException;
import co.nstant.in.cbor.decoder.AbstractDecoder;
import co.nstant.in.cbor.model.DataItem;
import co.nstant.in.cbor.model.Map;
import co.nstant.in.cbor.model.Special;
import java.io.InputStream;

public class MapDecoder
extends AbstractDecoder<Map> {
    public MapDecoder(CborDecoder decoder, InputStream inputStream) {
        super(decoder, inputStream);
    }

    @Override
    public Map decode(int initialByte) throws CborException {
        long length = this.getLength(initialByte);
        if (length == -1L) {
            return this.decodeInfinitiveLength();
        }
        return this.decodeFixedLength(length);
    }

    private Map decodeInfinitiveLength() throws CborException {
        Map map = new Map();
        map.setChunked(true);
        if (this.decoder.isAutoDecodeInfinitiveMaps()) {
            DataItem key;
            while (!Special.BREAK.equals(key = this.decoder.decodeNext())) {
                DataItem value = this.decoder.decodeNext();
                if (key == null || value == null) {
                    throw new CborException("Unexpected end of stream");
                }
                if (this.decoder.isRejectDuplicateKeys() && map.get(key) != null) {
                    throw new CborException("Duplicate key found in map");
                }
                map.put(key, value);
            }
        }
        return map;
    }

    private Map decodeFixedLength(long length) throws CborException {
        Map map = new Map(this.getPreallocationSize(length));
        for (long i = 0L; i < length; ++i) {
            DataItem key = this.decoder.decodeNext();
            DataItem value = this.decoder.decodeNext();
            if (key == null || value == null) {
                throw new CborException("Unexpected end of stream");
            }
            if (this.decoder.isRejectDuplicateKeys() && map.get(key) != null) {
                throw new CborException("Duplicate key found in map");
            }
            map.put(key, value);
        }
        return map;
    }
}

