/*
 * Decompiled with CFR 0.152.
 */
package fish.payara.maven.plugins.micro;

import fish.payara.maven.plugins.micro.BasePayaraMojo;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import org.apache.commons.lang.StringUtils;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.dependency.fromConfiguration.ArtifactItem;

@Mojo(name="stop")
public class StopMojo
extends BasePayaraMojo {
    private static final String ERROR_MESSAGE = "Error occurred while terminating payara-micro";
    @Parameter(property="artifactItem")
    private ArtifactItem artifactItem;
    @Parameter(property="processId")
    private String processId;

    public void execute() throws MojoExecutionException, MojoFailureException {
        if (this.processId != null) {
            this.killProcess(this.processId);
        }
        String executorName = this.artifactItem.getGroupId() != null ? this.artifactItem.getArtifactId() + "-" + this.artifactItem.getVersion() + ".jar" : this.evaluateExecutorName(true);
        Runtime re = Runtime.getRuntime();
        try {
            String line;
            Process jpsProcess = re.exec("jps");
            InputStream inputStream = jpsProcess.getInputStream();
            BufferedReader in = new BufferedReader(new InputStreamReader(inputStream));
            String processId = null;
            while ((line = in.readLine()) != null) {
                if (!line.contains(executorName)) continue;
                String[] split = line.split(" ");
                processId = split[0];
            }
            if (StringUtils.isNotEmpty(processId)) {
                this.killProcess(processId);
            } else {
                this.getLog().warn((CharSequence)"Could not find process of running payara-micro?");
            }
        }
        catch (IOException e) {
            this.getLog().error((CharSequence)ERROR_MESSAGE, (Throwable)e);
        }
    }

    private void killProcess(String processId) {
        try {
            Runtime re = Runtime.getRuntime();
            Process killProcess = re.exec("kill -2 " + processId);
            int result = killProcess.waitFor();
            if (result != 0) {
                this.getLog().error((CharSequence)ERROR_MESSAGE);
            }
        }
        catch (IOException | InterruptedException e) {
            this.getLog().error((CharSequence)ERROR_MESSAGE, (Throwable)e);
        }
    }

    private String evaluateExecutorName(Boolean withExtension) {
        String extension = withExtension != false ? "-microbundle.jar" : "." + this.mavenProject.getPackaging();
        if (StringUtils.isNotEmpty((String)this.mavenProject.getBuild().getFinalName())) {
            return this.mavenProject.getBuild().getFinalName() + extension;
        }
        return this.mavenProject.getArtifact().getArtifactId() + this.mavenProject.getVersion() + extension;
    }
}

