/*
 * Decompiled with CFR 0.152.
 */
package fish.payara.maven.plugins.micro;

import fish.payara.maven.plugins.micro.BasePayaraMojo;
import fish.payara.maven.plugins.micro.Option;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.compress.utils.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.DefaultArtifact;
import org.apache.maven.artifact.handler.ArtifactHandler;
import org.apache.maven.artifact.handler.DefaultArtifactHandler;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.dependency.fromConfiguration.ArtifactItem;

@Mojo(name="start")
public class StartMojo
extends BasePayaraMojo {
    String ERROR_MESSAGE = "Errors occurred while executing payara-micro.";
    @Parameter(property="javaPath", defaultValue="java")
    private String javaPath;
    @Parameter(property="payaraMicroAbsolutePath")
    private String payaraMicroAbsolutePath;
    @Parameter(property="deamon", defaultValue="false")
    private Boolean daemon;
    @Parameter(property="artifactItem")
    private ArtifactItem artifactItem;
    @Parameter(property="useUberJar", defaultValue="false")
    private Boolean useUberJar;
    @Parameter(property="deployWar", defaultValue="false")
    private Boolean deployWar;
    @Parameter(property="copySystemProperties", defaultValue="false")
    private Boolean copySystemProperties;
    @Parameter(property="commandLineOptions")
    private List<Option> commandLineOptions;
    private Process microProcess;

    public void execute() throws MojoExecutionException, MojoFailureException {
        final String path = this.decideOnWhichMicroToUse();
        ThreadGroup threadGroup = new ThreadGroup("PayaraMicroThread");
        Thread microProcessorThread = new Thread(threadGroup, new Runnable(){

            @Override
            public void run() {
                ArrayList<String> systemProps = new ArrayList<String>();
                if (StartMojo.this.copySystemProperties.booleanValue()) {
                    for (String property : StartMojo.this.mavenSession.getSystemProperties().stringPropertyNames()) {
                        String value = System.getProperty(property);
                        if (value == null) continue;
                        String prop = String.format("%s=%s", property, value);
                        systemProps.add(prop);
                    }
                }
                ArrayList<String> actualArgs = new ArrayList<String>();
                StartMojo.this.getLog().info((CharSequence)("Starting payara-micro from path: " + path));
                int indice = 0;
                actualArgs.add(indice++, StartMojo.this.javaPath);
                actualArgs.add(indice++, "-jar");
                actualArgs.add(indice++, path);
                if (StartMojo.this.deployWar.booleanValue() && "war".equalsIgnoreCase(StartMojo.this.mavenProject.getPackaging())) {
                    actualArgs.add(indice++, "--deploy");
                    actualArgs.add(indice++, StartMojo.this.evaluateProjectArtifactAbsolutePath(false));
                }
                for (Option option : StartMojo.this.commandLineOptions) {
                    actualArgs.add(indice++, option.getKey());
                    actualArgs.add(indice++, option.getValue());
                }
                try {
                    Runtime re = Runtime.getRuntime();
                    StartMojo.this.microProcess = re.exec(actualArgs.toArray(new String[actualArgs.size()]), systemProps.isEmpty() ? null : systemProps.toArray(new String[systemProps.size()]));
                    StartMojo.this.redirectStream(StartMojo.this.microProcess.getInputStream(), System.out);
                    StartMojo.this.redirectStream(StartMojo.this.microProcess.getErrorStream(), System.err);
                    int exitCode = StartMojo.this.microProcess.waitFor();
                    if (exitCode != 0) {
                        throw new MojoFailureException(StartMojo.this.ERROR_MESSAGE);
                    }
                }
                catch (Exception e) {
                    throw new RuntimeException(StartMojo.this.ERROR_MESSAGE, e);
                }
                finally {
                    StartMojo.this.closeMicroProcess();
                }
            }
        });
        if (this.daemon.booleanValue()) {
            microProcessorThread.setDaemon(true);
            microProcessorThread.start();
        } else {
            microProcessorThread.run();
        }
    }

    private String decideOnWhichMicroToUse() {
        if (this.useUberJar.booleanValue()) {
            return this.evaluateProjectArtifactAbsolutePath(true);
        }
        if (this.payaraMicroAbsolutePath != null) {
            return this.payaraMicroAbsolutePath;
        }
        if (this.artifactItem.getGroupId() != null) {
            DefaultArtifact artifact = new DefaultArtifact(this.artifactItem.getGroupId(), this.artifactItem.getArtifactId(), this.artifactItem.getVersion(), null, this.artifactItem.getType(), this.artifactItem.getClassifier(), (ArtifactHandler)new DefaultArtifactHandler("jar"));
            Artifact payaraMicroArtifact = this.mavenSession.getLocalRepository().find((Artifact)artifact);
            return payaraMicroArtifact.getFile().getAbsolutePath();
        }
        return null;
    }

    private String evaluateProjectArtifactAbsolutePath(Boolean withExtension) {
        String projectJarAbsolutePath = this.mavenProject.getBuild().getDirectory() + "/";
        projectJarAbsolutePath = projectJarAbsolutePath + this.evaluateExecutorName(withExtension);
        return projectJarAbsolutePath;
    }

    private String evaluateExecutorName(Boolean withExtension) {
        String extension = withExtension != false ? "-microbundle.jar" : "." + this.mavenProject.getPackaging();
        if (StringUtils.isNotEmpty((String)this.mavenProject.getBuild().getFinalName())) {
            return this.mavenProject.getBuild().getFinalName() + extension;
        }
        return this.mavenProject.getArtifact().getArtifactId() + this.mavenProject.getVersion() + extension;
    }

    private void closeMicroProcess() {
        if (this.microProcess != null) {
            try {
                this.microProcess.exitValue();
            }
            catch (IllegalThreadStateException e) {
                this.microProcess.destroy();
                this.getLog().info((CharSequence)"Terminated payara-micro.");
            }
        }
    }

    private void redirectStream(final InputStream inputStream, final OutputStream outputStream) {
        Thread thread = new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    IOUtils.copy((InputStream)inputStream, (OutputStream)outputStream);
                }
                catch (IOException e) {
                    StartMojo.this.getLog().error((CharSequence)"Error occurred while reading stream", (Throwable)e);
                }
            }
        });
        thread.setDaemon(false);
        thread.start();
    }
}

