/*
 * Decompiled with CFR 0.152.
 */
package fish.payara.maven.plugins.micro;

import fish.payara.maven.plugins.micro.BasePayaraMojo;
import fish.payara.maven.plugins.micro.processor.ArtifactDeployProcessor;
import fish.payara.maven.plugins.micro.processor.BaseProcessor;
import fish.payara.maven.plugins.micro.processor.BootCommandFileCopyProcessor;
import fish.payara.maven.plugins.micro.processor.CustomFileCopyProcessor;
import fish.payara.maven.plugins.micro.processor.CustomJarCopyProcessor;
import fish.payara.maven.plugins.micro.processor.DefinedArtifactDeployProcessor;
import fish.payara.maven.plugins.micro.processor.MicroFetchProcessor;
import fish.payara.maven.plugins.micro.processor.MicroJarBundleProcessor;
import fish.payara.maven.plugins.micro.processor.StartClassReplaceProcessor;
import fish.payara.maven.plugins.micro.processor.SystemPropAppendProcessor;
import java.util.List;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.dependency.fromConfiguration.ArtifactItem;
import org.twdata.maven.mojoexecutor.MojoExecutor;

@Mojo(name="bundle", defaultPhase=LifecyclePhase.INSTALL)
public class BundleMojo
extends BasePayaraMojo {
    @Parameter(property="payaraVersion", defaultValue="4.1.1.171")
    private String payaraVersion;
    @Parameter
    private List<ArtifactItem> customJars;
    @Parameter
    private List<ArtifactItem> deployArtifacts;
    @Parameter(property="autoDeployArtifact", defaultValue="true")
    private Boolean autoDeployArtifact;
    @Parameter(property="startClass")
    private String startClass;
    @Parameter(property="appendSystemProperties", defaultValue="true")
    private Boolean appendSystemProperties;

    public void execute() throws MojoExecutionException, MojoFailureException {
        MojoExecutor.ExecutionEnvironment environment = this.getEnvironment();
        BaseProcessor processor = this.constructProcessorChain();
        processor.handle(environment);
    }

    private BaseProcessor constructProcessorChain() throws MojoExecutionException {
        MicroFetchProcessor microFetchProcessor = new MicroFetchProcessor();
        CustomJarCopyProcessor customJarCopyProcessor = new CustomJarCopyProcessor();
        CustomFileCopyProcessor customFileCopyProcessor = new CustomFileCopyProcessor();
        BootCommandFileCopyProcessor bootCommandFileCopyProcessor = new BootCommandFileCopyProcessor();
        ArtifactDeployProcessor artifactDeployProcessor = new ArtifactDeployProcessor();
        DefinedArtifactDeployProcessor definedArtifactDeployProcessor = new DefinedArtifactDeployProcessor();
        StartClassReplaceProcessor startClassReplaceProcessor = new StartClassReplaceProcessor();
        SystemPropAppendProcessor systemPropAppendProcessor = new SystemPropAppendProcessor();
        MicroJarBundleProcessor microJarBundleProcessor = new MicroJarBundleProcessor();
        microFetchProcessor.set(this.payaraVersion).next(customJarCopyProcessor);
        customJarCopyProcessor.set(this.customJars).next(customFileCopyProcessor);
        customFileCopyProcessor.next(bootCommandFileCopyProcessor);
        bootCommandFileCopyProcessor.next(artifactDeployProcessor);
        artifactDeployProcessor.set(this.autoDeployArtifact, this.mavenProject.getPackaging()).next(definedArtifactDeployProcessor);
        definedArtifactDeployProcessor.set(this.deployArtifacts).next(startClassReplaceProcessor);
        startClassReplaceProcessor.set(this.startClass).next(systemPropAppendProcessor);
        systemPropAppendProcessor.set(this.appendSystemProperties).next(microJarBundleProcessor);
        return microFetchProcessor;
    }
}

