/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.logging.log4j;

import java.util.Collections;
import java.util.Map;
import org.apache.log4j.MDC;
import org.apache.log4j.spi.LoggingEvent;

public interface MdcAccess {
    public Map<String, ?> getMDC(LoggingEvent var1);

    public static enum ForLegacyLog4j implements MdcAccess
    {
        INSTANCE;


        @Override
        public Map<String, ?> getMDC(LoggingEvent event) {
            if (Thread.currentThread().getName().equals(event.getThreadName())) {
                return MDC.getContext();
            }
            return Collections.emptyMap();
        }
    }

    public static enum GetPropertiesCapable implements MdcAccess
    {
        INSTANCE;


        @Override
        public Map<String, ?> getMDC(LoggingEvent event) {
            if (Thread.currentThread().getName().equals(event.getThreadName())) {
                return MDC.getContext();
            }
            return event.getProperties();
        }
    }

    public static class Resolver {
        public static MdcAccess resolve() {
            try {
                LoggingEvent.class.getMethod("getProperties", new Class[0]);
                return (MdcAccess)Class.forName("co.elastic.logging.log4j.MdcAccess$GetPropertiesCapable").getEnumConstants()[0];
            }
            catch (Exception exception) {
            }
            catch (LinkageError linkageError) {
                // empty catch block
            }
            return ForLegacyLog4j.INSTANCE;
        }
    }
}

