/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.logging;

import co.elastic.logging.JsonUtils;
import co.elastic.logging.TimestampSerializer;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.Map;

public class EcsJsonSerializer {
    private static final TimestampSerializer TIMESTAMP_SERIALIZER = new TimestampSerializer();
    private static final ThreadLocal<StringBuilder> messageStringBuilder = new ThreadLocal();
    private static final String NEW_LINE = System.getProperty("line.separator");

    public static CharSequence toNullSafeString(CharSequence s) {
        return s == null ? "" : s;
    }

    public static void serializeObjectStart(StringBuilder builder, long timeMillis) {
        builder.append('{');
        builder.append("\"@timestamp\":\"");
        TIMESTAMP_SERIALIZER.serializeEpochTimestampAsIsoDateTime(builder, timeMillis);
        builder.append("\", ");
    }

    public static void serializeObjectEnd(StringBuilder builder) {
        EcsJsonSerializer.removeIfEndsWith(builder, ",");
        builder.append('}');
        builder.append('\n');
    }

    public static void serializeLoggerName(StringBuilder builder, String loggerName) {
        builder.append("\"log.logger\":\"");
        JsonUtils.quoteAsString(loggerName, builder);
        builder.append("\",");
    }

    public static void serializeThreadName(StringBuilder builder, String threadName) {
        if (threadName != null) {
            builder.append("\"process.thread.name\":\"");
            JsonUtils.quoteAsString(threadName, builder);
            builder.append("\",");
        }
    }

    public static void serializeFormattedMessage(StringBuilder builder, String message) {
        builder.append("\"message\":\"");
        JsonUtils.quoteAsString(message, builder);
        builder.append("\", ");
    }

    public static void serializeServiceName(StringBuilder builder, String serviceName) {
        if (serviceName != null) {
            builder.append("\"service.name\":\"").append(serviceName).append("\",");
        }
    }

    public static void serializeEventDataset(StringBuilder builder, String eventDataset) {
        if (eventDataset != null) {
            builder.append("\"event.dataset\":\"").append(eventDataset).append("\",");
        }
    }

    public static void serializeLogLevel(StringBuilder builder, String level) {
        builder.append("\"log.level\":");
        for (int i = 5 - level.length(); i > 0; --i) {
            builder.append(' ');
        }
        builder.append('\"');
        JsonUtils.quoteAsString(level, builder);
        builder.append("\", ");
    }

    public static void serializeTag(StringBuilder builder, String tag) {
        if (tag != null) {
            builder.append("\"tags\":[\"");
            JsonUtils.quoteAsString(tag, builder);
            builder.append("\"],");
        }
    }

    public static void serializeTagStart(StringBuilder builder) {
        builder.append("\"tags\":[");
    }

    public static void serializeSingleTag(StringBuilder builder, String tag) {
        if (tag != null) {
            builder.append("\"");
            JsonUtils.quoteAsString(tag, builder);
            builder.append("\",");
        }
    }

    public static void serializeTagEnd(StringBuilder builder) {
        builder.setLength(builder.length() - 1);
        builder.append("],");
    }

    public static void serializeOrigin(StringBuilder builder, StackTraceElement stackTraceElement) {
        if (stackTraceElement != null) {
            EcsJsonSerializer.serializeOrigin(builder, stackTraceElement.getFileName(), stackTraceElement.getMethodName(), stackTraceElement.getLineNumber());
        }
    }

    public static void serializeOrigin(StringBuilder builder, String fileName, String methodName, int lineNumber) {
        builder.append("\"log.origin\":{");
        builder.append("\"file.name\":\"");
        JsonUtils.quoteAsString(fileName, builder);
        builder.append("\",");
        builder.append("\"function\":\"");
        JsonUtils.quoteAsString(methodName, builder);
        builder.append("\",");
        builder.append("\"file.line\":");
        builder.append(lineNumber);
        builder.append("},");
    }

    public static void serializeMDC(StringBuilder builder, Map<String, ?> properties) {
        if (!properties.isEmpty()) {
            for (Map.Entry<String, ?> entry : properties.entrySet()) {
                builder.append('\"');
                String key = entry.getKey();
                JsonUtils.quoteAsString(key, builder);
                builder.append("\":\"");
                JsonUtils.quoteAsString(EcsJsonSerializer.toNullSafeString(String.valueOf(entry.getValue())), builder);
                builder.append("\",");
            }
        }
    }

    public static void serializeException(StringBuilder builder, Throwable thrown, boolean stackTraceAsArray) {
        if (thrown != null) {
            builder.append("\"error.type\":\"");
            JsonUtils.quoteAsString(thrown.getClass().getName(), builder);
            builder.append("\",");
            String message = thrown.getMessage();
            if (message != null) {
                builder.append("\"error.message\":\"");
                JsonUtils.quoteAsString(message, builder);
                builder.append("\",");
            }
            if (stackTraceAsArray) {
                builder.append("\"error.stack_trace\":[").append(NEW_LINE);
                EcsJsonSerializer.formatThrowableAsArray(builder, thrown);
                builder.append("]");
            } else {
                builder.append("\"error.stack_trace\":\"");
                JsonUtils.quoteAsString(EcsJsonSerializer.formatThrowable(thrown), builder);
                builder.append("\"");
            }
        }
    }

    public static void serializeException(StringBuilder builder, String exceptionClassName, String exceptionMessage, String stackTrace, boolean stackTraceAsArray) {
        builder.append("\"error.type\":\"");
        JsonUtils.quoteAsString(exceptionClassName, builder);
        builder.append("\",");
        builder.append("\"error.message\":\"");
        JsonUtils.quoteAsString(exceptionMessage, builder);
        builder.append("\",");
        if (stackTraceAsArray) {
            builder.append("\"error.stack_trace\":[").append(NEW_LINE);
            for (String line : stackTrace.split("\\n")) {
                EcsJsonSerializer.appendQuoted(builder, line);
            }
            builder.append("]");
        } else {
            builder.append("\"error.stack_trace\":\"");
            JsonUtils.quoteAsString(stackTrace, builder);
            builder.append("\"");
        }
    }

    private static void appendQuoted(StringBuilder builder, CharSequence content) {
        builder.append('\"');
        JsonUtils.quoteAsString(content, builder);
        builder.append('\"');
    }

    private static CharSequence formatThrowable(Throwable throwable) {
        StringBuilder buffer = EcsJsonSerializer.getMessageStringBuilder();
        PrintWriter pw = new PrintWriter(new StringBuilderWriter(buffer));
        throwable.printStackTrace(pw);
        pw.flush();
        return buffer;
    }

    private static void formatThrowableAsArray(final StringBuilder jsonBuilder, Throwable throwable) {
        final StringBuilder buffer = EcsJsonSerializer.getMessageStringBuilder();
        PrintWriter pw = new PrintWriter(new StringBuilderWriter(buffer), true){

            @Override
            public void println() {
                this.flush();
                jsonBuilder.append("\t\"");
                JsonUtils.quoteAsString(buffer, jsonBuilder);
                jsonBuilder.append("\",");
                jsonBuilder.append(NEW_LINE);
                buffer.setLength(0);
            }
        };
        throwable.printStackTrace(pw);
        EcsJsonSerializer.removeIfEndsWith(jsonBuilder, NEW_LINE);
        EcsJsonSerializer.removeIfEndsWith(jsonBuilder, ",");
    }

    public static void removeIfEndsWith(StringBuilder sb, String ending) {
        if (EcsJsonSerializer.endsWith(sb, ending)) {
            sb.setLength(sb.length() - ending.length());
        }
    }

    public static boolean endsWith(StringBuilder sb, String ending) {
        int endingLength = ending.length();
        int startIndex = sb.length() - endingLength;
        if (startIndex < 0) {
            return false;
        }
        for (int i = 0; i < endingLength; ++i) {
            if (sb.charAt(startIndex + i) == ending.charAt(i)) continue;
            return false;
        }
        return true;
    }

    public static StringBuilder getMessageStringBuilder() {
        StringBuilder result = messageStringBuilder.get();
        if (result == null) {
            result = new StringBuilder(1024);
            messageStringBuilder.set(result);
        }
        result.setLength(0);
        return result;
    }

    public static String computeEventDataset(String eventDataset, String serviceName) {
        if (eventDataset == null && serviceName != null && !serviceName.isEmpty()) {
            return serviceName + ".log";
        }
        return eventDataset;
    }

    private static class StringBuilderWriter
    extends Writer {
        private final StringBuilder buffer;

        StringBuilderWriter(StringBuilder buffer) {
            this.buffer = buffer;
        }

        @Override
        public Writer append(CharSequence csq) {
            this.buffer.append(csq);
            return this;
        }

        @Override
        public void write(String str) {
            this.buffer.append(str);
        }

        @Override
        public void write(String str, int off, int len) {
            this.buffer.append(str, off, len);
        }

        @Override
        public Writer append(CharSequence csq, int start, int end) {
            this.buffer.append(csq, start, end);
            return this;
        }

        @Override
        public Writer append(char c) {
            this.buffer.append(c);
            return this;
        }

        @Override
        public void write(int c) {
            this.buffer.append((char)c);
        }

        @Override
        public void write(char[] cbuf, int off, int len) {
            this.buffer.append(cbuf, off, len);
        }

        @Override
        public void flush() {
        }

        @Override
        public void close() {
        }
    }
}

