/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.gradle.utils;

import java.io.File;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.lang.annotation.Annotation;
import java.net.URL;
import java.net.URLClassLoader;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.gradle.api.GradleException;
import org.gradle.api.InvalidUserDataException;
import org.gradle.api.Project;
import org.gradle.api.Task;
import org.gradle.api.internal.tasks.testing.filter.DefaultTestFilter;
import org.gradle.api.tasks.TaskProvider;
import org.gradle.api.tasks.testing.Test;

public class GradleUtils {
    public static boolean areTestsFiltered(Test task) {
        return Optional.ofNullable(task.getFilter()).filter(it -> it instanceof DefaultTestFilter).map(it -> (DefaultTestFilter)it).map(it -> {
            HashSet filters = new HashSet();
            filters.addAll(Optional.ofNullable(it.getCommandLineIncludePatterns()).orElse(Collections.emptySet()));
            filters.addAll(Optional.ofNullable(it.getIncludePatterns()).orElse(Collections.emptySet()));
            return filters;
        }).map(filters -> !filters.isEmpty()).orElse(false);
    }

    public static List<String> testClassNames(Set<File> classesDirs) {
        try (Stream s = classesDirs.stream().filter(file -> {
            boolean exists = file.exists();
            return exists;
        }).flatMap(classesDir -> {
            Path prefix = classesDir.toPath();
            try {
                return Files.walk(classesDir.toPath(), new FileVisitOption[0]).map(other -> {
                    Path relativize = prefix.relativize((Path)other);
                    return relativize;
                }).filter(it -> it.toString().endsWith(".class")).map(it -> it.toString().replace("/", ".").substring(0, it.toString().lastIndexOf(".class")));
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
        });){
            List<String> list = s.collect(Collectors.toList());
            return list;
        }
    }

    public static String[] classNamesByAnnotation(Set<File> classesDir, List<URL> classpath, String annotation) {
        Class<Annotation> annotationClass;
        URLClassLoader loader = URLClassLoader.newInstance((URL[])classpath.toArray(URL[]::new));
        try {
            annotationClass = loader.loadClass(annotation).asSubclass(Annotation.class);
        }
        catch (ClassNotFoundException e) {
            throw new GradleException("Failed to load annotation class", (Throwable)e);
        }
        List<String> strings = GradleUtils.testClassNames(classesDir);
        return (String[])strings.stream().filter(name -> {
            try {
                return loader.loadClass((String)name).isAnnotationPresent(annotationClass);
            }
            catch (ClassNotFoundException e) {
                throw new GradleException("Failed to load test class", (Throwable)e);
            }
        }).toArray(String[]::new);
    }

    public static boolean isCi() {
        return System.getenv("BUILD_URL") != null;
    }

    public static String listPathsRelativeToProject(Project project, Collection<Path> files) {
        if (files.isEmpty()) {
            return "";
        }
        Path projectPath = project.getProjectDir().toPath();
        return "\n    " + files.stream().map(path -> projectPath.relativize((Path)path)).map(Path::toString).collect(Collectors.joining("\n    ,"));
    }

    public static TaskProvider<Task> registerOrGet(Project project, String taskName) {
        try {
            return project.getTasks().register(taskName);
        }
        catch (InvalidUserDataException e) {
            return project.getTasks().named(taskName);
        }
    }
}

