/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.gradle.lifecycle;

import co.elastic.gradle.utils.RegularFileUtils;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.Set;
import java.util.stream.Collectors;
import javax.inject.Inject;
import org.gradle.api.DefaultTask;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.file.ProjectLayout;
import org.gradle.api.file.RegularFileProperty;
import org.gradle.api.provider.Provider;
import org.gradle.api.tasks.InputFiles;
import org.gradle.api.tasks.OutputFile;
import org.gradle.api.tasks.PathSensitive;
import org.gradle.api.tasks.PathSensitivity;
import org.gradle.api.tasks.TaskAction;

public abstract class ResolveAllDependenciesTask
extends DefaultTask {
    public ResolveAllDependenciesTask() {
        this.setDescription("Lifecycle task to resolves all external dependencies. This task can be used to cache everything locally so these are not  downloaded while building. e.g. to download everything while on a better connection. In CI this is used to \"bake\" depdencies so they are not re-downloaded on every run.");
        this.setGroup("prepare");
        this.getMarkerFile().convention(this.getProjectLayout().getBuildDirectory().file(this.getName() + ".marker"));
    }

    @Inject
    protected abstract ProjectLayout getProjectLayout();

    @OutputFile
    public abstract RegularFileProperty getMarkerFile();

    @InputFiles
    @PathSensitive(value=PathSensitivity.NONE)
    public Set<Configuration> getResolvableConfigurations() {
        return this.getProject().getConfigurations().stream().filter(Configuration::isCanBeResolved).filter(each -> !Set.of("default", "archives").contains(each.getName())).collect(Collectors.toSet());
    }

    @TaskAction
    public void resolveConfigurations() throws IOException {
        Set<Configuration> resolvableConfigurations = this.getResolvableConfigurations();
        resolvableConfigurations.forEach(Configuration::resolve);
        Files.writeString(RegularFileUtils.toPath((Provider)this.getMarkerFile()), (CharSequence)("Resolved configurations:" + resolvableConfigurations.size()), new OpenOption[0]);
    }
}

