/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.gradle.lifecycle;

import co.elastic.gradle.lifecycle.LifecyclePlugin;
import co.elastic.gradle.utils.RetryUtils;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.gradle.api.Action;
import org.gradle.api.GradleException;
import org.gradle.api.NamedDomainObjectProvider;
import org.gradle.api.Plugin;
import org.gradle.api.Project;
import org.gradle.api.Task;
import org.gradle.api.plugins.ApplicationPlugin;
import org.gradle.api.plugins.JavaPlugin;
import org.gradle.api.tasks.TaskContainer;
import org.gradle.api.tasks.TaskDependency;
import org.gradle.api.tasks.TaskProvider;

public class MultiArchLifecyclePlugin
implements Plugin<Project> {
    public void apply(Project target) {
        target.getPluginManager().apply(LifecyclePlugin.class);
        TaskContainer tasks = target.getTasks();
        this.createMultiPlatformBuildLifecycle(tasks);
        tasks.named("checkPlatformIndependent", check -> check.dependsOn(new Object[]{"preCommit"}));
        tasks.named("checkForPlatform", check -> check.dependsOn(new Object[]{"syncBinDir"}));
        target.getPlugins().withType(JavaPlugin.class, plugin -> {
            tasks.named("checkPlatformIndependent", it -> it.dependsOn(new Object[]{"test"}));
            tasks.named("assemblePlatformIndependent", it -> it.dependsOn(new Object[]{"jar"}));
        });
        target.getPlugins().withType(ApplicationPlugin.class, plugin -> {
            tasks.named("checkPlatformIndependent", it -> it.dependsOn(new Object[]{"test"}));
            tasks.named("assemblePlatformIndependent", it -> it.dependsOn(new Object[]{"distTar", "distZip"}));
        });
    }

    private void createMultiPlatformBuildLifecycle(TaskContainer tasks) {
        Map<String, Map<String, String>> taskMap = Map.of("check", Map.of("ForPlatform", "Run all platform specific verifications for the current platform only.", "PlatformIndependent", "Run all platform independent verifications (that don't depend on platform dependent tasks)", "CombinePlatform", "Run all verifications for all platforms that can be ran in a platform independent way. Assumes that platform specific artefacts for this version are already published.", "", "Run verification for the current platform and that are platform independent. Useful for local testing."), "assemble", Map.of("ForPlatform", "Intended to create build artefacts, without running any tests for the current platform", "PlatformIndependent", "Create platform independent build artefacts", "CombinePlatform", "Create multi platform build artefacts, without running any tests.  This includes the production artifacts and generating documentation for all supported platforms.Assumes that the platform specific artefacts were already published for this version.", "", "Create platform specific artefacts for the current platform and emulate multi platform artefacts based on them. Useful for local testing."), "build", Map.of("ForPlatform", "Create artefacts and run all platform specific verifications for the current platform only.", "PlatformIndependent", "Create artefacts and run all platform independent verifications (that don't depend on platform dependent tasks)", "CombinePlatform", "Create artefacts and  run all verifications for all platforms that can be ran in a platform independent way. Assumes that platform specific artefacts for this version are already published.", "", "Create artefacts and  run verification for the current platform and that are platform independent. Useful for local testing."), "publish", Map.of("ForPlatform", "Create, verify and publish all platform specific artefacts for the current platform only.", "PlatformIndependent", "Create, verify and publish platform independent artefacts (that don't depend on platform dependent tasks)", "CombinePlatform", "Create, verify and publish artefacts multi platform artefacts. Assumes that platform specific artefacts for this version are already published.", "", "Create, verify  and run verification for the current platform and that are platform independent. Useful for local testing."));
        Map<String, String> groupLookup = Map.of("check", "verification", "assemble", "build");
        taskMap.forEach((kind, descriptions) -> {
            descriptions.forEach((name, description) -> {
                Action taskConfig = task -> {
                    if (!kind.equals("publish")) {
                        task.setGroup(groupLookup.getOrDefault(kind, (String)kind));
                    } else {
                        task.setGroup("publishing");
                    }
                    task.setDescription(description);
                };
                if (name.isEmpty()) {
                    tasks.named(kind, taskConfig);
                } else {
                    tasks.register(kind + name, taskConfig);
                }
            });
            tasks.named(kind, task -> task.dependsOn(new Object[]{tasks.named(kind + "ForPlatform"), tasks.named(kind + "PlatformIndependent"), tasks.named(kind + "CombinePlatform")}));
        });
        tasks.named("buildForPlatform", task -> task.dependsOn(new Object[]{"assembleForPlatform", "checkForPlatform"}));
        tasks.named("buildPlatformIndependent", task -> task.dependsOn(new Object[]{"assemblePlatformIndependent", "checkPlatformIndependent"}));
        tasks.named("buildCombinePlatform", task -> task.dependsOn(new Object[]{"assembleCombinePlatform", "checkCombinePlatform"}));
        tasks.named("publishForPlatform", task -> task.dependsOn(new Object[]{"buildForPlatform"}));
        tasks.named("publishPlatformIndependent", task -> task.dependsOn(new Object[]{"buildPlatformIndependent"}));
        tasks.named("publishCombinePlatform", task -> task.dependsOn(new Object[]{"buildCombinePlatform"}));
        tasks.register("checkConsistency", task -> task.doFirst(it -> {
            it.getLogger().info("Checking that tasks aren't added to the base lifecycle tasks only");
            taskMap.keySet().forEach(kind -> {
                Set<String> allLifecycleTasks = taskMap.entrySet().stream().flatMap(entry -> Stream.concat(Stream.of((String)entry.getKey()), ((Map)entry.getValue()).keySet().stream().map(s -> (String)entry.getKey() + s))).collect(Collectors.toSet());
                allLifecycleTasks.add("preCommit");
                HashSet<String> taskToCheck = new HashSet<String>(this.getDependencySet(tasks.getByName(kind), allLifecycleTasks));
                HashSet<String> specializedTasks = new HashSet<String>();
                specializedTasks.addAll(this.getDependencySet(tasks.getByName(kind + "ForPlatform"), allLifecycleTasks));
                specializedTasks.addAll(this.getDependencySet(tasks.getByName(kind + "PlatformIndependent"), allLifecycleTasks));
                specializedTasks.addAll(this.getDependencySet(tasks.getByName(kind + "CombinePlatform"), allLifecycleTasks));
                taskToCheck.removeAll(specializedTasks);
                if (!taskToCheck.isEmpty()) {
                    throw new GradleException("Dependencies '" + taskToCheck + "' for " + kind + " isn't added to any platform specialized lifecycle tasks. Please add it to " + kind + "ForPlatform, " + kind + "PlatformIndependent or " + kind + "ALl");
                }
            });
        }));
        tasks.named("checkPlatformIndependent", task -> task.dependsOn(new Object[]{"checkConsistency"}));
    }

    private Set<String> getDependencySet(Task taskToCheck, Set<String> filter) {
        return taskToCheck.getDependsOn().stream().flatMap(dep -> this.getDependentTaskName(taskToCheck, dep)).filter(each -> !filter.contains(each)).collect(Collectors.toSet());
    }

    private Stream<String> getDependentTaskName(Task taskToCheck, Object dep) {
        String depTaskName;
        if (dep instanceof Task || dep instanceof TaskProvider || dep instanceof String) {
            depTaskName = dep instanceof Task ? ((Task)dep).getName() : (dep instanceof String ? (String)dep : (String)RetryUtils.retry(() -> {
                Object provided = ((TaskProvider)dep).get();
                return ((Task)provided).getName();
            }).maxAttempt(3).execute());
        } else {
            if (dep instanceof TaskDependency) {
                return ((TaskDependency)dep).getDependencies(taskToCheck).stream().map(Task::getName);
            }
            if (dep instanceof NamedDomainObjectProvider) {
                return Stream.of(((NamedDomainObjectProvider)dep).getName());
            }
            throw new GradleException("Unsupported dependency '" + dep + "' for " + taskToCheck + "(" + dep.getClass() + ")");
        }
        return Stream.of(depTaskName);
    }

    private static void whenPluginAddedAddDependency(Project target, TaskProvider<? extends Task> dependency, String resolveAllDependenciesTaskName) {
        target.getPluginManager().withPlugin("co.elastic.lifecycle-multi-arch", p -> target.getTasks().named(resolveAllDependenciesTaskName, task -> task.dependsOn(new Object[]{dependency})));
    }

    public static void publishForPlatform(Project target, TaskProvider<? extends Task> dependency) {
        MultiArchLifecyclePlugin.whenPluginAddedAddDependency(target, dependency, "publishForPlatform");
        LifecyclePlugin.publish(target, dependency);
    }

    public static void checkForPlatform(Project target, TaskProvider<? extends Task> dependency) {
        MultiArchLifecyclePlugin.whenPluginAddedAddDependency(target, dependency, "checkForPlatform");
        LifecyclePlugin.check(target, dependency);
    }

    public static void assembleForPlatform(Project target, TaskProvider<? extends Task> dependency) {
        MultiArchLifecyclePlugin.whenPluginAddedAddDependency(target, dependency, "assembleForPlatform");
        LifecyclePlugin.assemble(target, dependency);
    }

    public static void publishPlatformIndependent(Project target, TaskProvider<? extends Task> dependency) {
        MultiArchLifecyclePlugin.whenPluginAddedAddDependency(target, dependency, "publishPlatformIndependent");
        LifecyclePlugin.publish(target, dependency);
    }

    public static void checkPlatformIndependent(Project target, TaskProvider<? extends Task> dependency) {
        MultiArchLifecyclePlugin.whenPluginAddedAddDependency(target, dependency, "checkPlatformIndependent");
        LifecyclePlugin.check(target, dependency);
    }

    public static void assemblePlatformIndependent(Project target, TaskProvider<? extends Task> dependency) {
        MultiArchLifecyclePlugin.whenPluginAddedAddDependency(target, dependency, "assemblePlatformIndependent");
        LifecyclePlugin.assemble(target, dependency);
    }

    public static void publishCombinePlatform(Project target, TaskProvider<? extends Task> dependency) {
        MultiArchLifecyclePlugin.whenPluginAddedAddDependency(target, dependency, "publishCombinePlatform");
        LifecyclePlugin.publish(target, dependency);
    }

    public static void checkCombinePlatform(Project target, TaskProvider<? extends Task> dependency) {
        MultiArchLifecyclePlugin.whenPluginAddedAddDependency(target, dependency, "checkCombinePlatform");
        LifecyclePlugin.check(target, dependency);
    }

    public static void assembleCombinePlatform(Project target, TaskProvider<? extends Task> dependency) {
        MultiArchLifecyclePlugin.whenPluginAddedAddDependency(target, dependency, "assembleCombinePlatform");
        LifecyclePlugin.assemble(target, dependency);
    }
}

